% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCo_iter.R
\name{DiSCo_iter}
\alias{DiSCo_iter}
\title{Estimate DiSCo in a single period}
\usage{
DiSCo_iter(
  yy,
  df,
  evgrid,
  id_col.target,
  M,
  G,
  T0,
  qmethod = NULL,
  q_min = 0,
  q_max = 1,
  simplex = FALSE,
  controls.id
)
}
\arguments{
\item{yy}{Integer indicating the current year being processed.}

\item{df}{Data frame or data table containing the distributional data for the target and control units. The data table should contain the following columns:
\itemize{
\item \code{y_col } A numeric vector containing the outcome variable for each unit. Units can be individuals, states, etc., but they should be nested within a larger unit (e.g. individuals or counties within a state)
\item \code{id_col } A numeric vector containing the aggregate IDs of the units. This could be, for example, the state if the units are counties or individuals
\item \code{time_col } A vector containing the time period of the observation for each unit. This should be a monotonically increasing integer.
}}

\item{evgrid}{A vector of grid points on which to evaluate the quantile functions.}

\item{id_col.target}{Variable indicating the name of the target unit, as specified in the id_col column of the data table.
This variable can be any type, as long as it is the same type as the id_col column of the data table.}

\item{M}{Integer indicating the number of control quantiles to use in the DiSCo method. Default is 1000.}

\item{G}{Integer indicating the number of grid points for the grid on which the estimated functions are evaluated. Default is 1000.}

\item{T0}{Integer indicating the last pre-treatment period starting from 1.}

\item{qmethod}{Character, indicating the method to use for computing the quantiles of the target distribution. The default is NULL, which uses the \code{\link[stats]{quantile}} function from the stats package.
Other options are "\code{\link[evmix]{qkden}}" (based on smoothed kernel density function) and "\code{\link[extremeStat:distLquantile]{extreme}}" (based on parametric extreme value distributions).
Both are substantially slower than the default method but may be useful for fat-tailed distributions with few data points at the upper quantiles. Alternatively, one could use the q_max option to restrict the range of quantiles used.}

\item{q_min}{Numeric, minimum quantile to use. Set this together with \code{q_max} to restrict the range of quantiles used to construct the synthetic control. Default is 0 (all quantiles).}

\item{q_max}{Numeric, maximum quantile to use. Set this together with \code{q_min} to restrict the range of quantiles used to construct the synthetic control. Default is 1 (all quantiles).}

\item{simplex}{Logical, indicating whether to use to constrain the optimal weights to the unit simplex. Default is FALSE, which only constrains the weights to sum up to 1 but allows them to be negative.}

\item{controls.id}{List of strings specifying the column names for the control units' identifiers.}
}
\value{
A list with the following elements:
\itemize{
\item \code{DiSCo_weights } Weights calculated using the DiSCo method.
\item \code{mixture }
\itemize{
\item \code{weights } Optimal weights for the mixture approach.
\item \code{distance } Value of the objective function for the mixture approach.
\item \code{mean } Weighted mixture of the controls' CDFs.
}

\item \code{target }
\itemize{
\item \code{cdf } Empirical CDF of the target.
\item \code{grid } Grid on which the quantile and CDF functions were evaluated.
\item \code{data } Original data for the target unit.
\item \code{quantiles } Quantiles for the target unit, evaluated on the specified grid.
}

\item \code{controls }
\itemize{
\item \code{data } Original data for the control units.
\item \code{cdf } Empirical CDFs of the control units.
\item \code{quantiles } Quantiles for the control units, evaluated on the specified grid.
.
}
\item \code{controls.q } Quantiles for the control units, evaluated on the specified grid.
}
}
\description{
This function implements the DiSCo method for a single time period, as well as the mixture of distributions approach.
Its return values contain valuable period-specific estimation outputs.
}
\details{
This function is part of the DiSCo method, called for each time period.
It calculates the optimal weights for the DiSCo method and the mixture of
distributions approach for a single time period. The function processes data f
or both the target and control units, computes the quantile functions,
and evaluates these on a specified grid. The function is designed to be used
within the broader context of the DiSCo function, which aggregates results
across multiple time periods.
}
