% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aD.R
\name{aD}
\alias{aD}
\title{Decreasing Life Annuities}
\usage{
aD(
  x,
  h,
  n,
  k = 1,
  i = 0.04,
  data,
  prop = 1,
  assumption = "none",
  variation = "none",
  cap = 1
)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of payments per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{variation}{A character string. "inter" if the variation it's interannual or "intra" if it's intra-annual.}

\item{cap}{A numeric type value. The annualized value of the first payment.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of a decreasing life annuity.
}
\examples{
aD(27,0,3,1,0.04,CSO80MANB,1,"none","none",1)
aD(32,2,8,1,0.04,CSO80MANB,1,"none","none",1)
aD(35,8,15,4,0.04,CSO80MANB,1,"constant","inter",1)
aD(21,2,5,4,0.04,CSO80MANB,1,"UDD","inter",1)
aD(54,4,16,2,0.04,CSO80MANB,1,"constant","intra",1)
aD(20,10,15,3,0.04,CSO80MANB,1,"UDD","intra",1)

}
\references{
Chapter 2 of  Life Contingencies (1952) by Jordan, chapter 5 of  Actuarial Mathematics (1997) by Bowers, Gerber, Hickman, Jones & Nesbitt.
}
\keyword{Annuities}
\keyword{Decreasing}
\keyword{Life}
