% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_discontinuity_designer.R
\name{regression_discontinuity_designer}
\alias{regression_discontinuity_designer}
\title{Create a regression discontinuity design}
\usage{
regression_discontinuity_designer(
  N = 1000,
  tau = 0.15,
  outcome_sd = 0.1,
  cutoff = 0.5,
  bandwidth = 0.5,
  control_coefs = c(0.5, 0.5),
  treatment_coefs = c(-5, 1),
  poly_reg_order = 4,
  args_to_fix = NULL
)
}
\arguments{
\item{N}{An integer. Size of population to sample from.}

\item{tau}{A number. Difference in potential outcomes functions at the threshold.}

\item{outcome_sd}{A positive number. The standard deviation of the outcome.}

\item{cutoff}{A number in (0,1). Threshold on running variable beyond which units are treated.}

\item{bandwidth}{A number. The value of the bandwidth on both sides of the threshold from which to include units.}

\item{control_coefs}{A vector of numbers. Coefficients for polynomial regression function that generates control potential outcomes. Order of polynomial is equal to length.}

\item{treatment_coefs}{A vector of numbers. Coefficients for polynomial regression function that generates treatment potential outcomes. Order of polynomial is equal to length.}

\item{poly_reg_order}{Integer greater than or equal to 1. Order of the polynomial regression used to estimate the jump at the cutoff.}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design.}
}
\value{
A regression discontinuity design.
}
\description{
Builds a design with sample from population of size \code{N}. The average treatment effect local to the cutpoint is equal to \code{tau}. It allows for specification of the order of the polynomial regression (\code{poly_reg_order}), cutoff value on the running variable (\code{cutoff}), and size of bandwidth around the cutoff (\code{bandwidth}). By providing a vector of numbers to \code{control_coefs} and \code{treatment_coefs}, users can also specify polynomial regression coefficients that generate the expected control and treatment potential outcomes given the running variable.
}
\details{
See \href{https://declaredesign.org/r/designlibrary/articles/regression_discontinuity.html}{vignette online}.
}
\examples{
# Generate a regression discontinuity design using default arguments:
regression_discontinuity_design <- regression_discontinuity_designer()
}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{observational}
\concept{regression discontinuity}
