% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{phat}
\alias{phat}
\title{Point estimator for the power value}
\usage{
phat(
  r,
  N1,
  N2,
  N3,
  E = NULL,
  sig = NULL,
  sd_full,
  delta = NULL,
  delta_linear_bd,
  seed = NULL
)
}
\arguments{
\item{r}{vector for the proportion for each sub-population, r_1is 1, r_i>r_{i+1}}

\item{N1}{integer, which is fixed as 10240 in our package}

\item{N2}{integer, which is fixed as 20480 in our package}

\item{N3}{integer, the number of grid point for the sig.lv, which should be the multiples of 5, because we apply 5 stream parallel}

\item{E}{integer, the total number of events for the Phase 3 clinical trail, if not specified, then an estimation will be applied}

\item{sig}{the vector of standard deviation of each sub-population}

\item{sd_full}{a numeric number, which denotes the prior information of standard deviation for the harzard reduction. If sig is not specified, then sd_full must has an input value to define the standard deviation of the full population}

\item{delta}{vector, the point estimation of harzard reduction in prior information, if not specified we apply a linear scheme by giving bound to the linear harzard reduction}

\item{delta_linear_bd}{vector of length 2, specifying the upper bound and lower bound for the harzard reduction; if user don't specify the delta for each sub-population, then the linear scheme will apply and the input is a must.}

\item{seed}{integer,  seed for random number generation}
}
\value{
list of 2 parts of the sampling points given specific r; alpha is the matrix as each row is the given sig.lv for each population; power is the corresponding power values given each row of the alpha
}
\description{
This function is to estimate the power values given fixed proportion r for each sub-population, which we utilize Monte Carlo method and GPU accelerator to estimate the power value. The user can specify the standard deviation and harzard reduction for each sub-population as the prior information of harzard reduction distribution, when not specified, we apply a default setting of linear harzard reduction scheme and the sd for each sub-population is inversely proportional to sqrt(r_i)
}
\details{
We interface python by reticulate package to utilize numba(cuda version) module to accelerate calculation.
}
