% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpectedRep.R
\name{ExpectedRepresentation}
\alias{ExpectedRepresentation}
\title{Compute the expected degree of representation for any group in a political body}
\usage{
ExpectedRepresentation(PopShares, BodyN, a = -0.5, b = 1)
}
\arguments{
\item{PopShares}{A numeric vector containing the group-level population proportions.}

\item{BodyN}{A positive integer denoting the size of the political body in question.}

\item{a, b}{The \code{a} and \code{b} parameters control the affine transformation for how the representation measure is summarized.
That is, \code{a} and \code{b} control how the expected L1 deviation of the population shares from the body shares
is re-weighted. The expected L1 deviation is the average value of the absolute deviation of the population from body shares under
a random sampling model. This expected L1 deviation is multiplied by \code{a}; \code{b} is as an additive re-scaling term: \code{a*E[L1]+b}.
By default, \code{a=-0.5} and \code{b=1} so that the expected Rose Index of Proportionality is returned.}
}
\value{
The expected degree of representation (a scalar).
}
\description{
Finds the degree of expected representation for any group in a political body under a random sampling model as described in Gerring, Jerzak and Oncel (2024).
}
\section{References}{

\itemize{
\item John Gerring, Connor T. Jerzak, Erzen Oncel. (2024),
The Composition of Descriptive Representation,
\emph{American Political Science Review}, 118(2): 784-801.
\doi{10.1017/S0003055423000680}
}
}

\examples{

ExpectedRep <- ExpectedRepresentation(PopShares = c(1/4, 2/4, 1/4),
                                      BodyN = 50)

print( ExpectedRep )

}
\seealso{
\itemize{
\item \code{\link{ObservedRepresentation}} for calculating representation scores from observed data.
\item \code{\link{SDRepresentation}} for calculating representation unexplained under the random sampling model.
}
}
