% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{read_redcap_formatted}
\alias{read_redcap_formatted}
\title{Convencience function to load datasets downloaded from a Redcap database}
\usage{
read_redcap_formatted(path_to_redcap_script = NULL)
}
\arguments{
\item{path_to_redcap_script}{(character) Path to the (automatically generated) redcap script for data import}
}
\value{
tibble with data
}
\description{
This function is specifically tailored to the way the default import script
provided by a Redcap database functions. First, the \code{Hmisc} package is loaded.
The .csv file containing the data is assumed to be located in the current working directory.
Labels are assigned to all variables. Variables which are supposed to be factors are twice,
once as a factor and once in an unformatted way.
}
\details{
This script removes the "unformatted factor" variables and properly assignes labels.
}
\examples{
path_to_redcap_script <- system.file("examples", "testredcap.r", package = "DescrTab2")
read_redcap_formatted(path_to_redcap_script)
}
