\name{TOne}
\alias{TOne}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Create Table One Describing Baseline Characteristics
%%  ~~function to do ... ~~
}
\description{
Create a table summarizing continuous, categorical and dichotomous variables, optionally stratified by one or more variables, while performing adequate statistical tests.
}
\usage{
TOne(x, grp = NA, add.length = TRUE, colnames = NULL, vnames = NULL, 
     total = TRUE, align = "\\\\l", 
     FUN = NULL, TEST = NULL, intref = "high",
     fmt = list(abs = Fmt("abs"), num  = Fmt("num"), per = Fmt("per"),
                pval = as.fmt(fmt = "*", na.form = "   ")) )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a data.frame containing all the variables to be included in the table.
%%     ~~Describe \code{x} here~~
}
  \item{grp}{the grouping variable.
%%     ~~Describe \code{grp} here~~
}
  \item{add.length}{logical. If set to \code{TRUE} (default), a row with the group sizes will be inserted as first row of the table.
%%     ~~Describe \code{grp} here~~
}
  \item{colnames}{a vector of column names for the result table.
%%     ~~Describe \code{grp} here~~
}
  \item{vnames}{a vector of variable names to be placed in the first column instead of the real names.
%%     ~~Describe \code{grp} here~~
}
\item{total}{logical (default \code{TRUE}), defines whether the results should also be displayed for the whole, ungrouped variable.}

  \item{align}{the character on whose position the strings will be aligned. Left alignment can be requested by setting \code{sep = "\\\\l"}, right alignment by \code{"\\\\r"} and center alignment by \code{"\\\\c"}. Mind the backslashes, as if they are omitted, strings would be aligned to the \bold{character} \bold{l}, \bold{r} or \bold{c} respectively. Default value is \code{"\\\\l"}, thus left alignment.
%%     ~~Describe \code{sep} here~~
}
\item{FUN}{the function to be used as location and dispersion measure for numeric (including integer) variables (\code{mean}/\code{sd} is default, alternatives as \code{median}/\code{IQR} are possible by defining a function). See examples.}

\item{TEST}{a list of functions to be used to test the variables. Must be named as \code{"num"}, \code{"cat"} and \code{"dich"} and be defined as function with arguments \code{(x, g)}, generating something similar to a p-value. Use \code{TEST=NA} to suppress test. (See examples.) }

\item{intref}{one out of \code{"high"} (default) or \code{"low"}, defining which value of a dichotomous numeric or logical variable should be reported. Usually this will be \code{1} or \code{TRUE}. Setting it to \code{"low"} will report the lower value \code{0} or \code{FALSE}. }

\item{fmt}{format codes for absolute, numeric and percentage values, and for the p-values of the tests. }
}
\details{In research the characteristics of study populations are often characterised through some kind of a "Table 1", containing descriptives of the used variables, as mean/standard deviation for continuous variables, and proportions for categorical variables. In many cases, a comparison is made between groups within the framework of the scientific question. 

\preformatted{
  var             Brent           Camden          Westminster                    
  n                 474 (39.5\%)     344 (28.7\%)     381 (31.8\%)                  
  temperature      51.1 (8.7)      47.4 (10.1)     44.3 (9.8)     *** '          
  driver                                                          *** "'          
    Butcher          72 (15.2\%)       1 (0.3\%)       22 (5.8\%)                   
    Carpenter        29 (6.1\%)       19 (5.6\%)      221 (58.2\%)                  
    Carter          177 (37.4\%)      47 (13.8\%)       5 (1.3\%)                   
    Farmer           19 (4.0\%)       87 (25.5\%)      11 (2.9\%)                   
    Hunter          128 (27.1\%)       4 (1.2\%)       24 (6.3\%)                   
    Miller            6 (1.3\%)       41 (12.0\%)      77 (20.3\%)                  
    Taylor           42 (8.9\%)      142 (41.6\%)      20 (5.3\%)                   
  rabate (= TRUE)   235 (50.3\%)     172 (50.3\%)     184 (48.7\%)       "'          
  ---
  ') Kruskal-Wallis test, ") Fisher exact test, "') Chi-Square test
  Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1 
}

Creating such a table can be very time consuming and there's a need for a flexible function that helps us to solve the task. \code{TOne()} is designed to be easily used with sensible defaults, and yet flexible enough to allow free definition of the essential design elements.

This is done by breaking down the descriptive task to three types of variables: quantitative (numeric, integer), qualitative (factor, characters) and dichotomous variables (the latter having exactly two values or levels). Depending on the variable type, the descriptives and the according sensible tests are chosen. By default mean/sd are chosen to describe numeric variables. 
\preformatted{  FUN = function(x) gettextf("\%s / \%s",
                             Format(mean(x, na.rm = TRUE), digits = 1),
                             Format(sd(x, na.rm = TRUE), digits = 3)) 
}

Their difference is tested with the Kruskal-Wallis test. For categorical variables the absolute and relative frequencies are calculated and tested with a chi-square test. \cr The tests can be changed with the argument \code{TEST}. These must be organised as list containing elements named \code{"num"}, \code{"cat"} and \code{"dich"}. Each of them must be a function with arguments \code{(x, g)}, returning something similar to a p-value. 
\preformatted{  TEST = list(
            num  = list(fun = function(x, g){summary(aov(x ~ g))[[1]][1, "Pr(>F)"]},
                        lbl = "ANOVA"),
            cat  = list(fun = function(x, g){chisq.test(table(x, g))$p.val},
                        lbl = "Chi-Square test"),
            dich = list(fun = function(x, g){fisher.test(table(x, g))$p.val},
                        lbl = "Fisher exact test"))
}
The legend text of the test, which is appended to the table together with the significance codes, can be set with the variable \code{lbl}.

Great importance was attached to the free definition of the number formats. By default, the optionally definable format templates of \bold{DescTools} are used. Deviations from this can be freely passed as arguments to the function. Formats can be defined for integers, floating point numbers, percentages and for the p-values of statistical tests. All options of the function \code{\link{Format}()} are available and can be provided as a list. See examples which show several different implementations.
\preformatted{  fmt = list(abs  = Fmt("abs"), 
             num  = Fmt("num"), 
             per  = Fmt("per"),
             pval = as.fmt(fmt = "*", na.form = "   ")) 
}

The function returns a character matrix as result, which can easily be subset or combined with other matrices. An interface for \code{\link{ToWrd}()} is available such that the matrix can be transferred to MS-Word. Both font and alignment are freely selectable in the Word table. 
%%  ~~ If necessary, more details than the description above ~~
}
\value{a character matrix
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\author{Andri Signorell <andri@signorell.net>
%%  ~~who you are~~
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{WrdTable}()}, \code{\link{ToWrd.TOne}()}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
options(scipen = 8)
opt <- DescToolsOptions()

# define some special formats for count data, percentages and numeric results
# (those will be supported by TOne)
Fmt(abs = as.fmt(digits = 0, big.mark = "'"))   # counts
Fmt(per = as.fmt(digits = 1, fmt = "\%"))        # percentages
Fmt(num = as.fmt(digits = 1, big.mark = "'"))   # numeric

TOne(x = d.pizza[, c("temperature", "delivery_min", "driver", "wine_ordered")],
  grp = d.pizza$quality)

# the same but no groups now...
TOne(x = d.pizza[, c("temperature", "delivery_min", "driver", "wine_ordered")])

# define median/IQR as describing functions for the numeric variables
TOne(iris[, -5], iris[, 5],
  FUN = function(x) {
    gettextf("\%s / \%s",
      Format(median(x, na.rm = TRUE), digits = 1), 
      Format(IQR(x, na.rm = TRUE), digits = 3))
  }
)

# replace kruskal.test by ANOVA and report the p.value
# Change tests for all the types
TOne(x = iris[, -5], grp = iris[, 5],
     FUN = function(x) gettextf("\%s / \%s",
            Format(mean(x, na.rm = TRUE), digits = 1),
            Format(sd(x, na.rm = TRUE), digits = 3)), 

     TEST = list(
       num = list(fun = function(x, g){summary(aov(x ~ g))[[1]][1, "Pr(>F)"]},
                        lbl = "ANOVA"),
               cat = list(fun = function(x, g){chisq.test(table(x, g))$p.val},
                        lbl = "Chi-Square test"),
               dich = list(fun = function(x, g){fisher.test(table(x, g))$p.val},
                         lbl = "Fisher exact test")),
       fmt = list(abs = Fmt("abs"), num  = Fmt("num"), per = Fmt("per"),
                pval = as.fmt(fmt = "*", na.form = "   ")) 
)

t1 <- TOne(x     = d.pizza[,c("temperature", "driver", "rabate")], 
           grp   = d.pizza$area, 
           align = " ", 
           total = FALSE,
            
           FUN = function(x) gettextf("\%s / \%s (\%s)",
                                      Format(mean(x, na.rm = TRUE), digits = 1),
                                      Format(sd(x, na.rm = TRUE), digits = 3),
                                      Format(median(x, na.rm = TRUE), digits = 1)),
           
           TEST = NA,
            
           fmt = list(abs  = as.fmt(big.mark = " ", digits=0), 
                      num  = as.fmt(big.mark = " ", digits=1), 
                      per  = as.fmt(fmt=function(x) 
                          StrPad(Format(x, fmt="\%", d=1), width=5, adj = "r")), 
                      pval = as.fmt(fmt = "*", na.form = "   ")) 
)
# add a userdefined legend
attr(t1, "legend") <- "numeric: mean / sd (median)), factor: n (n\%)"

t1


# dichotomous integer or logical values can be reported by the high or low value
x <- sample(x = c(0, 1), size = 100, prob = c(0.3, 0.7), replace = TRUE)
y <- sample(x = c(0, 1), size = 100, prob = c(0.3, 0.7), replace = TRUE) == 1
z <- factor(sample(x = c(0, 1), size = 100, prob = c(0.3, 0.7), replace = TRUE))
g <- sample(x = letters[1:4], size = 100, replace = TRUE)
d.set <- data.frame(x = x, y = y, z = z, g = g)

TOne(d.set[1:3], d.set$g, intref = "low")

TOne(d.set[1:3], d.set$g, intref = "high")

# intref would not control factors, use relevel to change reported value
TOne(data.frame(z = relevel(z, "1")), g)

TOne(data.frame(z = z), g)

options(opt)


\dontrun{  
  
# Send the whole stuff to Word
wrd <- GetNewWrd()
ToWrd(
  TOne(x   = d.pizza[, c("temperature", "delivery_min", "driver", "wine_ordered")],
       grp = d.pizza$quality,
       fmt = list(num=Fmt("num", digits=1))
       ),
  font = list(name="Arial narrow", size=8),
  align = c("l","r")      # this will be recycled: left-right-left-right ...
)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{IO }
