% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darwinLint.R
\name{darwinLintScore}
\alias{darwinLintScore}
\title{darwinLintScore}
\usage{
darwinLintScore(lintFunction, ...)
}
\arguments{
\item{lintFunction}{Lint function to use}

\item{...}{Other parameters a Lint function might need (i.e. file name)}
}
\value{
A tibble of percentage scores per type of Lint message.
}
\description{
Function that scores the lintr output as a percentage per message type
(style, warning, error). Lintr messages / lines assessed * 100
}
\examples{
# With darwin file lintr
darwinLintScore(
  lintFunction = darwinLintFile,
  system.file(package = "DependencyReviewer", "testScript.R")
)

# With standard package lintr
darwinLintScore(
  lintFunction = lintr::lint_package,
  system.file(package = "DependencyReviewer")
)
}
