/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;

public class VariableSelector
extends JPanel
implements ActionListener,
KeyListener {
    private JComboBox dataComboBox;
    private DefaultComboBoxModel dataComboBoxModel;
    private DJList variableList;
    private JTextField filter;
    private JLabel filterText;
    private String rFilter = "";
    private String splitStr = null;

    public VariableSelector() {
        this.initGUI();
        try {
            this.refreshDataNames();
            this.dataComboBox.setSelectedItem(Deducer.getRecentData());
            String string = (String)this.dataComboBox.getSelectedItem();
            if (string != null) {
                try {
                    this.variableList.setModel(new FilteringModel(Deducer.eval("names(" + string + ")").asStrings()));
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }
        }
        catch (Exception exception) {
            this.variableList.setModel(new DefaultListModel());
            this.dataComboBox.setModel(new DefaultComboBoxModel());
            new ErrorMsg(exception);
        }
    }

    private void initGUI() {
        try {
            this.setName("Variable Selector");
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(194, 294));
            this.setBorder(BorderFactory.createEtchedBorder(1));
            this.dataComboBoxModel = new DefaultComboBoxModel();
            this.dataComboBox = new JComboBox();
            this.dataComboBox.setModel(this.dataComboBoxModel);
            this.dataComboBox.addActionListener(this);
            this.filterText = new JLabel();
            this.filterText.setText("  Filter:");
            this.filter = new JTextField();
            this.add((Component)this.filter, new AnchorConstraint(25, 970, 147, 62, 2, 1, 0, 2));
            this.add((Component)this.filterText, new AnchorConstraint(30, 260, 144, 30, 2, 0, 0, 1));
            this.add((Component)this.dataComboBox, new AnchorConstraint(1, 999, 79, 2, 1, 1, 0, 1));
            this.dataComboBox.setPreferredSize(new Dimension(164, 22));
            this.filterText.setPreferredSize(new Dimension(55, 15));
            this.filter.setPreferredSize(new Dimension(103, 21));
            this.filter.addKeyListener(this);
            FilteringModel filteringModel = new FilteringModel(new String[]{"No Data."});
            this.variableList = new VarDJList();
            this.variableList.setModel(filteringModel);
            JScrollPane jScrollPane = new JScrollPane(this.variableList, 22, 31);
            this.add((Component)jScrollPane, new AnchorConstraint(50, 999, 1001, 3, 2, 1, 1, 1));
            jScrollPane.setPreferredSize(new Dimension(164, 224));
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void refreshDataNames() {
        Deducer.refreshData();
        String string = this.getSelectedData();
        this.dataComboBox.removeActionListener(this);
        this.dataComboBoxModel.removeAllElements();
        for (int i = 0; i < Deducer.getData().size(); ++i) {
            this.dataComboBoxModel.addElement(((RObject)Deducer.getData().elementAt(i)).getName());
        }
        if (string != null) {
            this.setSelectedData(string);
        }
        this.dataComboBox.addActionListener(this);
        this.reset();
    }

    public void add(Object object) {
        String string = (String)object;
        if (this.splitStr != null && string.indexOf(this.splitStr) > 0) {
            string = string.substring(0, string.indexOf(this.splitStr));
        }
        ((FilteringModel)this.variableList.getModel()).addElement(string);
    }

    public boolean remove(Object object) {
        String string = (String)object;
        if (this.splitStr != null && string.indexOf(this.splitStr) > 0) {
            string = string.substring(0, string.indexOf(this.splitStr));
        }
        return ((FilteringModel)this.variableList.getModel()).removeElement(string);
    }

    public boolean removeAll(DefaultListModel defaultListModel) {
        if (defaultListModel == null) {
            return false;
        }
        if (defaultListModel.getSize() == 0) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            String string = (String)defaultListModel.get(i);
            bl = this.remove(string);
            if (bl) continue;
            try {
                if (this.getJComboBox().getSelectedItem() == null) break;
                this.getJList().setModel(new FilteringModel(Deducer.eval("names(" + this.getJComboBox().getSelectedItem() + ")").asStrings()));
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
            break;
        }
        return bl;
    }

    public JList getJList() {
        return this.variableList;
    }

    public JComboBox getJComboBox() {
        return this.dataComboBox;
    }

    public void setSelectedData(String string) {
        this.dataComboBox.setSelectedItem(string);
    }

    public String getSelectedData() {
        return (String)this.dataComboBox.getSelectedItem();
    }

    public ArrayList getSelectedVariables() {
        Object[] objectArray = this.variableList.getSelectedValues();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public void setRFilter(String string) {
        this.rFilter = string;
        ((FilteringModel)this.variableList.getModel()).filter(this.filter.getText());
    }

    public void reset() {
        String string = (String)this.dataComboBox.getSelectedItem();
        try {
            if (string != null) {
                this.variableList.setModel(new FilteringModel(Deducer.eval("names(" + string + ")").asStrings()));
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
        this.filter.setText("");
        ((FilteringModel)this.variableList.getModel()).filter(this.filter.getText());
    }

    public void setDropStringSplitter(String string) {
        this.splitStr = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "comboBoxChanged") {
            this.reset();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                ((FilteringModel)VariableSelector.this.variableList.getModel()).filter(VariableSelector.this.filter.getText());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private class VarDJList
    extends DJList {
        private VarDJList() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            String string = (String)VariableSelector.this.dataComboBox.getSelectedItem();
            REXP rEXP = null;
            rEXP = Deducer.eval("names(" + string + ")");
            if (rEXP == null) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            String[] stringArray = null;
            try {
                stringArray = rEXP.asStrings();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
            super.drop(dropTargetDropEvent);
            FilteringModel filteringModel = (FilteringModel)this.getModel();
            int n = filteringModel.getUnfilteredSize();
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                String string3 = (String)filteringModel.getUnfilteredElementAt(i);
                if (VariableSelector.this.splitStr != null && string3.indexOf(VariableSelector.this.splitStr) > 0) {
                    string3 = string3.substring(0, string3.indexOf(VariableSelector.this.splitStr));
                }
                boolean bl = false;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string3.equals(stringArray[j])) continue;
                    bl = true;
                    string2 = stringArray[j];
                }
                if (bl) {
                    filteringModel.removeUnfilteredElementAt(i);
                    filteringModel.addUnfilteredElementAt(i, string2);
                    string2 = null;
                    continue;
                }
                ((FilteringModel)this.getModel()).removeUnfilteredElementAt(i);
            }
        }
    }

    public class FilteringModel
    extends DefaultListModel {
        List list = new ArrayList();
        List filteredList = new ArrayList();
        String lastFilter = "";

        public FilteringModel() {
        }

        public FilteringModel(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.list.add(stringArray[i]);
                this.filteredList.add(stringArray[i]);
            }
        }

        public void add(int n, Object object) {
            int n2 = n > this.filteredList.size() - 1 ? this.list.size() : this.list.indexOf(this.filteredList.get(n));
            if (n2 < 0) {
                n2 = 0;
            }
            this.list.add(n2, object);
            this.filter(this.lastFilter);
        }

        public void addElement(Object object) {
            this.list.add(object);
            this.filter(this.lastFilter);
        }

        public boolean removeElement(Object object) {
            boolean bl = this.list.remove(object);
            this.filter(this.lastFilter);
            return bl;
        }

        public Object remove(int n) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.filteredList.get(n).equals(this.filteredList.get(i))) continue;
                ++n2;
            }
            Object e = this.filteredList.remove(n);
            if (n2 == 0) {
                this.list.remove(e);
                this.filter(this.lastFilter);
                return e;
            }
            int n3 = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get(i).equals(e)) continue;
                if (n3 == n2) {
                    this.list.remove(i);
                }
                ++n3;
            }
            this.filter(this.lastFilter);
            return e;
        }

        public int getSize() {
            return this.filteredList.size();
        }

        public int getUnfilteredSize() {
            return this.list.size();
        }

        public Object getElementAt(int n) {
            Object var2_2 = n < this.filteredList.size() ? this.filteredList.get(n) : null;
            return var2_2;
        }

        public Object getUnfilteredElementAt(int n) {
            Object e = this.list.get(n);
            this.filter(this.lastFilter);
            return e;
        }

        public Object removeUnfilteredElementAt(int n) {
            Object e = this.list.remove(n);
            this.filter(this.lastFilter);
            return e;
        }

        public void addUnfilteredElementAt(int n, Object object) {
            this.list.add(n, object);
            this.filter(this.lastFilter);
        }

        void filter(String string) {
            this.filteredList.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                Object e = this.list.get(i);
                if (e.toString().toLowerCase().indexOf(string.toLowerCase(), 0) == -1) continue;
                if (VariableSelector.this.rFilter != "") {
                    REXP rEXP = new REXP();
                    rEXP = Deducer.eval(VariableSelector.this.rFilter + "(" + (String)VariableSelector.this.dataComboBox.getSelectedItem() + "$" + (String)e + ")");
                    if (!rEXP.isLogical() || !((REXPLogical)rEXP).isTRUE()[0]) continue;
                    this.filteredList.add(e);
                    continue;
                }
                this.filteredList.add(e);
            }
            this.lastFilter = string;
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

