/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;

public class SVarSet {
    protected List vars = new ArrayList();
    protected SMarker mark;
    protected String name = "<unknown>";
    public int globalMisclassVarID = -1;
    public int globalResudialStat1ID = -1;
    public int globalResudialStat2ID = -1;
    public int classifierCounter = 1;
    public int regressionCounter = 0;

    public void setMarker(SMarker sMarker) {
        this.mark = sMarker;
        sMarker.masterSet = this;
    }

    public SMarker getMarker() {
        return this.mark;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int length() {
        int n = 0;
        int n2 = this.vars.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = ((SVar)this.vars.get(i)).size();
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    public int add(SVar sVar) {
        if (sVar == null) {
            return -1;
        }
        String string = sVar.getName();
        if (string == null) {
            return -1;
        }
        if (!this.vars.isEmpty()) {
            ListIterator listIterator = this.vars.listIterator();
            while (listIterator.hasNext()) {
                SVar sVar2 = (SVar)listIterator.next();
                if (sVar2.getName().compareTo(string) != 0) continue;
                return -2;
            }
        }
        this.vars.add(sVar);
        return this.vars.indexOf(sVar);
    }

    public void insert(int n, SVar sVar) {
        this.insert("Var" + n, n, sVar);
    }

    public void insert(String string, int n, SVar sVar) {
        if (sVar.getName() == null) {
            sVar.setName(string);
        }
        this.vars.add(n, sVar);
    }

    public void move(int n, int n2) {
        SVar sVar = (SVar)this.vars.get(n);
        this.vars.remove(n);
        this.vars.add(n2, sVar);
    }

    public void remove(int n) {
        this.vars.remove(n);
    }

    public boolean insertCaseAt(int n) {
        ListIterator listIterator = this.vars.listIterator();
        while (listIterator.hasNext()) {
            if (((SVar)listIterator.next()).insert(null, n)) continue;
            return false;
        }
        return true;
    }

    public boolean removeCaseAt(int n) {
        ListIterator listIterator = this.vars.listIterator();
        while (listIterator.hasNext()) {
            SVar sVar = (SVar)listIterator.next();
            if (sVar.remove(n)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String string) {
        for (int i = 0; i < this.vars.size(); ++i) {
            SVar sVar = (SVar)this.vars.get(i);
            if (sVar.getName().compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }

    public SVar byName(String string) {
        if (this.vars.isEmpty()) {
            return null;
        }
        ListIterator listIterator = this.vars.listIterator();
        while (listIterator.hasNext()) {
            SVar sVar = (SVar)listIterator.next();
            if (sVar.getName().compareTo(string) != 0) continue;
            return sVar;
        }
        return null;
    }

    public SVar at(int n) {
        return n < 0 || n >= this.vars.size() ? null : (SVar)this.vars.get(n);
    }

    public void replace(int n, SVar sVar) {
        if (n >= 0 && n < this.vars.size()) {
            this.vars.set(n, sVar);
        }
    }

    public Object data(String string, int n) {
        SVar sVar = this.byName(string);
        return sVar == null ? null : sVar.elementAt(n);
    }

    public Object data(int n, int n2) {
        SVar sVar = this.at(n);
        return sVar == null ? null : sVar.elementAt(n2);
    }

    public int[] whereis(Object object, int n, int n2) {
        int[] nArray = new int[]{-1, -1};
        for (int i = n2; i < this.at(0).size(); ++i) {
            int n3;
            int n4 = n3 = n != 0 ? n : 0;
            while (n3 < this.vars.size()) {
                if (this.at(n3).at(i) != null && this.at(n3).at(i).toString().toLowerCase().indexOf(object.toString().toLowerCase()) != -1) {
                    nArray[0] = n3;
                    nArray[1] = i;
                    return nArray;
                }
                ++n3;
            }
            n = 0;
        }
        return nArray;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SVarSet.this.vars.listIterator();
            }

            public Object nextElement() {
                return this.iter.next();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }
        };
    }

    public int count() {
        return this.vars.size();
    }

    public boolean Export(PrintStream printStream, boolean bl) {
        return this.Export(printStream, bl, null);
    }

    public boolean Export(PrintStream printStream) {
        return this.Export(printStream, true, null);
    }

    public boolean Export(PrintStream printStream, boolean bl, int[] nArray) {
        boolean bl2 = bl || this.mark == null || this.mark.marked() == 0;
        try {
            if (printStream != null) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                if (nArray == null || nArray.length < 1) {
                    for (n = 0; n < this.count(); ++n) {
                        printStream.print((n2 == 0 ? "" : "\t") + this.at(n).getName());
                        if (n2 == 0) {
                            n3 = n;
                        }
                        ++n2;
                    }
                } else {
                    while (n < nArray.length) {
                        printStream.print((n2 == 0 ? "" : "\t") + this.at(nArray[n]).getName());
                        if (n2 == 0) {
                            n3 = nArray[n];
                        }
                        ++n2;
                        ++n;
                    }
                }
                printStream.println("");
                for (int i = 0; i < this.at(n3).size(); ++i) {
                    Object object;
                    if (!bl2 && !this.mark.at(i)) continue;
                    n = n3;
                    if (nArray == null || nArray.length < 1) {
                        for (n = 0; n < this.count(); ++n) {
                            object = this.at(n).at(i);
                            printStream.print((n == 0 ? "" : "\t") + (object == null ? "NA" : object.toString()));
                        }
                    } else {
                        while (n < nArray.length) {
                            object = this.at(nArray[n]).at(i);
                            printStream.print((n == 0 ? "" : "\t") + (object == null ? "NA" : object.toString()));
                            ++n;
                        }
                    }
                    printStream.println("");
                }
            }
            return true;
        }
        catch (Exception exception) {
            if (Global.DEBUG > 0) {
                System.out.println("* SVarSet.Export...: something went wrong during the export: " + exception.getMessage());
                exception.printStackTrace();
            }
            return false;
        }
    }

    public void printSummary() {
        System.out.println("DEBUG for SVarSet [" + this.toString() + "]");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            SVar sVar = (SVar)enumeration.nextElement();
            if (sVar == null) {
                System.out.println("Variable: null!");
                continue;
            }
            System.out.println("Variable: " + sVar.getName() + " (" + (sVar.isNum() ? "numeric" : "string") + "," + (sVar.isCat() ? "categorized" : "free") + ") with " + sVar.size() + " cases");
            if (!sVar.isCat()) continue;
            Object[] objectArray = sVar.getCategories();
            System.out.print("  Categories: ");
            for (int i = 0; i < objectArray.length; ++i) {
                System.out.print("{" + objectArray[i].toString() + "} ");
            }
            System.out.println();
        }
    }
}

