/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.rosuda.JGR.toolkit.ExtensionFileFilter;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.deducer.Deducer;

public class SaveData {
    private static final long serialVersionUID = -5513844930423188258L;
    private static String[][] extensions = new String[][]{{"rda", "rdata"}, {"robj"}, {"csv"}, {"txt"}, {"dbf"}, {"dta"}, {"arff"}};
    private static String[] extensionDescription = new String[]{"R (*.rda *.rdata)", "R dput() (*.robj)", "Comma seperated (*.csv)", "Tab (*.txt)", "DBF (*.dbf)", "Stata (*.dta)", "ARFF (*.arff)"};

    public SaveData(String string) {
        JFileChooser jFileChooser = null;
        ExtensionFileFilter extensionFileFilter = null;
        FileSelector fileSelector = new FileSelector(null, "Save Data", 1, null, true);
        if (fileSelector.isSwing()) {
            jFileChooser = fileSelector.getJFileChooser();
            for (int i = 0; i < extensionDescription.length; ++i) {
                extensionFileFilter = new ExtensionFileFilter(extensionDescription[i], extensions[i]);
                jFileChooser.addChoosableFileFilter((FileFilter)extensionFileFilter);
            }
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        fileSelector.setVisible(true);
        if (fileSelector.getFile() == null) {
            return;
        }
        String string2 = fileSelector.getDirectory() + fileSelector.getFile();
        string2 = string2.replace('\\', '/');
        if (fileSelector.getFile() == null) {
            return;
        }
        if (!fileSelector.isSwing()) {
            if (!string2.toLowerCase().endsWith(".robj")) {
                string2 = string2.concat(".robj");
            }
            Deducer.execute("dput(" + string + ",'" + string2 + "')", true);
        } else if (string2.toLowerCase().endsWith(".rda") || string2.toLowerCase().endsWith(".rdata") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[0])) {
            if (!string2.toLowerCase().endsWith(".rda") && !string2.toLowerCase().endsWith(".rdata")) {
                string2 = string2.concat(".rda");
            }
            Deducer.execute("save(" + string + ",file='" + string2 + "')", true);
        } else if (string2.toLowerCase().endsWith(".robj") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[1])) {
            if (!string2.toLowerCase().endsWith(".robj")) {
                string2 = string2.concat(".robj");
            }
            Deducer.execute("dput(" + string + ",'" + string2 + "')", true);
        } else if (string2.toLowerCase().endsWith(".csv") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[2])) {
            if (!string2.toLowerCase().endsWith(".csv")) {
                string2 = string2.concat(".csv");
            }
            Deducer.execute("write.csv(" + string + ",'" + string2 + "')", true);
        } else if (string2.toLowerCase().endsWith(".txt") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[3])) {
            if (!string2.toLowerCase().endsWith(".txt")) {
                string2 = string2.concat(".txt");
            }
            Deducer.execute("write.table(" + string + ",'" + string2 + "',sep='\\t')", true);
        } else {
            Deducer.requirePackage("foreign");
            if (string2.toLowerCase().endsWith(".dbf") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[4])) {
                if (!string2.toLowerCase().endsWith(".dbf")) {
                    string2 = string2.concat(".dbf");
                }
                Deducer.execute("write.dbf(" + string + ",'" + string2 + "')", true);
            } else if (string2.toLowerCase().endsWith(".dta") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[5])) {
                if (!string2.toLowerCase().endsWith(".dta")) {
                    string2 = string2.concat(".dta");
                }
                Deducer.execute("write.dta(" + string + ",'" + string2 + "')", true);
            } else if (string2.toLowerCase().endsWith(".arff") || jFileChooser.getFileFilter().getDescription().equals(extensionDescription[6])) {
                if (!string2.toLowerCase().endsWith(".arff")) {
                    string2 = string2.concat(".arff");
                }
                Deducer.execute("write.arff(" + string + ",'" + string2 + "')", true);
            } else {
                if (!string2.toLowerCase().endsWith(".robj")) {
                    string2 = string2.concat(".robj");
                }
                Deducer.execute("dput(" + string + ",'" + string2 + "')", true);
            }
        }
    }
}

