/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamVariableWidget;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.w3c.dom.Element;

public class ParamVariable
extends Param {
    protected String data;
    protected String variable;
    protected String defaultData;
    protected String defaultVariable;
    protected String format = FORMAT_VECTOR;
    protected String dataParamName = "data";
    public static String FORMAT_VECTOR = "data$variable";
    public static String FORMAT_DATA = "data[,'variable']";
    public static String FORMAT_VARIABLE = "=variable,data=data";
    public static String FORMAT_VARIABLE_CHARACTER = "='variable',data=data";

    public ParamVariable() {
        this.view = "org.rosuda.deducer.widgets.param.ParamVariableView";
    }

    public ParamVariable(String string) {
        this.name = string;
        this.title = string;
        this.view = "org.rosuda.deducer.widgets.param.ParamVariableView";
    }

    public ParamVariable(String string, String string2, String string3) {
        this(string);
        this.data = string2;
        this.variable = string3;
        this.defaultData = null;
        this.defaultVariable = null;
        this.view = "org.rosuda.deducer.widgets.param.ParamVariableView";
    }

    @Override
    public Object clone() {
        ParamVariable paramVariable = new ParamVariable();
        paramVariable.setName(this.getName());
        paramVariable.setTitle(this.getTitle());
        paramVariable.setViewType(this.getViewType());
        paramVariable.data = this.data;
        paramVariable.variable = this.variable;
        paramVariable.defaultData = this.defaultData;
        paramVariable.defaultVariable = this.defaultVariable;
        paramVariable.view = this.view;
        paramVariable.required = this.required;
        paramVariable.format = this.format;
        return paramVariable;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultVariable;
    }

    @Override
    public String[] getParamCalls() {
        String[] stringArray = new String[]{};
        if (this.getValue() != null && !this.getValue().equals(this.getDefaultValue())) {
            String string = "";
            if (this.getDefaultValue() == null || this.getValue() != null && !this.getDefaultValue().toString().equals(this.getValue().toString())) {
                if (this.getFormat().equals(FORMAT_VECTOR)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + this.data + "$" + this.variable};
                } else if (this.getFormat().equals(FORMAT_DATA)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + this.data + "[,'" + this.variable + "']"};
                } else if (this.getFormat().equals(FORMAT_VARIABLE)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + this.variable, this.dataParamName + " = " + this.data};
                } else if (this.getFormat().equals(FORMAT_VARIABLE_CHARACTER)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + "'" + this.variable + "'", this.dataParamName + " = " + this.data};
                }
            } else {
                string = "";
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public Object getValue() {
        return this.variable;
    }

    @Override
    public ParamWidget getView() {
        return null;
    }

    @Override
    public ParamWidget getView(VariableSelectorWidget variableSelectorWidget) {
        return new ParamVariableWidget(this, variableSelectorWidget);
    }

    @Override
    public boolean requiresVariableSelector() {
        return true;
    }

    @Override
    public void setDefaultValue(Object object) {
        this.defaultVariable = (String)object;
    }

    @Override
    public void setValue(Object object) {
        this.variable = (String)object;
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public void setVariable(String string) {
        this.variable = string;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setDefaultData(String string) {
        this.defaultData = string;
    }

    public String getDefaultData() {
        return this.defaultData;
    }

    public void setDefaultVariable(String string) {
        this.defaultVariable = string;
    }

    public String getDefaultVariable() {
        return this.defaultVariable;
    }

    @Override
    public Element toXML() {
        Element element = super.toXML();
        if (this.variable != null) {
            element.setAttribute("variable", this.variable);
        }
        if (this.defaultVariable != null) {
            element.setAttribute("defaultVariable", this.defaultVariable);
        }
        if (this.data != null) {
            element.setAttribute("data", this.data);
        }
        if (this.defaultData != null) {
            element.setAttribute("defaultData", this.defaultData);
        }
        if (this.getFormat() != null) {
            element.setAttribute("format", this.getFormat());
        }
        if (this.dataParamName != null) {
            element.setAttribute("dataParamName", this.dataParamName);
        }
        element.setAttribute("className", "org.rosuda.deducer.widgets.param.ParamVariable");
        return element;
    }

    @Override
    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.widgets.param.ParamLogical")) {
            System.out.println("Error ParamLogical: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        super.setFromXML(element);
        this.variable = element.hasAttribute("variable") ? element.getAttribute("variable") : null;
        this.defaultVariable = element.hasAttribute("defaultVariable") ? element.getAttribute("defaultVariable") : null;
        this.data = element.hasAttribute("data") ? element.getAttribute("data") : null;
        this.defaultData = element.hasAttribute("defaultData") ? element.getAttribute("defaultData") : null;
        if (element.hasAttribute("format")) {
            this.setFormat(element.getAttribute("format"));
        } else {
            this.setFormat(null);
        }
        this.dataParamName = element.hasAttribute("dataParamName") ? element.getAttribute("dataParamName") : null;
    }

    protected void setDataParamName(String string) {
        this.dataParamName = string;
    }

    protected String getDataParamName() {
        return this.dataParamName;
    }

    @Override
    public boolean hasValidEntry() {
        return this.variable != null && this.variable.length() > 0 || this.defaultVariable != null;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }
}

