/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.ParamFacet;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.widgets.VariableListWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamFacetWidget
extends ParamWidget
implements ActionListener {
    private JTabbedPane tabs;
    private VariableListWidget lhsVariables;
    private VariableListWidget wrapVars;
    private JButton wrapOptions;
    private JButton gridOptions;
    private VariableListWidget rhsVariables;
    private JPanel wrapPanel;
    private JPanel gridPanel;
    private JCheckBox xFreeGrid;
    private JCheckBox yFreeGrid;
    private JCheckBox margins;
    private JCheckBox spaceFixed;
    private JCheckBox asTableGrid;
    private JCheckBox dropGrid;
    private JTextField nrow;
    private JTextField ncol;
    private JCheckBox xFreeWrap;
    private JCheckBox yFreeWrap;
    private JCheckBox asTableWrap;
    private JCheckBox drop;
    private ParamFacet model;

    public ParamFacetWidget(VariableSelectorWidget variableSelectorWidget, Param param) {
        this.initGUI(variableSelectorWidget);
        this.setModel(param);
    }

    private void initGUI(VariableSelectorWidget variableSelectorWidget) {
        try {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayout(borderLayout);
            this.setPreferredSize(new Dimension(241, 350));
            this.setMinimumSize(new Dimension(100, 350));
            this.setMaximumSize(new Dimension(241, 350));
            this.tabs = new JTabbedPane();
            this.add((Component)this.tabs, "Center");
            this.tabs.setPreferredSize(new Dimension(264, 420));
            this.gridPanel = new JPanel();
            AnchorLayout anchorLayout = new AnchorLayout();
            this.gridPanel.setLayout((LayoutManager)anchorLayout);
            this.tabs.addTab("grid", null, this.gridPanel, null);
            this.gridOptions = new IconButton("/icons/advanced_32.png", "Grid options", this, "gridOptions");
            this.gridPanel.add((Component)this.gridOptions, new AnchorConstraint(887, 955, 979, 673, 0, 1, 1, 0));
            this.gridOptions.setPreferredSize(new Dimension(32, 32));
            this.rhsVariables = new VariableListWidget("columns", variableSelectorWidget);
            this.gridPanel.add((Component)this.rhsVariables, new AnchorConstraint(428, 955, 805, 48, 1, 1, 1, 1));
            this.rhsVariables.setPreferredSize(new Dimension(235, 82));
            this.lhsVariables = new VariableListWidget("rows", variableSelectorWidget);
            this.gridPanel.add((Component)this.lhsVariables, new AnchorConstraint(57, 955, 428, 48, 1, 1, 1, 1));
            this.lhsVariables.setPreferredSize(new Dimension(235, 81));
            this.wrapPanel = new JPanel();
            anchorLayout = new AnchorLayout();
            this.wrapPanel.setLayout((LayoutManager)anchorLayout);
            this.tabs.addTab("wrap", null, this.wrapPanel, null);
            this.wrapOptions = new IconButton("/icons/advanced_32.png", "Wrap options", this, "wrapOptions");
            this.wrapPanel.add((Component)this.wrapOptions, new AnchorConstraint(887, 955, 979, 673, 0, 1, 1, 0));
            this.wrapOptions.setPreferredSize(new Dimension(32, 32));
            this.wrapVars = new VariableListWidget("facet by", variableSelectorWidget);
            this.wrapPanel.add((Component)this.wrapVars, new AnchorConstraint(57, 955, 745, 48, 1, 1, 1, 1));
            this.wrapVars.setPreferredSize(new Dimension(235, 150));
            this.xFreeGrid = new JCheckBox("x-axis free");
            this.yFreeGrid = new JCheckBox("y-axis free");
            this.margins = new JCheckBox("show margins");
            this.spaceFixed = new JCheckBox("fix facet size");
            this.asTableGrid = new JCheckBox("as table");
            this.dropGrid = new JCheckBox("drop");
            this.nrow = new JTextField();
            this.ncol = new JTextField();
            this.xFreeWrap = new JCheckBox("x-axis free");
            this.yFreeWrap = new JCheckBox("y-axis free");
            this.asTableWrap = new JCheckBox("as table");
            this.drop = new JCheckBox("drop");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showGridOptions() {
        final JDialog jDialog = new JDialog((Frame)new JFrame(), "Grid Options");
        jDialog.getContentPane().setLayout(null);
        JButton jButton = new JButton();
        jDialog.getContentPane().add(jButton);
        jButton.setText("Okay");
        jButton.setBounds(146, 150, 69, 22);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add(this.xFreeGrid);
        this.xFreeGrid.setBounds(12, 12, 156, 17);
        jDialog.getContentPane().add(this.yFreeGrid);
        this.yFreeGrid.setBounds(12, 35, 156, 17);
        jDialog.getContentPane().add(this.margins);
        this.margins.setBounds(12, 58, 156, 17);
        jDialog.getContentPane().add(this.spaceFixed);
        this.spaceFixed.setBounds(12, 81, 156, 17);
        jDialog.getContentPane().add(this.asTableGrid);
        this.asTableGrid.setBounds(12, 104, 156, 17);
        jDialog.getContentPane().add(this.dropGrid);
        this.dropGrid.setBounds(12, 127, 156, 17);
        jDialog.setModal(true);
        jDialog.setSize(227, 210);
        jDialog.setLocationRelativeTo(this.gridOptions);
        jDialog.setVisible(true);
    }

    public void showWrapOptions() {
        final JDialog jDialog = new JDialog((Frame)new JFrame(), "Wrap options");
        jDialog.getContentPane().setLayout(null);
        JComponent jComponent = new JButton();
        jDialog.getContentPane().add(jComponent);
        ((AbstractButton)jComponent).setText("Okay");
        jComponent.setBounds(146, 133, 69, 22);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                try {
                    n = Integer.parseInt(ParamFacetWidget.this.nrow.getText());
                    if (n < 1) {
                        ParamFacetWidget.this.nrow.setText("");
                    }
                }
                catch (Exception exception) {
                    ParamFacetWidget.this.nrow.setText("");
                }
                try {
                    n = Integer.parseInt(ParamFacetWidget.this.ncol.getText());
                    if (n < 1) {
                        ParamFacetWidget.this.ncol.setText("");
                    }
                }
                catch (Exception exception) {
                    ParamFacetWidget.this.ncol.setText("");
                }
                jDialog.dispose();
            }
        });
        jComponent = new JLabel();
        jDialog.getContentPane().add(jComponent);
        ((JLabel)jComponent).setText("# of rows");
        jComponent.setBounds(12, 12, 80, 15);
        ((JLabel)jComponent).setHorizontalAlignment(11);
        jDialog.getContentPane().add(this.nrow);
        this.nrow.setBounds(104, 8, 42, 22);
        this.nrow.setHorizontalAlignment(0);
        jComponent = new JLabel();
        jDialog.getContentPane().add(jComponent);
        ((JLabel)jComponent).setText("# of Columns");
        jComponent.setBounds(0, 39, 92, 15);
        ((JLabel)jComponent).setHorizontalAlignment(11);
        jDialog.getContentPane().add(this.ncol);
        this.ncol.setBounds(104, 35, 42, 22);
        this.ncol.setHorizontalAlignment(0);
        jDialog.getContentPane().add(this.xFreeWrap);
        this.xFreeWrap.setBounds(12, 66, 104, 19);
        jDialog.getContentPane().add(this.yFreeWrap);
        this.yFreeWrap.setBounds(12, 91, 104, 19);
        jDialog.getContentPane().add(this.asTableWrap);
        this.asTableWrap.setBounds(122, 66, 92, 19);
        jDialog.getContentPane().add(this.drop);
        this.drop.setBounds(122, 91, 100, 19);
        jDialog.setModal(true);
        jDialog.setSize(227, 188);
        jDialog.setLocationRelativeTo(this.wrapOptions);
        jDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.gridOptions) {
            this.showGridOptions();
        } else {
            this.showWrapOptions();
        }
    }

    @Override
    public void setModel(Param param) {
        this.model = (ParamFacet)param;
        this.lhsVariables.setModel(this.model.yVarsGrid, false);
        this.rhsVariables.setModel(this.model.xVarsGrid, false);
        this.wrapVars.setModel(this.model.varsWrap, false);
        this.xFreeGrid.setSelected(this.model.scaleGrid.equals("free") || this.model.scaleGrid.equals("free_x"));
        this.yFreeGrid.setSelected(this.model.scaleGrid.equals("free") || this.model.scaleGrid.equals("free_y"));
        this.xFreeWrap.setSelected(this.model.scaleWrap.equals("free") || this.model.scaleWrap.equals("free_x"));
        this.yFreeWrap.setSelected(this.model.scaleWrap.equals("free") || this.model.scaleWrap.equals("free_y"));
        this.margins.setSelected(this.model.margins);
        this.spaceFixed.setSelected(this.model.spaceFixed);
        this.asTableGrid.setSelected(this.model.asTableGrid);
        if (this.model.nrow != null) {
            this.nrow.setText(this.model.nrow.toString());
        } else {
            this.nrow.setText("");
        }
        if (this.model.ncol != null) {
            this.ncol.setText(this.model.ncol.toString());
        } else {
            this.ncol.setText("");
        }
        this.asTableWrap.setSelected(this.model.asTableWrap);
        this.drop.setSelected(this.model.drop);
        this.dropGrid.setSelected(this.model.dropGrid);
        this.setType(this.model.facetType);
    }

    @Override
    public void updateModel() {
        this.model.yVarsGrid = this.lhsVariables.getVariables();
        this.model.xVarsGrid = this.rhsVariables.getVariables();
        this.model.varsWrap = this.wrapVars.getVariables();
        if (this.xFreeGrid.isSelected() && this.yFreeGrid.isSelected()) {
            this.model.scaleGrid = "free";
        } else if (this.xFreeGrid.isSelected() && !this.yFreeGrid.isSelected()) {
            this.model.scaleGrid = "free_x";
        } else if (!this.xFreeGrid.isSelected() && this.yFreeGrid.isSelected()) {
            this.model.scaleGrid = "free_y";
        } else if (!this.xFreeGrid.isSelected() && !this.yFreeGrid.isSelected()) {
            this.model.scaleGrid = "fixed";
        }
        if (this.xFreeWrap.isSelected() && this.yFreeWrap.isSelected()) {
            this.model.scaleWrap = "free";
        } else if (this.xFreeWrap.isSelected() && !this.yFreeWrap.isSelected()) {
            this.model.scaleWrap = "free_x";
        } else if (!this.xFreeWrap.isSelected() && this.yFreeWrap.isSelected()) {
            this.model.scaleWrap = "free_y";
        } else if (!this.xFreeWrap.isSelected() && !this.yFreeWrap.isSelected()) {
            this.model.scaleWrap = "fixed";
        }
        this.model.margins = new Boolean(this.margins.isSelected());
        this.model.spaceFixed = new Boolean(this.spaceFixed.isSelected());
        this.model.asTableGrid = new Boolean(this.asTableGrid.isSelected());
        this.model.asTableWrap = new Boolean(this.asTableWrap.isSelected());
        this.model.drop = new Boolean(this.drop.isSelected());
        this.model.dropGrid = new Boolean(this.dropGrid.isSelected());
        try {
            this.model.nrow = new Integer(Integer.parseInt(this.nrow.getText()));
        }
        catch (Exception exception) {
            this.model.nrow = null;
        }
        try {
            this.model.ncol = new Integer(Integer.parseInt(this.ncol.getText()));
        }
        catch (Exception exception) {
            this.model.nrow = null;
        }
        this.model.facetType = this.getType();
    }

    public String getType() {
        int n = this.tabs.getSelectedIndex();
        if (n == 0) {
            return "grid";
        }
        return "wrap";
    }

    public void setType(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("grid")) {
            this.tabs.setSelectedIndex(0);
        } else {
            this.tabs.setSelectedIndex(1);
        }
    }
}

