/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.ExScrollableTable;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.widgets.param.RFunctionListChooserWidget;

public class LegendPanel
extends JPanel
implements ActionListener {
    private JLabel nameLabel;
    private ExScrollableTable tableScroller;
    private JPanel tablePanel;
    private JTextField nameField;
    private ExTable table;
    private ExDefaultTableModel tableModel;
    private JButton addButton;
    private RFunctionListChooserWidget breaksWidget;
    private RFunctionListChooserWidget labelsWidget;
    private RFunctionListChooserWidget guideWidget;
    private boolean numeric = true;

    public LegendPanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(255, 250));
            int n = 110;
            this.tablePanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.tablePanel.setLayout(borderLayout);
            this.add((Component)this.tablePanel, new AnchorConstraint(65, 10, 220, 10, 2, 2, 0, 2));
            this.tablePanel.setPreferredSize(new Dimension(125, 109));
            this.tableModel = new LegendTableModel();
            this.tableModel.addColumn("Value");
            this.tableModel.addColumn("Label");
            this.tableModel.addRow(new String[]{"", ""});
            this.table = new ExTable(this.tableModel);
            this.table.getTableHeader().removeMouseListener(this.table.getColumnListener());
            this.tableScroller = new ExScrollableTable(this.table);
            this.tablePanel.add((Component)this.tableScroller, "Center");
            this.nameField = new JTextField("");
            this.add((Component)this.nameField, new AnchorConstraint(40, 10, 200, 10, 2, 2, 0, 2));
            this.nameField.setPreferredSize(new Dimension(125, 22));
            this.nameLabel = new JLabel();
            this.add((Component)this.nameLabel, new AnchorConstraint(25, 922, 90, 10, 2, 1, 0, 2));
            this.nameLabel.setText("Title");
            this.nameLabel.setPreferredSize(new Dimension(125, 15));
            this.addButton = new JButton("+");
            this.add((Component)this.addButton, new AnchorConstraint(175, 10, 9, 10, 2, 2, 0, 2));
            this.addButton.setPreferredSize(new Dimension(40, 22));
            this.addButton.addActionListener(this);
            if (this.numeric) {
                this.breaksWidget = new RFunctionListChooserWidget();
                this.add((Component)this.breaksWidget, new AnchorConstraint(210, 10, 9, 10, 2, 2, 0, 2));
                this.labelsWidget = new RFunctionListChooserWidget();
                this.add((Component)this.labelsWidget, new AnchorConstraint(240, 10, 9, 10, 2, 2, 0, 2));
            }
            this.guideWidget = new RFunctionListChooserWidget();
            this.add((Component)this.guideWidget, new AnchorConstraint(270, 10, 9, 10, 2, 2, 0, 2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean bl) {
        if (bl && !this.numeric) {
            this.add((Component)this.breaksWidget, new AnchorConstraint(210, 10, 9, 10, 2, 2, 0, 2));
            this.add((Component)this.labelsWidget, new AnchorConstraint(240, 10, 9, 10, 2, 2, 0, 2));
            this.repaint();
        }
        if (!bl && this.numeric) {
            this.remove(this.breaksWidget);
            this.remove(this.labelsWidget);
            this.repaint();
        }
        this.numeric = bl;
    }

    public void showGuide(boolean bl) {
        this.guideWidget.setVisible(bl);
    }

    @Override
    public String getName() {
        if (this.nameField == null) {
            return "";
        }
        return this.nameField.getText();
    }

    @Override
    public void setName(String string) {
        this.nameField.setText(string);
    }

    public RFunctionListChooserWidget getBreaksWidget() {
        return this.breaksWidget;
    }

    public RFunctionListChooserWidget getLabelsWidget() {
        return this.labelsWidget;
    }

    public RFunctionListChooserWidget getGuideWidget() {
        return this.guideWidget;
    }

    public ExDefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ExDefaultTableModel exDefaultTableModel) {
        this.tableModel = exDefaultTableModel;
        this.table.setModel(exDefaultTableModel);
        this.tableScroller.getRowNamesModel().initHeaders(this.tableModel.getRowCount());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "+") {
            this.tableModel.addRow(new String[]{"", ""});
            this.tableScroller.getRowNamesModel().initHeaders(this.tableModel.getRowCount());
        }
    }

    class LegendTableModel
    extends ExDefaultTableModel {
        LegendTableModel() {
        }

        @Override
        public void removeRow(int n) {
            super.removeRow(n);
            LegendPanel.this.tableScroller.getRowNamesModel().initHeaders(LegendPanel.this.tableModel.getRowCount());
        }

        @Override
        public void insertNewRow(int n) {
            this.insertRow(n, new String[]{"", ""});
            LegendPanel.this.tableScroller.getRowNamesModel().initHeaders(LegendPanel.this.tableModel.getRowCount());
        }

        @Override
        public void removeColumn(int n) {
        }

        @Override
        public void insertNewColumn(int n) {
        }
    }
}

