/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.models.LinearModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class LinearExplorerOptions
extends JDialog
implements ActionListener {
    private JPanel modelInfPanel;
    private JCheckBox anova;
    private JLabel type;
    private JCheckBox summary;
    private JCheckBox hccm;
    private JPanel robustPanel;
    private JPanel okayCancel;
    private JCheckBox influence;
    private JCheckBox vif;
    private JSeparator sep;
    private JPanel diagPanel;
    private JCheckBox cor;
    private JRadioButton typeIII;
    private JRadioButton typeII;
    private LinearModel model;

    public LinearExplorerOptions(JFrame jFrame, LinearModel linearModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(linearModel);
        this.setModal(true);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.modelInfPanel = new JPanel();
            this.getContentPane().add(this.modelInfPanel);
            this.modelInfPanel.setBounds(17, 12, 260, 129);
            this.modelInfPanel.setBorder(BorderFactory.createTitledBorder("Tables"));
            this.modelInfPanel.setLayout(null);
            this.anova = new JCheckBox();
            this.modelInfPanel.add(this.anova);
            this.anova.setText("Anova Table");
            this.anova.setBounds(17, 20, 227, 19);
            this.type = new JLabel();
            this.modelInfPanel.add(this.type);
            this.type.setText("Type:");
            this.type.setBounds(17, 45, 53, 15);
            this.type.setHorizontalAlignment(4);
            this.typeII = new JRadioButton();
            this.modelInfPanel.add(this.typeII);
            this.typeII.setText("II");
            this.typeII.setBounds(76, 43, 51, 19);
            this.typeIII = new JRadioButton();
            this.modelInfPanel.add(this.typeIII);
            this.typeIII.setText("III");
            this.typeIII.setBounds(125, 43, 51, 19);
            this.summary = new JCheckBox();
            this.modelInfPanel.add(this.summary);
            this.summary.setText("Summary Table");
            this.summary.setBounds(17, 78, 204, 19);
            this.cor = new JCheckBox();
            this.modelInfPanel.add(this.cor);
            this.cor.setText("Parameter Correlations");
            this.cor.setBounds(37, 103, 189, 19);
            this.sep = new JSeparator();
            this.modelInfPanel.add(this.sep);
            this.sep.setBounds(61, 68, 113, 10);
            this.diagPanel = new JPanel();
            this.getContentPane().add(this.diagPanel);
            this.diagPanel.setBounds(17, 222, 260, 70);
            this.diagPanel.setBorder(BorderFactory.createTitledBorder("Model Diagnostics"));
            this.diagPanel.setLayout(null);
            this.vif = new JCheckBox();
            this.diagPanel.add(this.vif);
            this.vif.setText("Variance Inflation Factors");
            this.vif.setBounds(17, 20, 226, 19);
            this.influence = new JCheckBox();
            this.diagPanel.add(this.influence);
            this.influence.setText("Influence Summary");
            this.influence.setBounds(17, 45, 226, 19);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(88, 298, 189, 31);
            this.robustPanel = new JPanel();
            this.getContentPane().add(this.robustPanel);
            this.robustPanel.setBounds(17, 141, 260, 75);
            this.robustPanel.setBorder(BorderFactory.createTitledBorder("Robust to:"));
            this.robustPanel.setLayout(null);
            this.hccm = new JCheckBox();
            this.robustPanel.add(this.hccm);
            this.hccm.setText("Unequal Variance (HCCM)");
            this.hccm.setBounds(17, 32, 238, 19);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.typeII);
            buttonGroup.add(this.typeIII);
            this.setTitle("Options");
            this.setSize(289, 363);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(LinearModel linearModel) {
        this.model = linearModel;
        this.anova.setSelected(linearModel.options.anova);
        this.typeII.setSelected(true);
        this.typeIII.setSelected(linearModel.options.type == "III");
        this.hccm.setSelected(this.model.hccm);
        this.summary.setSelected(linearModel.options.summary);
        this.cor.setSelected(linearModel.options.paramCor);
        this.vif.setSelected(linearModel.options.vif);
        this.influence.setSelected(linearModel.options.influence);
    }

    public void updateModel() {
        this.model.hccm = this.hccm.isSelected();
        this.model.options.anova = this.anova.isSelected();
        this.model.options.type = this.typeII.isSelected() ? "II" : "III";
        this.model.options.test = "F";
        this.model.options.summary = this.summary.isSelected();
        this.model.options.paramCor = this.cor.isSelected();
        this.model.options.vif = this.vif.isSelected();
        this.model.options.influence = this.influence.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            this.updateModel();
            this.dispose();
        } else if (string == "Cancel") {
            this.dispose();
        }
    }
}

