/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.util.Vector;
import org.rosuda.deducer.plots.ParamFacetWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ParamFacet
extends Param {
    public static String VIEW_FACET = "facet";
    public String[] yVarsGrid = new String[0];
    public String[] xVarsGrid = new String[0];
    public String[] varsWrap = new String[0];
    public String facetType;
    public String scaleGrid;
    public Boolean margins;
    public Boolean spaceFixed;
    public Boolean asTableGrid = new Boolean(true);
    public Integer nrow;
    public Integer ncol;
    public String scaleWrap;
    public Boolean asTableWrap = new Boolean(true);
    public Boolean drop = new Boolean(true);

    public ParamFacet() {
        this.margins = new Boolean(false);
        this.setName("facet");
        this.setTitle("facet");
        this.ncol = null;
        this.nrow = null;
        this.scaleGrid = "fixed";
        this.scaleWrap = "fixed";
        this.spaceFixed = new Boolean(true);
        this.facetType = "wrap";
        this.view = VIEW_FACET;
    }

    public ParamWidget getView() {
        return new ParamFacetWidget(new VariableSelectorWidget(), this);
    }

    public ParamWidget getView(VariableSelectorWidget variableSelectorWidget) {
        return new ParamFacetWidget(variableSelectorWidget, this);
    }

    public Object clone() {
        int n;
        ParamFacet paramFacet = new ParamFacet();
        String[] stringArray = new String[this.yVarsGrid.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.yVarsGrid[n];
        }
        paramFacet.yVarsGrid = stringArray;
        stringArray = new String[this.xVarsGrid.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.xVarsGrid[n];
        }
        paramFacet.xVarsGrid = stringArray;
        stringArray = new String[this.varsWrap.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.varsWrap[n];
        }
        paramFacet.varsWrap = stringArray;
        paramFacet.scaleGrid = this.scaleGrid;
        paramFacet.scaleWrap = this.scaleWrap;
        paramFacet.margins = new Boolean(this.margins);
        paramFacet.spaceFixed = new Boolean(this.spaceFixed);
        paramFacet.asTableGrid = new Boolean(this.asTableGrid);
        paramFacet.asTableWrap = new Boolean(this.asTableWrap);
        paramFacet.drop = new Boolean(this.drop);
        if (this.nrow != null) {
            paramFacet.nrow = new Integer(this.nrow);
        }
        if (this.ncol != null) {
            paramFacet.ncol = new Integer(this.ncol);
        }
        paramFacet.facetType = this.facetType;
        return paramFacet;
    }

    public String[] getParamCalls() {
        String string;
        String[] stringArray = new String[]{};
        Vector<String> vector = new Vector<String>();
        if (this.facetType.equals("grid")) {
            if (this.yVarsGrid.length == 0 && this.xVarsGrid.length == 0) {
                return new String[0];
            }
            string = "";
            if (this.yVarsGrid.length == 0) {
                string = ".";
            }
            for (int i = 0; i < this.yVarsGrid.length; ++i) {
                if (i != 0) {
                    string = string + " + ";
                }
                string = string + this.yVarsGrid[i];
            }
            String string2 = "";
            if (this.xVarsGrid.length == 0) {
                string2 = ".";
            }
            for (int i = 0; i < this.xVarsGrid.length; ++i) {
                if (i != 0) {
                    string2 = string2 + " + ";
                }
                string2 = string2 + this.xVarsGrid[i];
            }
            vector.add("facets = " + string + " ~ " + string2);
            if (this.margins.booleanValue()) {
                vector.add(", margins = TRUE");
            }
            if (!this.scaleGrid.equals("fixed")) {
                vector.add(", scales = '" + this.scaleGrid + "'");
            }
            if (!this.spaceFixed.booleanValue()) {
                vector.add(", space = 'free'");
            }
            if (!this.asTableGrid.booleanValue()) {
                vector.add(", as.table = FALSE");
            }
        } else {
            if (this.varsWrap.length == 0) {
                return new String[0];
            }
            string = "";
            for (int i = 0; i < this.varsWrap.length; ++i) {
                if (i != 0) {
                    string = string + " + ";
                }
                string = string + this.varsWrap[i];
            }
            vector.add("facets = ~" + string);
            if (this.nrow != null) {
                vector.add(", nrow = " + this.nrow.toString());
            }
            if (this.ncol != null) {
                vector.add(", ncol = " + this.ncol.toString());
            }
            if (!this.scaleWrap.equals("fixed")) {
                vector.add(", scales = '" + this.scaleWrap + "'");
            }
            if (!this.asTableWrap.booleanValue()) {
                vector.add(", as.table = FALSE");
            }
            if (!this.drop.booleanValue()) {
                vector.add(", as.table = FALSE");
            }
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.get(i).toString();
        }
        return stringArray;
    }

    public Element toXML() {
        int n;
        Element element = super.toXML();
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("yVarsGrid");
        if (this.yVarsGrid != null) {
            for (n = 0; n < this.yVarsGrid.length; ++n) {
                element2.setAttribute("element_" + n, this.yVarsGrid[n]);
            }
        }
        element.appendChild(element2);
        element2 = document.createElement("xVarsGrid");
        if (this.xVarsGrid != null) {
            for (n = 0; n < this.xVarsGrid.length; ++n) {
                element2.setAttribute("element_" + n, this.xVarsGrid[n]);
            }
        }
        element.appendChild(element2);
        element2 = document.createElement("varsWrap");
        if (this.varsWrap != null) {
            for (n = 0; n < this.varsWrap.length; ++n) {
                element2.setAttribute("element_" + n, this.varsWrap[n]);
            }
        }
        element.appendChild(element2);
        if (this.facetType != null) {
            element.setAttribute("facetType", this.facetType);
        }
        if (this.scaleGrid != null) {
            element.setAttribute("scaleGrid", this.scaleGrid);
        }
        if (this.margins != null) {
            element.setAttribute("margins", this.margins.toString());
        }
        if (this.spaceFixed != null) {
            element.setAttribute("spaceFixed", this.spaceFixed.toString());
        }
        if (this.asTableGrid != null) {
            element.setAttribute("asTableGrid", this.asTableGrid.toString());
        }
        if (this.asTableWrap != null) {
            element.setAttribute("asTableWrap", this.asTableWrap.toString());
        }
        if (this.drop != null) {
            element.setAttribute("drop", this.drop.toString());
        }
        if (this.scaleWrap != null) {
            element.setAttribute("scaleWrap", this.scaleWrap);
        }
        if (this.nrow != null) {
            element.setAttribute("nrow", this.nrow.toString());
        }
        if (this.ncol != null) {
            element.setAttribute("ncol", this.ncol.toString());
        }
        element.setAttribute("className", "org.rosuda.deducer.plots.ParamFacet");
        return element;
    }

    public void setFromXML(Element element) {
        int n;
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.ParamFacet")) {
            System.out.println("Error ParamFacet: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        super.setFromXML(element);
        this.facetType = element.hasAttribute("facetType") ? element.getAttribute("facetType") : null;
        this.scaleGrid = element.hasAttribute("scaleGrid") ? element.getAttribute("scaleGrid") : null;
        this.margins = element.hasAttribute("margins") ? new Boolean(element.getAttribute("margins").equals("true")) : null;
        this.spaceFixed = element.hasAttribute("spaceFixed") ? new Boolean(element.getAttribute("spaceFixed").equals("true")) : null;
        this.asTableGrid = element.hasAttribute("asTableGrid") ? new Boolean(element.getAttribute("asTableGrid").equals("true")) : null;
        this.asTableWrap = element.hasAttribute("asTableWrap") ? new Boolean(element.getAttribute("asTableWrap").equals("true")) : null;
        this.drop = element.hasAttribute("drop") ? new Boolean(element.getAttribute("drop").equals("true")) : null;
        this.scaleWrap = element.hasAttribute("scaleWrap") ? element.getAttribute("scaleWrap") : null;
        this.nrow = element.hasAttribute("nrow") ? new Integer(Integer.parseInt(element.getAttribute("nrow"))) : null;
        this.ncol = element.hasAttribute("ncol") ? new Integer(Integer.parseInt(element.getAttribute("ncol"))) : null;
        Node node = element.getElementsByTagName("yVarsGrid").item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            this.yVarsGrid = new String[namedNodeMap.getLength()];
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                this.yVarsGrid[n] = namedNodeMap.item(n).getNodeValue();
            }
        }
        if ((namedNodeMap = (node = element.getElementsByTagName("xVarsGrid").item(0)).getAttributes()).getLength() > 0) {
            this.xVarsGrid = new String[namedNodeMap.getLength()];
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                this.xVarsGrid[n] = namedNodeMap.item(n).getNodeValue();
            }
        }
        if ((namedNodeMap = (node = element.getElementsByTagName("varsWrap").item(0)).getAttributes()).getLength() > 0) {
            this.varsWrap = new String[namedNodeMap.getLength()];
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                this.varsWrap[n] = namedNodeMap.item(n).getNodeValue();
            }
        }
    }

    public Object getDefaultValue() {
        return null;
    }

    public Object getValue() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.yVarsGrid);
        vector.add(this.xVarsGrid);
        vector.add(this.varsWrap);
        vector.add(this.facetType);
        vector.add(this.scaleGrid);
        vector.add(this.margins);
        vector.add(this.spaceFixed);
        vector.add(this.asTableGrid);
        vector.add(this.nrow);
        vector.add(this.ncol);
        vector.add(this.scaleWrap);
        vector.add(this.asTableWrap);
        vector.add(this.drop);
        return vector;
    }

    public void setDefaultValue(Object object) {
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        Vector vector = (Vector)object;
        this.yVarsGrid = (String[])vector.get(0);
        this.xVarsGrid = (String[])vector.get(1);
        this.varsWrap = (String[])vector.get(2);
        this.facetType = (String)vector.get(3);
        this.scaleGrid = (String)vector.get(4);
        this.margins = (Boolean)vector.get(5);
        this.spaceFixed = (Boolean)vector.get(6);
        this.asTableGrid = (Boolean)vector.get(7);
        this.nrow = (Integer)vector.get(8);
        this.ncol = (Integer)vector.get(9);
        this.scaleWrap = (String)vector.get(10);
        this.asTableWrap = (Boolean)vector.get(11);
        this.drop = (Boolean)vector.get(12);
    }
}

