/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.RModel;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class GLMExplorerPostHoc
extends JDialog
implements ActionListener {
    private JPanel factorPanel;
    private JList factors;
    private JPanel postHocPanel;
    private JPanel okayCancel;
    private JCheckBox confInt;
    private JScrollPane postHocScroller;
    private JComboBox correction;
    private JComboBox type;
    private JLabel correctionLabel;
    private JLabel typeLabel;
    private JButton remove;
    private JButton add;
    private JList postHoc;
    private JScrollPane factorScroller;
    private String[] contrTypes = new String[]{"Tukey", "Dunnett", "Sequen", "AVE", "Changepoint", "Williams", "Marcus", "McDermott", "UmbrellaWilliams", "GrandMean"};
    private String[] corrTypes = new String[]{"No Correction", "single-step", "  ---------  ", "Shaffer", "Westfall", "free", "  ---------  ", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr"};
    RModel rmodel;
    GLMModel model;

    public GLMExplorerPostHoc(JFrame jFrame, GLMModel gLMModel, RModel rModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(gLMModel, rModel);
        this.setModal(true);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.factorPanel = new JPanel();
            Serializable serializable = new BorderLayout();
            this.factorPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.factorPanel);
            this.factorPanel.setBounds(12, 12, 170, 230);
            this.factorPanel.setBorder(BorderFactory.createTitledBorder("Factors"));
            this.factorScroller = new JScrollPane();
            this.factorPanel.add((Component)this.factorScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.factors = new DJList();
            this.factorScroller.setViewportView(this.factors);
            this.factors.setModel(defaultListModel);
            this.postHocPanel = new JPanel();
            serializable = new BorderLayout();
            this.postHocPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.postHocPanel);
            this.postHocPanel.setBounds(250, 12, 170, 230);
            this.postHocPanel.setBorder(BorderFactory.createTitledBorder("Post-Hoc"));
            this.postHocScroller = new JScrollPane();
            this.postHocPanel.add((Component)this.postHocScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.postHoc = new DJList();
            this.postHocScroller.setViewportView(this.postHoc);
            this.postHoc.setModel(defaultListModel);
            this.add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add(this.add);
            this.add.setBounds(197, 86, 38, 38);
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add(this.remove);
            this.remove.setBounds(197, 124, 38, 38);
            this.typeLabel = new JLabel();
            this.getContentPane().add(this.typeLabel);
            this.typeLabel.setText("Type:");
            this.typeLabel.setBounds(113, 254, 47, 15);
            this.typeLabel.setHorizontalAlignment(4);
            this.correctionLabel = new JLabel();
            this.getContentPane().add(this.correctionLabel);
            this.correctionLabel.setText("Correction:");
            this.correctionLabel.setBounds(77, 303, 83, 15);
            this.correctionLabel.setHorizontalAlignment(4);
            serializable = new DefaultComboBoxModel<String>(this.contrTypes);
            this.type = new JComboBox();
            this.getContentPane().add(this.type);
            this.type.setModel(serializable);
            this.type.setBounds(166, 250, 143, 22);
            serializable = new DefaultComboBoxModel<String>(this.corrTypes);
            this.correction = new JComboBox();
            this.getContentPane().add(this.correction);
            this.correction.setModel(serializable);
            this.correction.setBounds(166, 299, 143, 22);
            this.correction.addActionListener(this);
            this.confInt = new JCheckBox();
            this.getContentPane().add(this.confInt);
            this.confInt.setText("Estimate confidence intervals");
            this.confInt.setBounds(166, 274, 247, 19);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(213, 333, 207, 36);
            this.setTitle("Post-Hoc Comparisons");
            this.setSize(432, 403);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void updateModel() {
        this.model.posthoc.posthoc = (DefaultListModel)this.postHoc.getModel();
        this.model.posthoc.confInt = this.confInt.isSelected();
        this.model.posthoc.type = (String)this.type.getSelectedItem();
        this.model.posthoc.correction = (String)this.correction.getSelectedItem();
    }

    public void setModel(GLMModel gLMModel, RModel rModel) {
        this.model = gLMModel;
        this.rmodel = rModel;
        try {
            Object object;
            String[] stringArray = Deducer.timedEval("labels(terms(" + rModel.modelName + "))[!grepl(\":\",labels(terms(" + rModel.modelName + ")))]").asStrings();
            if (stringArray != null && stringArray.length > 0) {
                object = "~" + stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    object = (String)object + "+" + stringArray[i];
                }
                int[] nArray = Deducer.timedEval("as.integer(sapply(model.frame(" + (String)object + ",data=" + rModel.data + ",na.action=na.omit),is.factor))").asIntegers();
                if (nArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (nArray[i] != 1) continue;
                        ((DefaultListModel)this.factors.getModel()).addElement(stringArray[i]);
                    }
                }
            }
            object = (DefaultListModel)this.factors.getModel();
            for (int i = 0; i < this.model.posthoc.posthoc.getSize(); ++i) {
                if (!((DefaultListModel)object).contains(this.model.posthoc.posthoc.elementAt(i))) continue;
                ((DefaultListModel)object).removeElement(this.model.posthoc.posthoc.elementAt(i));
                ((DefaultListModel)this.postHoc.getModel()).addElement(this.model.posthoc.posthoc.elementAt(i));
            }
            this.confInt.setSelected(this.model.posthoc.confInt);
            this.type.setSelectedItem(this.model.posthoc.type);
            this.correction.setSelectedItem(this.model.posthoc.correction);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK") {
            this.updateModel();
            this.dispose();
        } else if (string == "Add") {
            Object[] objectArray = this.factors.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.factors.getModel()).removeElement(objectArray[i]);
                if (objectArray[i] == null) continue;
                ((DefaultListModel)this.postHoc.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.postHoc.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.postHoc.getModel()).removeElement(objectArray[i]);
                if (objectArray[i] == null) continue;
                ((DefaultListModel)this.factors.getModel()).addElement(objectArray[i]);
            }
        } else if (this.correction.getSelectedIndex() == 2 || this.correction.getSelectedIndex() == 6) {
            this.correction.setSelectedIndex(1);
        }
    }
}

