/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.ibase.Common;

public class DeducerPrefs {
    public static boolean SHOWDATA;
    public static boolean SHOWANALYSIS;
    public static boolean USEQUAQUACHOOSER;
    public static boolean VIEWERATSTARTUP;
    private static HashMap map;
    private static boolean started;

    public static void initialize() {
        if (!started) {
            SHOWDATA = true;
            SHOWANALYSIS = true;
            USEQUAQUACHOOSER = Common.isMac();
            VIEWERATSTARTUP = true;
            map = new HashMap();
            DeducerPrefs.readPrefs();
            started = true;
        }
    }

    public static void readPrefs() {
        Preferences preferences;
        BufferedInputStream bufferedInputStream;
        block11: {
            bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(System.getProperty("user.home") + File.separator + ".DeducerPrefs"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                if (bufferedInputStream == null) break block11;
                preferences = Preferences.userNodeForPackage(Deducer.class);
                try {
                    preferences.clear();
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
                preferences = null;
                Preferences.importPreferences(bufferedInputStream);
            }
            catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bufferedInputStream == null) {
            return;
        }
        preferences = Preferences.userNodeForPackage(Deducer.class);
        SHOWDATA = preferences.getBoolean("SHOWDATA", true);
        SHOWANALYSIS = preferences.getBoolean("SHOWANALYSIS", true);
        USEQUAQUACHOOSER = preferences.getBoolean("USEQUAQUACHOOSER", Common.isMac());
        VIEWERATSTARTUP = preferences.getBoolean("VIEWERATSTARTUP", true);
        try {
            String[] stringArray = preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("SHOWDATA") || stringArray[i].equals("SHOWANALYSIS") || stringArray[i].equals("USEQUAQUACHOOSER") || stringArray[i].equals("VIEWERATSTARTUP")) continue;
                map.put(stringArray[i], preferences.get(stringArray[i], ""));
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        USEQUAQUACHOOSER = false;
    }

    public static void writePrefs() {
        Preferences preferences = Preferences.userNodeForPackage(Deducer.class);
        try {
            preferences.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            preferences.put((String)objectArray[i], (String)map.get(objectArray[i]));
        }
        preferences.putBoolean("SHOWDATA", SHOWDATA);
        preferences.putBoolean("SHOWANALYSIS", SHOWANALYSIS);
        preferences.putBoolean("USEQUAQUACHOOSER", USEQUAQUACHOOSER);
        preferences.putBoolean("VIEWERATSTARTUP", VIEWERATSTARTUP);
        try {
            preferences.exportNode(new FileOutputStream(System.getProperty("user.home") + File.separator + ".DeducerPrefs"));
        }
        catch (IOException iOException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static String get(String string) {
        if (string.equals("SHOWDATA")) {
            return SHOWDATA ? "true" : "false";
        }
        if (string.equals("SHOWANALYSIS")) {
            return SHOWANALYSIS ? "true" : "false";
        }
        if (string.equals("USEQUAQUACHOOSER")) {
            return USEQUAQUACHOOSER ? "true" : "false";
        }
        if (string.equals("VIEWERATSTARTUP")) {
            return VIEWERATSTARTUP ? "true" : "false";
        }
        return (String)map.get(string);
    }

    public static void set(String string, String string2) {
        if (string.equals("SHOWDATA")) {
            SHOWDATA = string2.equals("true");
        } else if (string.equals("SHOWANALYSIS")) {
            SHOWANALYSIS = string2.equals("true");
        } else if (string.equals("USEQUAQUACHOOSER")) {
            USEQUAQUACHOOSER = string2.equals("true");
        } else if (string.equals("VIEWERATSTARTUP")) {
            VIEWERATSTARTUP = string2.equals("true");
        } else {
            map.put(string, string2);
        }
    }

    static {
        started = false;
    }
}

