% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple.ssa.R
\name{simple.ssa}
\alias{simple.ssa}
\title{Simple SSA decomposition}
\usage{
simple.ssa(xy, dt, n = 10, remove = "trend", groups = list(), plot = T, ...)
}
\arguments{
\item{xy}{signal to be decomposed}

\item{dt}{depth/time}

\item{n}{maximum amount of components}

\item{remove}{whether to remove a linear trend ("trend", is the default),
a mean value ("mean"), or to decompose as is (any other value)}

\item{groups}{which components to regroup (list of the indices of elementary
components to be regrouped, the entries of the list can be named, see
the reconstruct() function in the Rssa package for more information)}

\item{plot}{whether to show a visualisation of the importance of each
component}

\item{...}{any arguments to by given to the ssa() function (see Rssa package
for more information)}
}
\value{
a list made of $xy (original signal), $dt (depth/time), $m (a matrix
of the decomposition), $repl (the replicate id of each point) and $mode (the
mode id of each point).
}
\description{
Simple wrapper for Singular Spectrum Analysis, using the
functions of the Rssa package (which is not installed by default by the
DecomposeR package, you should install it independently). This function
allows unevenly sampled data.
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + 0.01 * t

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

res <- simple.ssa(xy, dt, groups = list(c(1,2), c= 3:10))

parsimony(res)

integrity(xy, res)

\dontrun{
plot_emd(res, style = 1)}

}
