% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.ratio.R
\name{is.ratio}
\alias{is.ratio}
\title{Check ratio objects}
\usage{
is.ratio(ratio)
}
\arguments{
\item{ratio}{a ratio object to check}
}
\description{
Check ratio objects
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7,
                 repl = 10, comb = 10, factor_noise = 10,
                 speak = TRUE)

ht    <- inst.pulse(dec)
ratio <- inst.ratio(ht, plot = FALSE)

is.ratio(ratio)

}
