% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAVF_calc_rho.R
\name{SAVF_calc_rho}
\alias{SAVF_calc_rho}
\title{Single Attribute Value Function (SAVF) Calculate Rho}
\usage{
SAVF_calc_rho(x_low, x_mid, x_high, increasing = TRUE)
}
\arguments{
\item{x_low}{Lowest value}

\item{x_mid}{Midpoint value}

\item{x_high}{Highest value}

\item{increasing}{TRUE=increasing, FALSE=decreasing, Default: TRUE}
}
\value{
Rho
}
\description{
: Calculates rho for an exponential function.
}
\details{
For Z=((x_mid - x_low) / (x_high - x_low)),
Z can not be in (0.51,0.49)
}
\examples{
SAVF_calc_rho(0, 90, 150, FALSE)

}
