/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.ProjectReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.BQDriver;
import net.starschema.clouddb.jdbc.Logger;

public class BQSupportFuncts {
    static Logger logger = Logger.getLogger(BQSupportFuncts.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String constructUrlFromPropertiesFile(Properties properties, boolean full, String dataset) throws UnsupportedEncodingException {
        String ProjectId = properties.getProperty("projectid");
        logger.debug("projectId is: " + ProjectId);
        String User = properties.getProperty("user");
        String Password = properties.getProperty("password");
        String path = properties.getProperty("path");
        dataset = dataset == null ? properties.getProperty("dataset") : dataset;
        String transformQuery = null;
        transformQuery = properties.getProperty("transformquery");
        String forreturn = "";
        if (properties.getProperty("type").equals("installed")) {
            if (User == null || Password == null || ProjectId == null) return null;
            forreturn = BQDriver.getURLPrefix() + URLEncoder.encode(ProjectId, "UTF-8");
        } else if (properties.getProperty("type").equals("service")) {
            if (User == null || Password == null || ProjectId == null) return null;
            forreturn = BQDriver.getURLPrefix() + URLEncoder.encode(ProjectId, "UTF-8") + (dataset != null && full ? "/" + URLEncoder.encode(dataset, "UTF-8") : "") + "?withServiceAccount=true";
            if (full) {
                forreturn = forreturn + "&user=" + URLEncoder.encode(User, "UTF-8") + "&password=" + URLEncoder.encode(Password, "UTF-8");
                if (path != null) {
                    forreturn = forreturn + "&path=" + URLEncoder.encode(path, "UTF-8");
                }
            }
        } else if (properties.getProperty("type").equals("default-credentials")) {
            if (ProjectId == null) return null;
            forreturn = BQDriver.getURLPrefix() + URLEncoder.encode(ProjectId, "UTF-8") + (dataset != null && full ? "/" + URLEncoder.encode(dataset, "UTF-8") : "");
        }
        if (transformQuery == null || full) return forreturn;
        if (!properties.getProperty("type").equals("service")) return forreturn + "?transformQuery=" + transformQuery;
        return forreturn + "&transformQuery=" + transformQuery;
    }

    public static String constructUrlFromPropertiesFile(Properties properties) throws UnsupportedEncodingException {
        return BQSupportFuncts.constructUrlFromPropertiesFile(properties, false, null);
    }

    public static Properties getUrlQueryComponents(String url, Properties defaults) throws UnsupportedEncodingException {
        String[] querySubComponents;
        String[] splitAtQP = url.split("\\?");
        Properties components = (Properties)defaults.clone();
        if (splitAtQP.length == 1) {
            return components;
        }
        String queryString = splitAtQP[1];
        for (String subComponent : querySubComponents = queryString.split("&")) {
            Matcher m = Pattern.compile("(.*)=(.*)").matcher(subComponent);
            if (!m.find()) continue;
            components.setProperty(m.group(1).toLowerCase(), URLDecoder.decode(m.group(2), "UTF-8"));
        }
        return components;
    }

    public static void displayQueryResults(Bigquery bigquery, String projectId, Job completedJob) throws IOException {
        projectId = projectId.replace("__", ":").replace("_", ".");
        GetQueryResultsResponse queryResult = (GetQueryResultsResponse)bigquery.jobs().getQueryResults(projectId, completedJob.getJobReference().getJobId()).execute();
        List<TableRow> rows = queryResult.getRows();
        System.out.print("\nQuery Results:\n------------\n");
        for (TableRow row : rows) {
            for (TableCell field : row.getF()) {
                System.out.printf("%-20s", field.getV());
            }
            System.out.println();
        }
    }

    private static List<ProjectList.Projects> getCatalogs(String catalogName, BQConnection Connection2) throws IOException {
        logger.debug("Function call getCatalogs catalogName: " + (catalogName != null ? catalogName : "null"));
        List<ProjectList.Projects> projects = ((ProjectList)Connection2.getBigquery().projects().list().execute()).getProjects();
        if (projects != null && projects.size() != 0) {
            for (ProjectList.Projects projects2 : projects) {
                projects2.setId(projects2.getId().replace(".", "_").replace(":", "__"));
                ProjectReference projRef = projects2.getProjectReference();
                projRef.setProjectId(projRef.getProjectId().replace(".", "_").replace(":", "__"));
                projects2.setProjectReference(projRef);
            }
            if (catalogName != null) {
                ArrayList<ProjectList.Projects> ProjectsSearch = new ArrayList<ProjectList.Projects>();
                for (ProjectList.Projects project : projects) {
                    if (!project.getId().contains(catalogName)) continue;
                    ProjectsSearch.add(project);
                }
                if (ProjectsSearch.size() == 0) {
                    return null;
                }
                return ProjectsSearch;
            }
            return projects;
        }
        return null;
    }

    public static String getDatasetIdFromDatasetDotGetId(String getId) {
        return getId.substring(getId.lastIndexOf(":") + 1);
    }

    public static String getDatasetIdFromTableDotGetId(String getId) {
        return getId.substring(getId.lastIndexOf(":") + 1, getId.lastIndexOf("."));
    }

    private static List<DatasetList.Datasets> getDatasets(String datasetname, String projectId, BQConnection connection) throws IOException {
        logger.debug("function call getDatasets, datasetName: " + (datasetname != null ? datasetname : "null") + ", projectId: " + (projectId != null ? projectId : "null"));
        projectId = projectId.replace("__", ":").replace("_", ".");
        List<DatasetList.Datasets> datasetcontainer = ((DatasetList)connection.getBigquery().datasets().list(projectId).execute()).getDatasets();
        if (datasetcontainer != null && datasetcontainer.size() != 0) {
            if (datasetname != null) {
                ArrayList<DatasetList.Datasets> datasetsSearch = new ArrayList<DatasetList.Datasets>();
                for (DatasetList.Datasets in : datasetcontainer) {
                    if (!BQSupportFuncts.matchPattern(BQSupportFuncts.getDatasetIdFromDatasetDotGetId(in.getId()), datasetname)) continue;
                    datasetsSearch.add(in);
                }
                if (datasetsSearch.size() == 0) {
                    return null;
                }
                return datasetsSearch;
            }
            return datasetcontainer;
        }
        return null;
    }

    public static String getProjectIdFromAnyGetId(String getId) {
        int pos = getId.indexOf(":");
        if (getId.indexOf(":", pos + 1) != -1) {
            pos = getId.indexOf(":", pos + 1);
        }
        String ret = getId.substring(0, pos);
        return ret;
    }

    public static GetQueryResultsResponse getQueryResults(Bigquery bigquery, String projectId, Job completedJob) throws IOException {
        GetQueryResultsResponse queryResult = (GetQueryResultsResponse)bigquery.jobs().getQueryResults(projectId, completedJob.getJobReference().getJobId()).execute();
        long totalRows = queryResult.getTotalRows().longValue();
        if (totalRows == 0L) {
            return queryResult;
        }
        while (totalRows > (long)queryResult.getRows().size()) {
            queryResult.getRows().addAll(((GetQueryResultsResponse)bigquery.jobs().getQueryResults(projectId, completedJob.getJobReference().getJobId()).setStartIndex(BigInteger.valueOf(queryResult.getRows().size())).execute()).getRows());
        }
        return queryResult;
    }

    public static GetQueryResultsResponse getQueryResultsDivided(Bigquery bigquery, String projectId, Job completedJob, BigInteger startAtRow, int fetchCount) throws IOException {
        GetQueryResultsResponse queryResult = (GetQueryResultsResponse)bigquery.jobs().getQueryResults(projectId, completedJob.getJobReference().getJobId()).setStartIndex(startAtRow).setMaxResults(Long.valueOf(fetchCount)).execute();
        return queryResult;
    }

    public static Job getQueryJob(Job myjob, Bigquery bigquery, String projectId) throws IOException {
        projectId = projectId.replace("__", ":").replace("_", ".");
        Job pollJob = (Job)bigquery.jobs().get(projectId, myjob.getJobReference().getJobId()).execute();
        logger.info("Job status: " + pollJob.getStatus().getState() + " ; " + pollJob.getJobReference().getJobId() + " ; " + (System.currentTimeMillis() - pollJob.getStatistics().getStartTime()));
        return pollJob;
    }

    public static String getQueryState(Job myjob, Bigquery bigquery, String projectId) throws IOException {
        return BQSupportFuncts.getQueryJob(myjob, bigquery, projectId).getStatus().getState();
    }

    public static JobCancelResponse cancelQuery(Job job, Bigquery bigquery, String projectId) throws IOException {
        return (JobCancelResponse)bigquery.jobs().cancel(projectId, job.getJobReference().getJobId()).execute();
    }

    public static String getTableIdFromTableDotGetId(String getId) {
        return getId.substring(getId.lastIndexOf(".") + 1);
    }

    public static List<TableList.Tables> getTables(String tableNamePattern, String projectId, String datasetId, BQConnection connection) throws IOException {
        logger.debug("Function call getTables : tableNamePattern: " + (tableNamePattern != null ? tableNamePattern : "null") + ", projectId: " + (projectId != null ? projectId : "null") + ", datasetID:" + (datasetId != null ? datasetId : "null") + "connection");
        projectId = projectId.replace("__", ":").replace("_", ".");
        Bigquery.Tables.List listCall = connection.getBigquery().tables().list(projectId, datasetId).setMaxResults(10000000L);
        List<TableList.Tables> tables = ((TableList)listCall.execute()).getTables();
        if (tables != null && tables.size() != 0) {
            if (tableNamePattern != null) {
                ArrayList<TableList.Tables> tablesSearch = new ArrayList<TableList.Tables>();
                for (TableList.Tables in : tables) {
                    if (!BQSupportFuncts.matchPattern(BQSupportFuncts.getTableIdFromTableDotGetId(in.getId()), tableNamePattern)) continue;
                    tablesSearch.add(in);
                }
                if (tablesSearch.size() == 0) {
                    logger.debug("returning null");
                    return null;
                }
                return tablesSearch;
            }
            return tables;
        }
        logger.debug("returning null");
        return null;
    }

    public static List<Table> getTables(BQConnection connection, String catalog, String schema, String tablename) throws IOException {
        ArrayList<Table> RET = new ArrayList<Table>();
        logger.debug("Function call getTables : catalog: " + (catalog != null ? catalog : "null") + ", schema: " + (schema != null ? schema : "null") + ", tablename:" + (tablename != null ? tablename : "null") + "connection");
        List<ProjectList.Projects> Projects2 = BQSupportFuncts.getCatalogs(catalog, connection);
        if (Projects2 != null && Projects2.size() != 0) {
            for (ProjectList.Projects proj : Projects2) {
                List<DatasetList.Datasets> datasetlist = null;
                datasetlist = BQSupportFuncts.getDatasets(schema, proj.getId(), connection);
                if (datasetlist == null || datasetlist.size() == 0) continue;
                for (DatasetList.Datasets dataset : datasetlist) {
                    List<TableList.Tables> tables = null;
                    tables = BQSupportFuncts.getTables(tablename, proj.getId(), BQSupportFuncts.getDatasetIdFromDatasetDotGetId(dataset.getId()), connection);
                    if (tables == null || tables.size() == 0) continue;
                    for (TableList.Tables table : tables) {
                        String datasetString = BQSupportFuncts.getDatasetIdFromDatasetDotGetId(dataset.getId());
                        String tableString = BQSupportFuncts.getTableIdFromTableDotGetId(table.getId());
                        logger.debug("Calling connection.getBigquery().tables() dataset is: " + datasetString + ", table is: " + tableString + ", project is: " + proj.getId().replace("__", ":").replace("_", "."));
                        Table tbl = (Table)connection.getBigquery().tables().get(proj.getId().replace("__", ":").replace("_", "."), datasetString, tableString).execute();
                        if (tbl == null) continue;
                        RET.add(tbl);
                    }
                }
            }
            if (RET.size() == 0) {
                return null;
            }
            return RET;
        }
        return null;
    }

    public static boolean matchPattern(String input, String pattern) {
        if (pattern == null) {
            return true;
        }
        boolean regexexpression = false;
        String regexexpressionstring = null;
        if (pattern.contains("%")) {
            regexexpression = true;
            if (regexexpressionstring == null) {
                regexexpressionstring = pattern.replace("%", ".*");
            }
        }
        if (pattern.contains("_")) {
            regexexpression = true;
            regexexpressionstring = regexexpressionstring == null ? pattern.replace("_", ".") : regexexpressionstring.replace("_", ".");
        }
        if (regexexpression) {
            return input.matches(regexexpressionstring);
        }
        return input.equals(pattern);
    }

    public static int parseToSqlFieldType(String columntype) {
        if (columntype.equals("FLOAT")) {
            return 6;
        }
        if (columntype.equals("BOOLEAN")) {
            return 16;
        }
        if (columntype.equals("INTEGER")) {
            return 4;
        }
        if (columntype.equals("STRING")) {
            return 12;
        }
        if (columntype.equals("BIGINT")) {
            return -5;
        }
        return 0;
    }

    public static Properties readFromPropFile(String filePath) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(filePath));
        return properties;
    }

    public static Job startQueryWithDestination(Bigquery bigquery, String projectId, String querySql, String dataSet, Boolean useLegacySql, Long maxBillingBytes, String destinationDataSet, String destinationTableId, boolean destinationAppend) throws IOException {
        projectId = projectId.replace("__", ":").replace("_", ".");
        Job job = new Job();
        JobConfiguration config = new JobConfiguration();
        JobConfigurationQuery queryConfig = new JobConfigurationQuery();
        queryConfig.setUseLegacySql(useLegacySql);
        queryConfig.setMaximumBytesBilled(maxBillingBytes);
        queryConfig.setMaximumBillingTier(15);
        if (destinationDataSet != null && destinationTableId != null) {
            TableReference destination_table = new TableReference();
            destination_table.setProjectId(projectId);
            destination_table.setDatasetId(destinationDataSet);
            destination_table.setTableId(destinationTableId);
            queryConfig.setDestinationTable(destination_table);
            if (destinationAppend) {
                queryConfig.setWriteDisposition("WRITE_APPEND");
            } else {
                queryConfig.setWriteDisposition("WRITE_TRUNCATE");
            }
        }
        config.setQuery(queryConfig);
        String jobId = UUID.randomUUID().toString().replace("-", "");
        JobReference jobReference = new JobReference().setProjectId(projectId).setJobId(jobId);
        job.setJobReference(jobReference);
        if (dataSet != null) {
            queryConfig.setDefaultDataset(new DatasetReference().setDatasetId(dataSet).setProjectId(projectId));
        }
        job.setConfiguration(config);
        queryConfig.setQuery(querySql);
        Bigquery.Jobs.Insert insert = bigquery.jobs().insert(querySql, job);
        insert.setProjectId(projectId);
        logger.info("Inserting Query Job [maxbillingtier: 15, maxbillingbytes: " + maxBillingBytes + "] (" + jobId + "): " + querySql.replace("\t", "").replace("\n", " ").replace("\r", ""));
        return (Job)insert.execute();
    }

    public static Job startQuery(Bigquery bigquery, String projectId, String querySql, String dataSet, Boolean useLegacySql, Long maxBillingBytes) throws IOException {
        return BQSupportFuncts.startQueryWithDestination(bigquery, projectId, querySql, dataSet, useLegacySql, maxBillingBytes, null, null, false);
    }
}

