/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.openidconnect;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class IdToken
extends JsonWebSignature {
    public IdToken(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, payload, signatureBytes, signedContentBytes);
    }

    @Override
    public Payload getPayload() {
        return (Payload)super.getPayload();
    }

    public final boolean verifyIssuer(String expectedIssuer) {
        return this.verifyIssuer(Collections.singleton(expectedIssuer));
    }

    public final boolean verifyIssuer(Collection<String> expectedIssuer) {
        return expectedIssuer.contains(this.getPayload().getIssuer());
    }

    public final boolean verifyAudience(Collection<String> trustedClientIds) {
        return trustedClientIds.containsAll(this.getPayload().getAudienceAsList());
    }

    public final boolean verifyTime(long currentTimeMillis, long acceptableTimeSkewSeconds) {
        return this.verifyExpirationTime(currentTimeMillis, acceptableTimeSkewSeconds) && this.verifyIssuedAtTime(currentTimeMillis, acceptableTimeSkewSeconds);
    }

    public final boolean verifyExpirationTime(long currentTimeMillis, long acceptableTimeSkewSeconds) {
        return currentTimeMillis <= (this.getPayload().getExpirationTimeSeconds() + acceptableTimeSkewSeconds) * 1000L;
    }

    public final boolean verifyIssuedAtTime(long currentTimeMillis, long acceptableTimeSkewSeconds) {
        return currentTimeMillis >= (this.getPayload().getIssuedAtTimeSeconds() - acceptableTimeSkewSeconds) * 1000L;
    }

    public static IdToken parse(JsonFactory jsonFactory, String idTokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser(jsonFactory).setPayloadClass(Payload.class).parse(idTokenString);
        return new IdToken(jws.getHeader(), (Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static class Payload
    extends JsonWebToken.Payload {
        @Key(value="auth_time")
        private Long authorizationTimeSeconds;
        @Key(value="azp")
        private String authorizedParty;
        @Key
        private String nonce;
        @Key(value="at_hash")
        private String accessTokenHash;
        @Key(value="acr")
        private String classReference;
        @Key(value="amr")
        private List<String> methodsReferences;

        public final Long getAuthorizationTimeSeconds() {
            return this.authorizationTimeSeconds;
        }

        public Payload setAuthorizationTimeSeconds(Long authorizationTimeSeconds) {
            this.authorizationTimeSeconds = authorizationTimeSeconds;
            return this;
        }

        public final String getAuthorizedParty() {
            return this.authorizedParty;
        }

        public Payload setAuthorizedParty(String authorizedParty) {
            this.authorizedParty = authorizedParty;
            return this;
        }

        public final String getNonce() {
            return this.nonce;
        }

        public Payload setNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final String getAccessTokenHash() {
            return this.accessTokenHash;
        }

        public Payload setAccessTokenHash(String accessTokenHash) {
            this.accessTokenHash = accessTokenHash;
            return this;
        }

        public final String getClassReference() {
            return this.classReference;
        }

        public Payload setClassReference(String classReference) {
            this.classReference = classReference;
            return this;
        }

        public final List<String> getMethodsReferences() {
            return this.methodsReferences;
        }

        public Payload setMethodsReferences(List<String> methodsReferences) {
            this.methodsReferences = methodsReferences;
            return this;
        }

        @Override
        public Payload setExpirationTimeSeconds(Long expirationTimeSeconds) {
            return (Payload)super.setExpirationTimeSeconds(expirationTimeSeconds);
        }

        @Override
        public Payload setNotBeforeTimeSeconds(Long notBeforeTimeSeconds) {
            return (Payload)super.setNotBeforeTimeSeconds(notBeforeTimeSeconds);
        }

        @Override
        public Payload setIssuedAtTimeSeconds(Long issuedAtTimeSeconds) {
            return (Payload)super.setIssuedAtTimeSeconds(issuedAtTimeSeconds);
        }

        @Override
        public Payload setIssuer(String issuer) {
            return (Payload)super.setIssuer(issuer);
        }

        @Override
        public Payload setAudience(Object audience) {
            return (Payload)super.setAudience(audience);
        }

        @Override
        public Payload setJwtId(String jwtId) {
            return (Payload)super.setJwtId(jwtId);
        }

        @Override
        public Payload setType(String type) {
            return (Payload)super.setType(type);
        }

        @Override
        public Payload setSubject(String subject) {
            return (Payload)super.setSubject(subject);
        }

        @Override
        public Payload set(String fieldName, Object value) {
            return (Payload)super.set(fieldName, value);
        }

        @Override
        public Payload clone() {
            return (Payload)super.clone();
        }
    }
}

