% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbIsValid,DatabaseConnectorDbiConnection-method}
\alias{dbIsValid,DatabaseConnectorDbiConnection-method}
\title{Is this DBMS object still valid?}
\usage{
\S4method{dbIsValid}{DatabaseConnectorDbiConnection}(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
\code{dbIsValid()} returns a logical scalar,
\code{TRUE} if the object specified by \code{dbObj} is valid,
\code{FALSE} otherwise.
A \linkS4class{DBIConnection} object is initially valid,
and becomes invalid after disconnecting with \code{\link[DBI:dbDisconnect]{dbDisconnect()}}.
For an invalid connection object (e.g., for some drivers if the object
is saved to a file and then restored), the method also returns \code{FALSE}.
A \linkS4class{DBIResult} object is valid after a call to \code{\link[DBI:dbSendQuery]{dbSendQuery()}},
and stays valid even after all rows have been fetched;
only clearing it with \code{\link[DBI:dbClearResult]{dbClearResult()}} invalidates it.
A \linkS4class{DBIResult} object is also valid after a call to \code{\link[DBI:dbSendStatement]{dbSendStatement()}},
and stays valid after querying the number of rows affected;
only clearing it with \code{\link[DBI:dbClearResult]{dbClearResult()}} invalidates it.
If the connection to the database system is dropped (e.g., due to
connectivity problems, server failure, etc.), \code{dbIsValid()} should return
\code{FALSE}. This is not tested automatically.
}
\description{
This generic tests whether a database object is still valid (i.e. it hasn't
been disconnected or cleared).

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbIsValid")}
}
\seealso{
Other DBIDriver generics: 
\code{\link[DBI]{DBIDriver-class}},
\code{\link[DBI]{dbCanConnect}()},
\code{\link[DBI]{dbConnect}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDriver}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbListConnections}()}

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}

Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
