% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{renderTranslateQuerySql.ffdf}
\alias{renderTranslateQuerySql.ffdf}
\title{Render, translate, and query to ffdf}
\usage{
renderTranslateQuerySql.ffdf(connection, sql,
  errorReportFile = file.path(getwd(), "errorReport.txt"),
  snakeCaseToCamelCase = FALSE, oracleTempSchema = NULL, ...)
}
\arguments{
\item{connection}{The connection to the database server.}

\item{sql}{The SQL to be send.}

\item{errorReportFile}{The file where an error report will be written if an error occurs. Defaults to
'errorReport.txt' in the current working directory.}

\item{snakeCaseToCamelCase}{If true, field names are assumed to use snake_case, and are converted to camelCase.}

\item{oracleTempSchema}{A schema that can be used to create temp tables in when using Oracle or Impala.}

\item{...}{Parameters that will be used to render the SQL.}
}
\value{
An ffdf object
}
\description{
This function renders, and translates SQL, sends it to the server, and returns the results as an ffdf object
}
\details{
This function calls the \code{render} and \code{translate} functions in the SqlRender package before 
calling \code{\link{querySql.ffdf}}.
}
\examples{
\dontrun{
connectionDetails <- createConnectionDetails(dbms = "postgresql",
                                             server = "localhost",
                                             user = "root",
                                             password = "blah",
                                             schema = "cdm_v4")
conn <- connect(connectionDetails)
persons <- renderTranslatequerySql.ffdf(conn, 
                                        sql = "SELECT * FROM @schema.person",
                                        schema = "cdm_synpuf")
disconnect(conn)
}
}
