% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbGetStatement,DatabaseConnectorResult-method}
\alias{dbGetStatement,DatabaseConnectorResult-method}
\title{Get the statement associated with a result set}
\usage{
\S4method{dbGetStatement}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbGetStatement()} returns a string, the query used in
either \code{\link[=dbSendQuery]{dbSendQuery()}}
or \code{\link[=dbSendStatement]{dbSendStatement()}}.
Attempting to query the statement for a result set cleared with
\code{\link[=dbClearResult]{dbClearResult()}} gives an error.
}
\description{
Returns the statement that was passed to \code{\link[=dbSendQuery]{dbSendQuery()}}
or \code{\link[=dbSendStatement]{dbSendStatement()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetStatement")}
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
