% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_conf.R
\name{special_simulation}
\alias{special_simulation}
\alias{opt_simul_spec_character}
\alias{opt_simul_spec_numeric}
\alias{opt_simul_spec_integer}
\alias{opt_simul_spec_logical}
\alias{opt_simul_spec_date}
\title{Set of functions defining special simulation methods for column and its type}
\usage{
opt_simul_spec_character(name = simul_spec_character_name, ...)

opt_simul_spec_numeric(distr = simul_spec_numeric_distr, ...)

opt_simul_spec_integer(distr = simul_spec_integer_distr, ...)

opt_simul_spec_logical(distr = simul_spec_logical_distr, ...)

opt_simul_spec_date(distr = simul_spec_date_distr, ...)
}
\arguments{
\item{name}{Function for simulating personal names.}

\item{...}{Other custom special methods.}

\item{distr}{Function for simulating data from desired distribution.}
}
\description{
Whenever there's a need to simulate column using specific function (as a \code{spec}
parameter in YAML configuration file), such method should be defined in one of
\code{opt_simul_spec_<column_type>} functions.
}
\details{
Currently defined special methods are:
\itemize{
  \item{name}{
    For character column, that allows to simulate character reflecting real names and surnames
  }
  \item{distr}{
    For all the remaining column types. The method allows to simulate data with specified
    distribution generator, such as \code{rnorm}, \code{rbinom} etc.
  }
}

Each 'spec' method receives \code{n} parameter (the desired number of rows to simulate),
all the default column-based parameters (type, unique, not_null, etc.) but also a special
one named \code{spec_params} that are applied to selected distribution simulation method.

See for example \code{\link{simul_spec_character_name}} definition.
}
