% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prcomp.r
\name{plot_prcomp}
\alias{plot_prcomp}
\title{Visualize principle component analysis}
\usage{
plot_prcomp(data, variance_cap = 0.8, maxcat = 50L, title = NULL,
  ggtheme = theme_gray(), theme_config = list(), ...)
}
\arguments{
\item{data}{input data}

\item{variance_cap}{maximum cumulative explained variance allowed for all principle components. Default is 80\%.}

\item{maxcat}{maximum categories allowed for each discrete feature. The default is 50.}

\item{title}{plot title starting from page 2.}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{\dots}{other arguments to be passed to \link{prcomp}.}
}
\description{
Visualize output of \link{prcomp}.
}
\details{
When cumulative explained variance exceeds \code{variance_cap}, remaining principle components will be ignored. Set \code{variance_cap} to 1 for all principle components.

Discrete features containing more categories than \code{maxcat} specifies will be ignored.

To change default font family and size, you may pass \code{base_size} and \code{base_family} to \code{ggtheme} options, e.g., \code{ggtheme = theme_gray(base_size = 15, base_family = "serif")}

\code{theme_config} argument expects all inputs to be wrapped in a list object, e.g., to change the text color: \code{theme_config = list("text" = element_text(color = "blue"))}
}
\note{
Discrete features will be \link{dummify}-ed first before passing to \link{prcomp}.
}
\examples{
data("diamonds", package = "ggplot2")
plot_prcomp(diamonds, maxcat = 5, scale. = TRUE)
}
\keyword{plot_prcomp}
