% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_report.r
\name{create_report}
\alias{create_report}
\alias{GenerateReport}
\title{create_report Function}
\usage{
create_report(data, output_file = "report.html", output_dir = getwd(), ...)
}
\arguments{
\item{data}{data source to be profiled, in either \link{data.frame} or \link{data.table} format.}

\item{output_file}{output file name. The default is "report.html".}

\item{output_dir}{output directory for report. The default is user's current directory.}

\item{\dots}{other arguments to be passed to \link{render}.}
}
\description{
This function generates the report of data profiling.
}
\examples{
\dontrun{
# load library
library(ggplot2)
library(data.table)

# load diamonds dataset from ggplot2
data("diamonds", package = "ggplot2")
diamonds2 <- data.table(diamonds)

# manually set some missing values
for (j in 5:ncol(diamonds2)) {
  set(diamonds2,
      i = sample.int(nrow(diamonds2), sample.int(nrow(diamonds2), 1)),
      j,
      value = NA_integer_)}

# generate report for diamonds2 dataset
create_report(diamonds2,
               output_file = "report.html",
               output_dir = getwd(),
               html_document(toc = TRUE, toc_depth = 6, theme = "flatly"))
}
}
\keyword{create_report}
