% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DropVar.r
\name{DropVar}
\alias{DropVar}
\title{Drop selected variables}
\usage{
DropVar(data, ind)
}
\arguments{
\item{data}{input data, in \link{data.table} format only.}

\item{ind}{a vector of either names or column positions of the variables to be dropped.}
}
\description{
Quickly drop variables by either name or column position.
}
\details{
\bold{This function will only work with \link{data.table} object as input.} Consider setting your input to \link{data.table} first then assign the original class back after applying the function.
}
\examples{
# load packages
library(data.table)

# generate data
dt <- data.table(sapply(setNames(letters, letters), function(x) {assign(x, rnorm(100))}))
dt2 <- copy(dt)

# drop variables by name
names(dt)
DropVar(dt, letters[2:25])
names(dt)

# drop variables by column position
names(dt2)
DropVar(dt2, seq(2, 25))
names(dt2)

# work with non-data.table objects
iris_df <- data.table(iris)
DropVar(iris_df, "Species")
class(iris_df) <- "data.frame"
}
\keyword{dropvar}

