##' Dasst: a package for reading, processing and writing DSSAT-style files
##'
##' The \pkg{Dasst} (DSSAT-style AS Simple Tables) package
##' provides methods for reading, processing and writing files
##' originally formatted for the 'DSSAT-CSM' crop simulation models.
##' 
##' The \pkg{Dasst} package defines the \code{\linkS4class{Dasst}}
##' class which enables to store the data
##' encoded for the 'DSSAT-CSM' crop simulation models as an S4 object,
##' both for the inputs and the outputs. Several methods are available.
##'
##' @seealso \linkS4class{Dasst} for class definition,
##' \code{\link{show}}, \code{\link{summary}}, \code{\link{[[}}
##' \code{\link{[}} methods for content description, and
##' \code{\link{read.dssat}} function
##' for reading files. For other available methods
##' see INDEX file.
##'
##' An object example is available at \code{\link{plantGrowth}}.
##'
##' @docType package
##' @name Dasst-package
##' @aliases Dasst-package
##' @rdname Dasst-package
##' @author Homero Lozza, \email{homerolozza@@gmail.com}
##'
NULL

