% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndexCPP.R
\name{IndexCPP}
\alias{IndexCPP}
\title{Calculate the Consistency Proportion Index (CPP)}
\usage{
IndexCPP(I)
}
\arguments{
\item{I}{A matrix where each row represents a case and each column represents a cluster assignment. The last column should indicate the group membership (1, 2, or 3).}
}
\value{
A list containing:
\item{ICPP}{The Consistency Proportion Index.}
}
\description{
This function calculates the Consistency Proportion Index (CPP), a measure of the consistency of clustering results.
The CPP is calculated by determining the most common cluster assignment for each group and then computing the proportion of cases that are assigned to these clusters.
}
\examples{
# Example usage
set.seed(123)
n <- 100
values1 <- sample(1:3, 30, replace = TRUE)
values2 <- sample(1:3, 30, replace = TRUE) + 1
values3 <- sample(1:3, 40, replace = TRUE) + 2
values <- c(values1, values2, values3)
categories <- c(rep(1, 30), rep(2, 30), rep(3, 40))
I <- cbind(1:n, values, categories)
CPP <- IndexCPP(I)
print(CPP)

}
\keyword{clustering}
\keyword{consistency}
