% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSSP_fun.R
\name{residuals.dsspMod}
\alias{residuals.dsspMod}
\title{Get residuals from \code{dsspMod} model}
\usage{
\method{residuals}{dsspMod}(object, newdata, robust = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{dsspMod}}

\item{newdata}{a data frame for which to estimate residuals.}

\item{robust}{whether or not to use median (rather than mean) of posterior
density to as estimate calculate residuals.}

\item{...}{additional arguments which are ignored.}
}
\value{
vector containing residuals with same length as rows in data used.
}
\description{
Get residuals from \code{dsspMod} model
}
\examples{
library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y

f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter

## Draw 100 samples from the posterior of eta given the data y.
OUTPUT <- DSSP(
  formula = log(zinc) ~ 1, data = meuse.all, N = 100,
  pars = c(0.001, 0.001), log_prior = f
)
residuals(OUTPUT)
}
