% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_dssat.R
\name{run_dssat}
\alias{run_dssat}
\title{Writes data from a single DSSAT data tier}
\usage{
run_dssat(run_mode = "B", file_name = NULL, suppress_output = FALSE, wd = NULL)
}
\arguments{
\item{run_mode}{a length-one character vector that specifies the run
mode that should be used for the DSSAT simulation. One of:
   A - Run all treatments.  User specifies fileX on the command
       line and the model runs all treatments
   B - Batch mode. User defines fileX and treatment numbers in
       Batch file
   C - Command line mode.  Use input from the command line.
   D - Debug mode.  Model skips input module and reads temp
       file from the command line
   E - Sensitivity analysis.  User defines fileX and treatment
       number in Batch file
   F - Farm model.  Use Batch file to define experiment
   G - Gencalc. Use Command line to define experiment and treatment
   I - Interactive mode.  Use model interface for exp. & trtno.
   L - Gene based model (Locus). Use Batch file to define experiment
   N - Seasonal analysis. Use Batch file to define experiment and
       treatments
   Q - Sequence analysis. Use Batch file to define experiment
   S - Spatial.  Use Batch file to define experiment
   T - Gencalc. Use Batch file to define experiments and treatment}

\item{file_name}{a length-one character vector that specifies the file
name to be used for simulation. Usually the name of a batch file or file X.}

\item{suppress_output}{a logical value indicating whether to suppress DSSAT-CSM
output from being printed to the console}

\item{wd}{an optional character string that specifies the working directory
within which to run DSSAT-CSM. If left NULL, DSSAT-CSM will be run in the
current working directory}
}
\value{
Invisibly returns the console output from running DSSAT-CSM
}
\description{
Writes data from a single DSSAT data tier
}
\examples{

\dontrun{
  run_dssat()
}

}
