% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSResult.R
\name{dsIsCompleted}
\alias{dsIsCompleted}
\title{Get whether the operation is completed}
\usage{
dsIsCompleted(res)
}
\arguments{
\item{res}{An object inheriting from \code{\link{DSResult-class}}.}
}
\value{
A logical
}
\description{
Get whether the result from a previous assignment or aggregation operation was 
completed, either with a successful status or a failed one. This call must not
wait for the completion, immediate response is expected. Once the result is
identified as being completed, the raw result the operation can be get directly.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsIsCompleted")}
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsAssignExpr(con, "C", as.symbol("c(1, 2, 3)"))
res <- dsAggregate(con, as.symbol("length(C)"), async = TRUE)
completed <- dsIsCompleted(res)
while (!completed) {
  Sys.sleep(1)
  completed <- dsIsCompleted(res)
}
length <- dsFetch(res)
dsDisconnect(con)
}
}
\seealso{
Other DSResult generics: 
\code{\link{DSResult-class}},
\code{\link{dsFetch}()},
\code{\link{dsGetInfo}()}
}
\concept{DSResult generics}
