% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsListMethods}
\alias{dsListMethods}
\title{Get the DataSHIELD methods}
\usage{
dsListMethods(conn, type = "aggregate")
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}

\item{type}{Type of the method: "aggregate" (default) or "assign".}
}
\value{
A data.frame with columns: name, type ('aggregate' or 'assign'), class ('function' or 'script'), value, package, version.
}
\description{
Get the list of DataSHIELD methods that have been configured on the remote data repository.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsListMethods")}
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsListMethods(con)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsListPackages}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
