% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_Host_Heterogeneity_Model_ode.R
\name{simulate_Host_Heterogeneity_Model_ode}
\alias{simulate_Host_Heterogeneity_Model_ode}
\title{Host Heterogeneity Model}
\usage{
simulate_Host_Heterogeneity_Model_ode(
  S1 = 1000,
  I1 = 1,
  R1 = 0,
  S2 = 200,
  I2 = 1,
  R2 = 0,
  b11 = 0.01,
  b12 = 0,
  b21 = 0,
  b22 = 0,
  g1 = 1,
  g2 = 1,
  w1 = 0,
  w2 = 0,
  tstart = 0,
  tfinal = 60,
  dt = 0.1
)
}
\arguments{
\item{S1}{: starting value for Susceptible type 1 hosts : numeric}

\item{I1}{: starting value for Infected type 1 hosts : numeric}

\item{R1}{: starting value for Recovered type 1 hosts : numeric}

\item{S2}{: starting value for Susceptible type 2 hosts : numeric}

\item{I2}{: starting value for Infected type 2 hosts : numeric}

\item{R2}{: starting value for Recovered type 2 hosts : numeric
Values for model parameters : numeric}

\item{b11}{: rate of transmission to susceptible type 1 host from infected type 1 host : numeric}

\item{b12}{: rate of transmission to susceptible type 1 host from infected type 2 host : numeric}

\item{b21}{: rate of transmission to susceptible type 2 host from infected type 1 host : numeric}

\item{b22}{: rate of transmission to susceptible type 2 host from infected type 2 host : numeric}

\item{g1}{: the rate at which infected type 1 hosts recover : numeric}

\item{g2}{: the rate at which infected type 2 hosts recover : numeric}

\item{w1}{: the rate at which type 1 host immunity wanes : numeric}

\item{w2}{: the rate at which type 2 host immunity wanes : numeric
Values for model times : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
An SIR type model stratified for two different types of hosts.
}
\details{
This model tracks susceptibles, infected and recovered of 2 different types. Think of those types as e.g. males/females, children/adults, etc. The model includes infection, recovery and waning immunity processes for both hosts.

This code was generated by the modelbuilder R package.  
The model is implemented as a set of ordinary differential equations using the deSolve package. 
The following R packages need to be loaded for the function to work: deSolve. 

Starting conditions for model variables
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel, Alexis Vittengl
}

\section{Model creation date}{
 2020-09-24
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2020-09-24
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_Host_Heterogeneity_Model_ode() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_Host_Heterogeneity_Model_ode(S1 = 2000,I1 = 2,R1 = 0,S2 = 400,I2 = 2,R2 = 0) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'S1'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of S1: ',max(result$ts[,'S1']))) 
}
