context("drcfit_model")
test_that("drcfit works as expected on the model results",
  {
    skip_on_cran()
    skip_on_os(c("mac", "linux", "solaris"))
    datafilename <- system.file("extdata", "transcripto_sample.txt", package="DRomics")
    o <- microarraydata(datafilename, check = TRUE, norm.method = "cyclicloess")
    s_quad <- itemselect(o, select.method = "quadratic", FDR = 0.001)
    f <- drcfit(s_quad, progressbar = TRUE)
    tmodel <- table(f$fitres$model)
    expect_equal(as.numeric(tmodel["Hill"]), 2)
    expect_equal(as.numeric(tmodel["linear"]), 9)
    expect_equal(as.numeric(tmodel["exponential"]), 28)
    expect_equal(as.numeric(tmodel["Gauss-probit"]), 26)
    expect_equal(as.numeric(tmodel["log-Gauss-probit"]), 2)
    expect_equal(round(mean(f$fitres$b, na.rm = TRUE), 4), 1.7086)
    expect_equal(round(mean(f$fitres$c, na.rm = TRUE), 4), 3.0414)
    expect_equal(round(mean(f$fitres$d, na.rm = TRUE), 4), 7.7127)
    expect_equal(round(mean(f$fitres$e, na.rm = TRUE), 4), 1.5259)
    expect_equal(round(mean(f$fitres$f, na.rm = TRUE), 4), 6.0096)
  })