% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ibs.pairwise.db.R
\name{ibs.pairwise.pr}
\alias{ibs.pairwise.pr}
\title{Compute the probabilities that two profiles match a number of loci fully/partially}
\usage{
ibs.pairwise.pr(freqs1, freqs2 = freqs1, k = "UN")
}
\arguments{
\item{freqs1}{List of allelic frequencies.}

\item{freqs2}{List of allelic frequencies.}

\item{k}{IBD-probabilities, passed on to \code{\link{ibdprobs}}. Defaults to "UN", i.e. unrelated.}
}
\value{
Matrix with the expected number of full/partial matches on 0,1,2,... loci for a comparison between two profiles.
}
\description{
When two profiles are compared, this function computes the expected number of loci that match fully or partially.
}
\details{
When all profiles in the database are compared pairwise, one can count the number of profiles that match fully/partially for each number of loci. Such a procedure is implemented as \code{\link{ibs.pairwise.db}}. The current function computes the probabilities that a single pair matches fully and partially at each possible number of loci. The two profiles can be assumed to originate from population with different allele frequencies (\code{freqs1} and \code{freqs2}), might be related through and might both be inbred.
}
\examples{
data(freqsNLsgmplus)

# sample small db and make all pairwise comparisons

N <- 1e3
db <- sample.profiles(N=N,freqs=freqsNLsgmplus)

O <- ibs.pairwise.db(db)
E <- N*(N-1)/2*ibs.pairwise.pr(freqs1 = freqsNLsgmplus,freqs2 = freqsNLsgmplus)

O # observed
E # expected
}
\seealso{
\code{\link{as.dbcompare}}
}

