% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/profiles.R
\name{get.labels}
\alias{get.labels}
\title{Retrieve the allele labels from the allele frequencies}
\usage{
get.labels(freqs)
}
\arguments{
\item{freqs}{list of allele frequencies}
}
\description{
A \code{\link{profiles}} object is an integer matrix with two columns per marker and may carry allele frequencies. This function extracts the labels from the allele frequencies.
}
\examples{
data(freqsNLsgmplus)
           x<- sample.profiles(1,freqsNLsgmplus)
           labels <- get.labels(freqsNLsgmplus)

           stopifnot(identical(labels,get.labels(get.freqs(x))))
}

