% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmcsim}
\alias{plot.dmcsim}
\title{plot.dmcsim: Plot dmc simulation}
\usage{
\method{plot}{dmcsim}(
  x,
  figType = "summary1",
  xlimActivation = NULL,
  ylimActivation = NULL,
  xlimTrials = NULL,
  ylimTrials = NULL,
  xlimPDF = NULL,
  ylimPDF = NULL,
  xlimCDF = NULL,
  ylimCAF = NULL,
  cafBinLabels = FALSE,
  ylimDelta = NULL,
  xlimDelta = NULL,
  ylimRt = NULL,
  ylimErr = NULL,
  labels = c("Compatible", "Incompatible"),
  cols = c("green", "red"),
  errorBars = FALSE,
  xlabs = TRUE,
  ylabs = TRUE,
  xaxts = TRUE,
  yaxts = TRUE,
  xylabPos = 2,
  resetPar = TRUE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{Output from dmcSim}

\item{figType}{summary1, summary2, summary3, activation, trials, pdf, cdf,
caf, delta, deltaErrors, deltaER, rtCorrect, rtErrors, errorRate, all}

\item{xlimActivation}{xlimit for activation plot}

\item{ylimActivation}{ylimit for activation plot}

\item{xlimTrials}{xlimit for trials plot}

\item{ylimTrials}{ylimit for trials plot}

\item{xlimPDF}{xlimit for PDF plot}

\item{ylimPDF}{ylimit for PDF plot}

\item{xlimCDF}{xlimit for CDF plot}

\item{ylimCAF}{ylimit for CAF plot}

\item{cafBinLabels}{TRUE/FALSE}

\item{ylimDelta}{ylimit for delta plot}

\item{xlimDelta}{xlimit for delta plot (Default is 0 to tmax)}

\item{ylimRt}{ylimit for rt plot}

\item{ylimErr}{ylimit for er plot}

\item{labels}{Condition labels c("Compatible", "Incompatible") default}

\item{cols}{Condition colours c("green", "red") default}

\item{errorBars}{TRUE/FALSE}

\item{xlabs}{TRUE/FALSE}

\item{ylabs}{TRUE/FALSE}

\item{xaxts}{TRUE/FALSE}

\item{yaxts}{TRUE/FALSE}

\item{xylabPos}{2}

\item{resetPar}{TRUE/FALSE Reset graphical parameters}

\item{legend}{TRUE/FALSE}

\item{...}{additional plot pars}
}
\value{
Plot (no return value)
}
\description{
Plot the simulation results from the output of dmcSim. The plot
can be an overall summary, or individual plots (activation, trials, pdf, cdf,
caf, delta, all). Plot type summary1 contains an activation plot, example
individual trials, the probability distribution function (PDF), the cumulative
distribution function (CDF), the conditional accuracy function (CAF) and
delta plot. This requires that dmcSim is run with fullData = TRUE. Plot type
summary2 contains only the PDF, CDF, CAF and delta plots and does not require
that dmcSim is run with fullData = TRUE.
}
\examples{
\donttest{
# Example 1
dmc = dmcSim(fullData = TRUE)
plot(dmc)

# Example 2
dmc = dmcSim()
plot(dmc)

# Example 3
dmc = dmcSim(tau = 120)
plot(dmc)

# Example 4
dmc = dmcSim()
plot(dmc, figType = "all")

}

}
