% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcSim.R
\name{dmcSims}
\alias{dmcSims}
\title{dmcSims: Run multiple dmc simulations}
\usage{
dmcSims(params, printInputArgs = FALSE, printResults = FALSE)
}
\arguments{
\item{params}{(list of parameters to dmcSim)}

\item{printInputArgs}{Print DMC input arguments to console}

\item{printResults}{Print DMC output to console}
}
\value{
dmcSims returns a list of objects of class "dmcsim"
}
\description{
Run dmcSim with range of input parameters.
}
\examples{
\donttest{
# Example 1
params <- list(amp = seq(10, 20, 5), tau = c(50, 100, 150), nTrl = 50000)
dmc <- dmcSims(params)
plot(dmc[[1]]) # full combination 1
plot(dmc) # delta plots for all combinations
plot(dmc[c(1:3)]) # delta plots for specific combinations
plot(dmc[c(1, 3)]) # delta plots for specific combinations

# Example 2
params <- list(amp = seq(10, 20, 5), tau = seq(20, 40, 20), bnds = seq(50, 100, 25))
dmc <- dmcSims(params)
plot(dmc[[1]]) # combination 1
plot(dmc, ncol = 2) # delta plots for all combinations
plot(dmc[c(1:3)]) # delta plots for specific combinations
}

}
