% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{mean.dmcfit}
\alias{mean.dmcfit}
\title{mean.dmcfit: Return mean simulation results from dmcFitSubject}
\usage{
\method{mean}{dmcfit}(x, ...)
}
\arguments{
\item{x}{Output from dmcFitSubject}

\item{...}{pars}
}
\value{
dmcfit

The function returns a list with the relevant aggregated results dmcFitSubject. The list
is accessed with obj$name and so on with the the following:
\item{obj$means}{means}
\item{obj$delta}{delta}
\item{obj$caf}{caf}
\item{obj$prms}{par}
}
\description{
Aggregated simulation results from dmcFitSubject.
}
\examples{
\donttest{
# Example 1: Fit individual data then aggregate
fitSubjects <- dmcFitSubject(flankerData, nTrl = 1000, subjects = c(1, 2))
plot(fitSubjects, flankerData, subject = 1)
summary(fitSubjects)
fitAgg <- mean(fitSubjects)
plot(fitAgg, flankerData)
}

}
