% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{calculateDelta}
\alias{calculateDelta}
\title{calculateDelta}
\usage{
calculateDelta(
  dat,
  stepDelta = 5,
  columns = c("VP", "Comp", "RT"),
  compCoding = c("comp", "incomp"),
  quantileType = 5
)
}
\arguments{
\item{dat}{DataFrame with columns containing the participant number, condition
compatibility, and RT data (in ms).}

\item{stepDelta}{Step size for the Delta bins. For example, a step size of 5 would result
in 19 CAF bins positioned at 5, 10, 15, ... 85, 90, 95\%.}

\item{columns}{Name of required columns Default: c("VP", "Comp", "RT")}

\item{compCoding}{Coding for compatibility Default: c("comp", "incomp")}

\item{quantileType}{Argument (1-9) from R function quantile specifying the algorithm (?quantile)}
}
\value{
DataFrame (tibble)
}
\description{
Calculate delta plot. Here RTs are split into n bins (Default: 5) for compatible and
incompatible trials separately. Mean RT is calculated for each condition in each bin then
subtracted (incompatible - compatible) to give a compatibility effect (delta) at each bin.
}
\examples{
# Example 1
dat <- createDF(nVP = 50, nTrl = 100, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"   = c(500, 80, 100),
                           "Comp_incomp" = c(600, 80, 140)))
delta <- calculateDelta(dat)

# Example 2
dat <- createDF(nVP = 50, nTrl = 100, design = list("Congruency" = c("cong", "incong")))
dat <- addDataDF(dat,
                 RT = list("Congruency_cong"   = c(500, 80, 100),
                           "Congruency_incong" = c(600, 80, 140)))
head(dat)
delta <- calculateDelta(dat, columns = c("VP", "Congruency", "RT"),
                        compCoding = c("cong", "incong"))

}
