% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{CC1}
\alias{CC1}
\alias{CC2}
\alias{CC3}
\alias{CC4}
\alias{CC5}
\alias{CurC}
\title{Geromont and Butterworth (2015) Constant Catch}
\usage{
CC1(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0)

CC2(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.1)

CC3(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.2)

CC4(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.3)

CC5(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.4)

CurC(x, Data, reps = 100, plot = FALSE, yrsmth = 1, xx = 0)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which to calculate mean catches}

\item{xx}{Parameter controlling the TAC. Mean catches are multiplied by
(1-\code{xx})}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
The TAC is the average historical catch over the last \code{yrsmth} (default 5) years,
multiplied by (1-\code{xx})
}
\details{
The TAC is calculated as:
\deqn{\textrm{TAC} = (1-x)C_{\textrm{ave}}}
where \emph{x} lies between 0 and 1, and \eqn{C_{\textrm{ave}}} is average historical
catch over the previous \code{yrsmth} years.

The TAC is constant for all future projections.
}
\section{Functions}{
\itemize{
\item \code{CC1}: TAC is average historical catch from recent \code{yrsmth} years

\item \code{CC2}: TAC is average historical catch from recent \code{yrsmth} years reduced by 10\\%.

\item \code{CC3}: TAC is average historical catch from recent \code{yrsmth} years reduced by 20\\%.

\item \code{CC4}: TAC is average historical catch from recent \code{yrsmth} years reduced by 30\\%.

\item \code{CC5}: TAC is average historical catch from recent \code{yrsmth} years reduced by 40\\%.

\item \code{CurC}: TAC is fixed at last historical catch
}}

\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{CC1}: Cat, LHYear, Year
}

\section{Rendered Equations}{

See \href{https://blue-matter.github.io/DLMtool/reference/CC1.html}{Online Documentation} for correctly rendered equations
}

\examples{
CC1(1, MSEtool::Cobia, plot=TRUE)

CC2(1, MSEtool::Cobia, plot=TRUE)

CC3(1, MSEtool::Cobia, plot=TRUE)

CC4(1, MSEtool::Cobia, plot=TRUE)

CC5(1, MSEtool::Cobia, plot=TRUE)

CurC(1, MSEtool::Cobia, plot=TRUE)

}
\references{
Geromont, H. F., and D. S. Butterworth. 2015.
Generic Management Procedures for Data-Poor Fisheries: Forecasting with Few Data.
ICES Journal of Marine Science: Journal Du Conseil 72 (1). 251-61.
}
\seealso{
Other Constant Catch MPs: 
\code{\link{GB_CC}()}
}
\author{
T. Carruthers
}
\concept{Constant Catch MPs}
