# MSE code

# Define classes for operating models
setClass("OM",representation(Name="character",nyears="numeric",maxage="numeric",R0="numeric",M="numeric",
                              Msd="numeric",Mgrad="numeric",h="numeric",SRrel="numeric",Linf="numeric",K="numeric",t0="numeric",
                              Ksd="numeric",Kgrad="numeric",Linfsd="numeric",Linfgrad="numeric",recgrad="numeric",
                              a="numeric",b="numeric",ageM="numeric",ageMsd="numeric",D="numeric",
                              Size_area_1="numeric",Frac_area_1="numeric",Prob_staying="numeric",
                              Source="character",

                              beta="numeric", Spat_targ="numeric",AFS="numeric",age05="numeric",Vmaxage="numeric",
                              Fsd="numeric",Fgrad="numeric",AC="numeric",

                              Cobs="numeric",Cbiascv="numeric",CAAobs="numeric",CALobs="numeric",
                              Iobs="numeric",Perr="numeric",
                              Mcv="numeric",Kcv="numeric",t0cv="numeric",Linfcv="numeric",
                              LFCcv="numeric",
                              LFScv="numeric",
                              B0cv="numeric",FMSYcv="numeric",FMSY_Mcv="numeric",BMSY_B0cv="numeric",
                              ageMcv="numeric",rcv="numeric",Fgaincv="numeric",A50cv="numeric",
                              Dbiascv="numeric",Dcv="numeric",Btbias="numeric",Btcv="numeric",
                              Fcurbiascv="numeric",Fcurcv="numeric",hcv="numeric",
                              Icv="numeric",maxagecv="numeric",
                              Reccv="numeric",Irefcv="numeric",Crefcv="numeric",Brefcv="numeric"))


setMethod("initialize", "OM", function(.Object,Stock,Fleet,Observation){

  if(class(Stock)!='Stock')print(paste('Could not build operating model:',deparse(substitute(Stock)),'not of class Stock'))
  if(class(Fleet)!='Fleet')print(paste('Could not build operating model:',deparse(substitute(Fleet)),'not of class Fleet'))
  if(class(Observation)!='Observation')print(paste('Could not build operating model:',deparse(substitute(Observation)),'not of class Observation'))
  if(class(Stock)!='Stock'|class(Fleet)!='Fleet'|class(Observation)!='Observation')stop()

  .Object@Name<-paste("Stock:",Stock@Name,"  Fleet:",Fleet@Name,"  Observation model:",Observation@Name,sep="")
  # Now copy the values for stock, fleet and observation slots to same slots in the Sim object
  Sslots<-slotNames(Stock)
  for(i in 2:length(Sslots))slot(.Object,Sslots[i])<-slot(Stock,Sslots[i])
  Fslots<-slotNames(Fleet)
  for(i in 2:length(Fslots))slot(.Object,Fslots[i])<-slot(Fleet,Fslots[i])
  Oslots<-slotNames(Observation)
  for(i in 2:length(Oslots))slot(.Object,Oslots[i])<-slot(Observation,Oslots[i])
  .Object

})

setClass("Stock",representation(Name="character",maxage="numeric",R0="numeric",M="numeric",
                Msd="numeric",Mgrad="numeric",h="numeric",SRrel="numeric",Linf="numeric",K="numeric",t0="numeric",
                Ksd="numeric",Kgrad="numeric",Linfsd="numeric",Linfgrad="numeric",recgrad="numeric",
                a="numeric",b="numeric",D="numeric",ageM="numeric",ageMsd="numeric",Perr="numeric",
                Size_area_1="numeric",Frac_area_1="numeric",Prob_staying="numeric",AC="numeric",
                Source="character"))


setMethod("initialize", "Stock", function(.Object,OM){

  dat <- read.csv(paste(getwd(),"/Operating models/Stocks/",OM,".csv",sep=""),header=F,colClasses="character") # read 1st sheet
  dname<-dat[,1]
  dat<-dat[,2:ncol(dat)]

  .Object@Name<-dat[match("Name", dname),1]
  .Object@maxage<-as.numeric(dat[match("maxage",dname),1])
  .Object@R0<-as.numeric(dat[match("R0",dname),1])
  .Object@M<-as.numeric(dat[match("M",dname),1:2])
  .Object@Msd<-as.numeric(dat[match("Msd",dname),1:2])
  .Object@Mgrad<-as.numeric(dat[match("Mgrad",dname),1:2])
  .Object@h<-as.numeric(dat[match("h",dname),1:2])
  .Object@SRrel<-as.numeric(dat[match("SRrel",dname),1])
  .Object@Linf<-as.numeric(dat[match("Linf",dname),1:2])
  .Object@K<-as.numeric(dat[match("K",dname),1:2])
  .Object@t0<-as.numeric(dat[match("t0",dname),1:2])
  .Object@Ksd<-as.numeric(dat[match("Ksd",dname),1:2])
  .Object@Kgrad<-as.numeric(dat[match("Kgrad",dname),1:2])
  .Object@Linfsd<-as.numeric(dat[match("Linfsd",dname),1:2])
  .Object@Linfgrad<-as.numeric(dat[match("Linfgrad",dname),1:2])
  .Object@recgrad<-as.numeric(dat[match("recgrad",dname),1:2])
  .Object@a<-as.numeric(dat[match("a",dname),1])
  .Object@b<-as.numeric(dat[match("b",dname),1])
  .Object@D<-as.numeric(dat[match("D",dname),1:2])
  .Object@ageM<-as.numeric(dat[match("ageM",dname),1:2])
  .Object@ageMsd<-as.numeric(dat[match("ageMsd",dname),1])
  .Object@Perr<-as.numeric(dat[match("Perr",dname),1:2])
  .Object@AC<-as.numeric(dat[match("AC",dname),1:2])
  .Object@Size_area_1<-as.numeric(dat[match("Size_area_1",dname),1:2])
  .Object@Frac_area_1<-as.numeric(dat[match("Frac_area_1",dname),1:2])
  .Object@Prob_staying<-as.numeric(dat[match("Prob_staying",dname),1:2])
  .Object@Source<-dat[match("Source", dname),1]
  .Object

})

setClass("Fleet",representation(Name="character",nyears="numeric", Spat_targ="numeric",
                 AFS="numeric",age05="numeric",Vmaxage="numeric",Fsd="numeric",Fgrad="numeric"))


setMethod("initialize", "Fleet", function(.Object,OM){

  dat <- read.csv(paste(getwd(),"/Operating models/Fleets/",OM,".csv",sep=""),header=F,colClasses="character") # read 1st sheet
  dname<-dat[,1]
  dat<-dat[,2:ncol(dat)]

  .Object@Name<-dat[match("Name", dname),1]
  .Object@nyears <-as.numeric(dat[match("nyears",dname),1])
  .Object@Spat_targ<-as.numeric(dat[match("Spat_targ",dname),1:2])
  .Object@AFS<-as.numeric(dat[match("AFS",dname),1:2])
  .Object@age05<-as.numeric(dat[match("age05",dname),1:2])
  .Object@Vmaxage<-as.numeric(dat[match("Vmaxage",dname),1:2])
  .Object@Fsd<-as.numeric(dat[match("Fsd",dname),1:2])
  .Object@Fgrad<-as.numeric(dat[match("Fgrad",dname),1:2])
  .Object

})



setClass("lmmodel",representation(Name="character",models="list"))

setMethod("initialize", "lmmodel", function(.Object,Name,models){
  
  .Object@Name<-Name
  .Object@models<-models
  .Object
  
})



setClass("Observation",representation(Name="character",ageMcv="numeric",
                Cobs="numeric",Cbiascv="numeric",CAAobs="numeric",CALobs="numeric",
                Iobs="numeric",Mcv="numeric",Kcv="numeric",t0cv="numeric",Linfcv="numeric",
                LFCcv="numeric",LFScv="numeric",B0cv="numeric",
                FMSYcv="numeric",FMSY_Mcv="numeric",BMSY_B0cv="numeric",
                rcv="numeric",A50cv="numeric", Dbiascv="numeric",Dcv="numeric",
                Btbias="numeric",Btcv="numeric",Fcurbiascv="numeric",Fcurcv="numeric",
                hcv="numeric",Icv="numeric",maxagecv="numeric",Reccv="numeric",
                Irefcv="numeric",Crefcv="numeric",Brefcv="numeric",beta="numeric"))


setMethod("initialize", "Observation", function(.Object,OM){

  dat <- read.csv(paste(getwd(),"/Operating models/Observation/",OM,".csv",sep=""),header=F,colClasses="character") # read 1st sheet
  dname<-dat[,1]
  dat<-dat[,2:ncol(dat)]

  .Object@Name<-dat[match("Name", dname),1]
  .Object@ageMcv<-as.numeric(dat[match("ageMsd",dname),1])
  .Object@Cobs<-as.numeric(dat[match("Cobs",dname),1:2])
  .Object@Cbiascv<-as.numeric(dat[match("Cbiascv",dname),1])
  .Object@CAAobs<-as.numeric(dat[match("CAAobs",dname),1:2])
  .Object@CALobs<-as.numeric(dat[match("CALobs",dname),1:2])
  .Object@Iobs<-as.numeric(dat[match("Iobs",dname),1:2])
  .Object@Mcv<-as.numeric(dat[match("Mcv",dname),1])
  .Object@Kcv<-as.numeric(dat[match("Kcv",dname),1])
  .Object@t0cv<-as.numeric(dat[match("t0cv",dname),1])
  .Object@Linfcv<-as.numeric(dat[match("Linfcv",dname),1])
  .Object@LFCcv<-as.numeric(dat[match("LFCcv",dname),1])
  .Object@LFScv<-as.numeric(dat[match("LFScv",dname),1])
  .Object@B0cv<-as.numeric(dat[match("B0cv",dname),1])
  .Object@FMSYcv<-as.numeric(dat[match("FMSYcv",dname),1])
  .Object@FMSY_Mcv<-as.numeric(dat[match("FMSY_Mcv",dname),1])
  .Object@BMSY_B0cv<-as.numeric(dat[match("BMSY_B0cv",dname),1])
  .Object@ageMcv<-as.numeric(dat[match("ageMcv",dname),1])
  .Object@rcv<-as.numeric(dat[match("rcv",dname),1])
  .Object@A50cv<-as.numeric(dat[match("A50cv",dname),1])
  .Object@Dbiascv<-as.numeric(dat[match("Dbiascv",dname),1])
  .Object@Dcv<-as.numeric(dat[match("Dcv",dname),1:2])
  .Object@Btbias<-as.numeric(dat[match("Btbias",dname),1:2])
  .Object@Btcv<-as.numeric(dat[match("Btcv",dname),1:2])
  .Object@Fcurbiascv<-as.numeric(dat[match("Fcurbiascv",dname),1])
  .Object@Fcurcv<-as.numeric(dat[match("Fcurcv",dname),1:2])
  .Object@hcv<-as.numeric(dat[match("hcv",dname),1])
  .Object@Icv<-as.numeric(dat[match("Icv",dname),1])
  .Object@maxagecv<-as.numeric(dat[match("maxagecv",dname),1])
  .Object@Reccv<-as.numeric(dat[match("Reccv",dname),1:2])
  .Object@Irefcv<-as.numeric(dat[match("Irefcv",dname),1])
  .Object@Crefcv<-as.numeric(dat[match("Crefcv",dname),1])
  .Object@Brefcv<-as.numeric(dat[match("Brefcv",dname),1])
  .Object@beta<-as.numeric(dat[match("beta",dname),1:2])
  .Object

})


setClass("MSE",representation(Name="character",nyears="numeric",proyears="numeric",nmeths="numeric",meths="character",
                              nsim="numeric",OM="data.frame",Obs="data.frame",B_BMSY="array",
                              F_FMSY="array",B="array",FM="array",C="array",quota="array",SSB_hist="array",CB_hist="array",FM_hist="array"))

setMethod("initialize", "MSE", function(.Object,Name,nyears,proyears,nmeths,meths,
                                                nsim,OMtable,Obs,B_BMSYa,F_FMSYa,Ba,FMa,Ca,OFLa,SSB_hist,CB_hist,FM_hist){
  .Object@Name<-Name
  .Object@nyears <-nyears
  .Object@proyears<-proyears
  .Object@nmeths<-nmeths
  .Object@meths<-meths
  .Object@nsim<-nsim
  .Object@OM<-OMtable
  .Object@Obs<-Obs
  .Object@B_BMSY<-B_BMSYa
  .Object@F_FMSY<-F_FMSYa
  .Object@B<-Ba
  .Object@FM<-FMa
  .Object@C<-Ca
  .Object@quota<-OFLa
  .Object@SSB_hist<-SSB_hist
  .Object@CB_hist<-CB_hist
  .Object@FM_hist<-FM_hist
  .Object
})

sampy<-function(x) sample(x,1,prob=!is.na(x))

runMSE<-function(OM="1",Meths=NA,nsim=48,proyears=28,interval=4,pstar=0.5,
                 maxF=0.8,timelimit=1,reps=1){

  print("Loading operating model")
  flush.console()
  if(class(OM)!="OM")stop("You must specify an operating model")

  nyears<-OM@nyears  # number of  historical years
  maxage<-OM@maxage  # maximum age (no plus group)
  dep<-runif(nsim,OM@D[1],OM@D[2])  # sample from the range of user-specified depletion (Bcurrent/B0)
  Esd<-runif(nsim,OM@Fsd[1],OM@Fsd[2]) # interannual variability in fishing effort (log normal sd)
  deriv<-getFhist(nsim,Esd,nyears,dFmin=OM@Fgrad[1],dFmax=OM@Fgrad[2],bb=0.5)     # Calculate fishing mortality rate
  Find<-deriv[[1]]     # Calculate fishing mortality rate
  dFfinal<-deriv[[2]]  # Final gradient in F yr-1 
  procsd<-runif(nsim,OM@Perr[1],OM@Perr[2])         # Process error standard deviation
  AC<-runif(nsim,OM@AC[1],OM@AC[2])    # auto correlation parameter for recruitment deviations recdev(t)<-AC*recdev(t-1)+(1-AC)*recdev_proposed(t)
  procmu<--0.5*(procsd)^2 # adjusted log normal mean
  Perr<-array(rnorm((nyears+proyears)*nsim,rep(procmu,nyears+proyears),rep(procsd,nyears+proyears)),c(nsim,nyears+proyears))
  for(y in 2:(nyears+proyears))Perr[,y]<-AC*Perr[,y-1]+Perr[,y]*(1-AC*AC)^0.5#2#AC*Perr[,y-1]+(1-AC)*Perr[,y] # apply a pseudo AR1 autocorrelation to rec devs (log space)
  Perr<-exp(Perr) # normal space (mean 1 on average)
  
  Csd<-runif(nsim,OM@Cobs[1],OM@Cobs[2])               # Observation error standard deviation for single catch at age by area
  Cmu<--0.5*Csd^2                                      # Observation error mean
  Cerr<-array(exp(rnorm(nyears+proyears*nsim,rep(Cmu,nyears+proyears),rep(Csd,nyears+proyears))),c(nsim,nyears+proyears)) # Catch error 

  R0<-OM@R0
  #M<-runif(nsim*100,OM@M[1],OM@M[2]) # redundant code for correlated M - Maturity - K parameters
  M<-runif(nsim,OM@M[1],OM@M[2])
  #temp<-data.frame(M) # redundant code for correlated M - Maturity - K parameters
  #ageMd<-predict.lm(MMatK@models[[1]],temp)# redundant code for correlated M - Maturity - K parameters
  #ageM<-exp(ageMd+rnorm(length(M),0,sd(MMatK@models[[1]]$residuals)))# redundant code for correlated M - Maturity - K parameters
  #cond<-(ageM<0.666*maxage) # upper limit for age at maturity is 2/3 maximum age# redundant code for correlated M - Maturity - K parameters
  #M<-M[cond][1:nsim]# redundant code for correlated M - Maturity - K parameters
  #ageM<-ageM[cond][1:nsim]# redundant code for correlated M - Maturity - K parameters
  #temp<-data.frame(M)# redundant code for correlated M - Maturity - K parameters
  #Kd<-predict.lm(MMatK@models[[2]],temp)# redundant code for correlated M - Maturity - K parameters
  #K<-exp(Kd+rnorm(length(M),0,sd(MMatK@models[[2]]$residuals)/2))# redundant code for correlated M - Maturity - K parameters
    
  Msd<-runif(nsim,OM@Msd[1],OM@Msd[2]) # sample inter annual variabiliyt in M from specified range
  Mgrad<-runif(nsim,OM@Mgrad[1],OM@Mgrad[2]) # sample gradient in M (M y-1)
  Marray<-gettempvar(M,Msd,Mgrad,nyears+proyears,nsim) # M by sim and year according to gradient and inter annual variability
  hs<-runif(nsim,OM@h[1],OM@h[2]) # sample of recruitment compensation (steepness - fraction of unfished recruitment at 20% of unfished biomass)
  SRrel<-rep(OM@SRrel,nsim) # type of Stock-recruit relationship. 1=Beverton Holt, 2=Ricker
  Linf<-runif(nsim,OM@Linf[1],OM@Linf[2]) # sample of maximum length
  Linfsd<-runif(nsim,OM@Linfsd[1],OM@Linfsd[2]) # sample of interannual variability in Linf
  Linfgrad<-runif(nsim,OM@Linfgrad[1],OM@Linfgrad[2]) # sample of gradient in Linf (Linf y-1)
  Linfarray<-gettempvar(Linf,Linfsd,Linfgrad,nyears+proyears,nsim) # Linf array
  recgrad<-runif(nsim,OM@recgrad[1],OM@recgrad[2]) # gradient in recent recruitment
  recyrs<-min(nyears,10) # maximum of 10 years in recent recruitment change
  lastrec<-gettempvar(1,0,recgrad,min(nyears,10),nsim) # find the last year
  rectrad<-lastrec/lastrec[,1] # derived recruitment trajectory
  if(nyears>10)rectrad<-cbind(array(1,dim=c(nsim,nyears-10)),rectrad) # if nyears>10 this is the calculation based on last 10 years
  K<-runif(nsim,OM@K[1],OM@K[2])  # now predicted by a log-linear model
  Ksd<-runif(nsim,OM@Ksd[1],OM@Ksd[2])#runif(nsim,OM@Ksd[1],OM@Ksd[2])# sd is already added in the linear model prediction
  Kgrad<-runif(nsim,OM@Kgrad[1],OM@Kgrad[2]) # gradient in Von-B K parameter (K y-1)
  Karray<-gettempvar(K,Ksd,Kgrad,nyears+proyears,nsim) # the K array
  t0<-runif(nsim,OM@t0[1],OM@t0[2]) # a sample of theoretical age at length zero
  ageM<-runif(nsim,OM@ageM[1],OM@ageM[2])   # now predicted by a log-linear model
  ageMarray<-array(ageM,dim=c(nsim,maxage)) # Age at maturity array
  Agearray<-array(rep(1:maxage,each=nsim),dim=c(nsim,maxage))   # Age array
  Yeararray<-array(rep(1:(nyears+proyears),each=nsim),dim=c(nsim,nyears+proyears))  # Year array
  Mat_age<-1/(1+exp((ageMarray-(Agearray))/(ageMarray*OM@ageMsd)))  # Maturity at age array
  Len_age<-array(NA,dim=c(nsim,maxage,nyears+proyears)) # Length at age array
  ind<-as.matrix(expand.grid(1:nsim,1:maxage,1:(nyears+proyears))) # an index for calculating Length at age
  Len_age[ind]<-Linfarray[ind[,c(1,3)]]*(1-exp(-Karray[ind[,c(1,3)]]*(Agearray[ind[,1:2]]-t0[ind[,1]])))
  Wt_age<-array(NA,dim=c(nsim,maxage,nyears+proyears)) # Weight at age array
  Wt_age[ind]<-OM@a*Len_age[ind]^OM@b                                        # Calculation of weight array
  betas<-exp(runif(nsim,log(OM@beta[1]),log(OM@beta[2]))) # the sampled hyperstability / hyperdepletion parameter beta>1 (hyperdepletion) beta<1 (hyperstability)

  # selectivity
  mod<-runif(nsim*10,OM@AFS[1],OM@AFS[2])*ageM           # the age at modal (or youngest max) selectivity
  mod<-mod[mod<(maxage*0.8)][1:nsim]                     # check to make sure modal selectivity doesn't happen very late
  age05<-runif(nsim,OM@age05[1],OM@age05[2])*ageM        # the highest age at %5 selectivity
  Vmaxage<-runif(nsim,OM@Vmaxage[1],OM@Vmaxage[2])       # selectivity at maximum age
  deriv<-getDNvulnS(mod,age05,Vmaxage,maxage,nsim)           # The vulnerability schedule
  V<-deriv[[1]]
  a50V<-deriv[[2]]
  Spat_targ<-runif(nsim,OM@Spat_targ[1],OM@Spat_targ[2]) # spatial targetting Ba^targetting param 
  Frac_area_1<-runif(nsim,OM@Frac_area_1[1],OM@Frac_area_1[2]) # sampled fraction of unfished biomass in area 1 (its a two area model by default)
  Prob_staying<-runif(nsim,OM@Prob_staying[1],OM@Prob_staying[2]) # sampled probability of individuals staying in area 1 among years
  Size_area_1<-runif(nsim,OM@Size_area_1[1],OM@Size_area_1[2]) # currently redundant parameter for the habitat area size of area 1

  print("Optimizing for user-specified movement")  # Print a progress update
  flush.console()                                  # refresh the console

  if(sfIsRunning()){ # if the cluster is initiated 
    sfExport(list=c("Frac_area_1","Prob_staying")) # export some of the new arrays and ...
    mov<-array(t(sfSapply(1:nsim,getmov,Frac_area_1=Frac_area_1,Prob_staying=Prob_staying)),dim=c(nsim,2,2)) # numerically determine movement probability parameters to match Prob_staying and Frac_area_1
  }else{ # no cluster initiated
    mov<-array(t(sapply(1:nsim,getmov,Frac_area_1=Frac_area_1,Prob_staying=Prob_staying)),dim=c(nsim,2,2)) # numerically determine movement probability parameters to match Prob_staying and Frac_area_1
  }

  nareas<-2  # default is a two area model
  N<-array(NA,dim=c(nsim,maxage,nyears,nareas))        # stock numbers array
  Biomass<-array(NA,dim=c(nsim,maxage,nyears,nareas))  # stock biomass array
  VBiomass<-array(NA,dim=c(nsim,maxage,nyears,nareas)) # vulnerable biomass array

  SSN<-array(NA,dim=c(nsim,maxage,nyears,nareas)) # spawning stock numbers array
  SSB<-array(NA,dim=c(nsim,maxage,nyears,nareas)) # spawning stock biomass array
  FM<-array(NA,dim=c(nsim,maxage,nyears,nareas))  # fishing mortality rate array
  Z<-array(NA,dim=c(nsim,maxage,nyears,nareas))   # total mortlaity rate array

  Agearray<-array(rep(1:maxage,each=nsim),dim=c(nsim,maxage))   # Age array
  surv<-exp(-Marray[,1])^(Agearray-1)                           # Survival array
  Nfrac<-surv*Mat_age                                           # predicted Numbers of mature ages
  initdist<-as.matrix(cbind(Frac_area_1,1-Frac_area_1))         # Get the initial spatial distribution of each simulated population

  R0a<-R0*initdist                                              # Unfished recruitment by area
 
  SAYR<-as.matrix(expand.grid(1:nareas,1,1:maxage,1:nsim)[4:1]) # Set up some array indexes sim (S) age (A) year (Y) region/area (R)
  SAY<-SAYR[,1:3]
  SA<-SAYR[,1:2]
  SR<-SAYR[,c(1,4)]
  S<-SAYR[,1]
  SY<-SAYR[,c(1,3)]

  SSN[SAYR]<-Nfrac[SA]*R0*initdist[SR]                           # Calculate initial spawning stock numbers
  N[SAYR]<-R0*surv[SA]*initdist[SR]                              # Calculate initial stock numbers
  Biomass[SAYR]<-N[SAYR]*Wt_age[SAY]                             # Calculate initial stock biomass
  SSB[SAYR]<-SSN[SAYR]*Wt_age[SAY]                               # Calculate spawning stock biomass
  VBiomass[SAYR]<-Biomass[SAYR]*V[SA]                            # Calculate vunerable biomass
  SSN0<-apply(SSN[,,1,],c(1,3),sum)                              # Calculate unfished spawning stock numbers
  SSB0<-apply(SSB[,,1,],1,sum)                                   # Calculate unfished spawning stock numbers
  SSBpR<-SSB0/R0                                                 # Spawning stock biomass per recruit
  SSB0a<-apply(SSB[,,1,],c(1,3),sum)                             # Calculate unfished spawning stock numbers
  bR<-log(5*hs)/(0.8*SSB0a)                                      # Ricker SR params
  aR<-exp(bR*SSB0a)/SSBpR                                        # Ricker SR params
  
  print("Optimizing for user-specified depletion")               # Print a progress update
  flush.console()                                                # update console
  
  if(sfIsRunning()){
    sfExport(list=c("dep","Find","Perr","Marray","hs","Mat_age","Wt_age","R0","V","nyears","maxage","SRrel","aR","bR"))
    qs<-sfSapply(1:nsim,getq,dep,Find,Perr,Marray,hs,Mat_age,Wt_age,R0,V,nyears,maxage,mov,Spat_targ,SRrel,aR,bR) # find the q that gives current stock depletion
  }else{
    qs<-sapply(1:nsim,getq,dep,Find,Perr,Marray,hs,Mat_age,Wt_age,R0,V,nyears,maxage,mov,Spat_targ,SRrel,aR,bR) # find the q that gives current stock depletion
  }
  
  print("Calculating historical stock and fishing dynamics")     # Print a progress update
  flush.console()                                                # update console
  
  fishdist<-(apply(VBiomass[,,1,],c(1,3),sum)^Spat_targ)/apply(apply(VBiomass[,,1,],c(1,3),sum)^Spat_targ,1,mean)  # spatial preference according to spatial biomass
  FM[SAYR]<-qs[S]*Find[SY]*V[SA]*fishdist[SR]                    # Fishing mortality rate determined by effort, catchability, vulnerability and spatial preference according to biomass
  Z[SAYR]<-FM[SAYR]+Marray[SY]                                   # Total mortality rate                 

  for(y in 1:(nyears-1)){
    # set up some indices for indexed calculation
    SAYR<-as.matrix(expand.grid(1:nareas,y,1:maxage,1:nsim)[4:1]) # Set up some array indexes sim (S) age (A) year (Y) region/area (R)
    SAY1R<-as.matrix(expand.grid(1:nareas,y+1,1:maxage,1:nsim)[4:1])
    SAY<-SAYR[,1:3]
    SA<-SAYR[,1:2]
    SR<-SAYR[,c(1,4)]
    S<-SAYR[,1]
    SY<-SAYR[,c(1,3)]
    SY1<-SAY1R[,c(1,3)]
    indMov<-as.matrix(expand.grid(1:nareas,1:nareas,y+1,1:maxage,1:nsim)[5:1]) # Movement master index
    indMov2<-indMov[,c(1,2,3,4)]                                               # Movement from index
    indMov3<-indMov[,c(1,4,5)]                                                 # Movement to index

    
    if(SRrel[1]==1){
      N[,1,y+1,]<-Perr[,y]*(0.8*R0a*hs*apply(SSB[,,y,],c(1,3),sum))/(0.2*SSBpR*R0a*(1-hs)+(hs-0.2)*apply(SSB[,,y,],c(1,3),sum))  # Recruitment assuming regional R0 and stock wide steepness
    }else{ # most transparent form of the Ricker uses alpha and beta params
      N[,1,y+1,]<-Perr[,y+nyears]*aR*apply(SSB[,,y,],c(1,3),sum)*exp(-bR*apply(SSB[,,y,],c(1,3),sum))
    }
    
    fishdist<-(apply(VBiomass[,,y,],c(1,3),sum)^Spat_targ)/apply(apply(VBiomass[,,y,],c(1,3),sum)^Spat_targ,1,mean)   # spatial preference according to spatial biomass
    FM[SAY1R]<-qs[S]*Find[SY1]*V[SA]*fishdist[SR]                           # Fishing mortality rate determined by effort, catchability, vulnerability and spatial preference according to biomass
    Z[SAY1R]<-FM[SAY1R]+Marray[SY]                                          # Total mortality rate
    N[,2:maxage,y+1,]<-N[,1:(maxage-1),y,]*exp(-Z[,1:(maxage-1),y,])        # Total mortality
    temp<-array(N[indMov2]*mov[indMov3],dim=c(nareas,nareas,maxage,nsim))   # Move individuals
    N[,,y+1,]<-apply(temp,c(4,3,1),sum)
    Biomass[SAY1R]<-N[SAY1R]*Wt_age[SAY]                                    # Calculate biomass
    VBiomass[SAY1R]<-Biomass[SAY1R]*V[SA]                                   # Calculate vulnerable biomass
    SSN[SAY1R]<-N[SAY1R]*Mat_age[SA]                                        # Calculate spawning stock numbers
    SSB[SAY1R]<-SSN[SAY1R]*Wt_age[SAY]                                      # Calculate spawning stock biomass
  
  } # end of year

  CN<-apply(N*(1-exp(-Z))*(FM/Z),c(1,3,2),sum)                              # Catch in numbers
  CB<-Biomass*(1-exp(-Z))*(FM/Z)                                            # Catch in biomass

  Csd<-runif(nsim,OM@Cobs[1],OM@Cobs[2])                                    # Sampled catch observation error (lognormal sd)
  Cbias<-rlnorm(nsim,mconv(1,OM@Cbiascv),sdconv(1,OM@Cbiascv))              # Sampled catch bias (log normal sd)
  Cbiasa<-array(Cbias,c(nsim,nyears+proyears))                              # Bias array
  Cerr<-array(rlnorm((nyears+proyears)*nsim,mconv(1,rep(Csd,(nyears+proyears))),sdconv(1,rep(Csd,nyears+proyears))),c(nsim,nyears+proyears)) # composite of bias and observation error
  Cobs<-Cbiasa[,1:nyears]*Cerr[,1:nyears]*apply(CB,c(1,3),sum)              # Simulated observed catch (biomass)

  nsamp<-ceiling(runif(nsim,OM@CAAobs[1],OM@CAAobs[2]))                     # Number of catch-at-age observations
  CAA<-array(NA,dim=c(nsim,nyears,maxage))                                  # Catch  at age array
  cond<-apply(CN,1:2,sum,na.rm=T)<1                                         # this is a fix for low sample sizes. If CN is zero across the board a single fish is caught in age class of model selectivity (dumb I know)
  fixind<-as.matrix(cbind(expand.grid(1:nsim,1:nyears),rep(ceiling(mod),nyears))) # more fix
  CN[fixind[cond,]]<-1                                                      # puts a catch in the most vulnerable age class
  for(i in 1:nsim)for(j in 1:nyears)CAA[i,j,]<-rmultinom(1,nsamp[i],CN[i,j,]) # a multinomial observation model for catch-at-age data

  CALsd<-runif(nsim,OM@CALobs[1],OM@CALobs[2])                              # Observation error standard deviation for single catch at age by area
  CALmu<--0.5*CALsd^2                                                       # Catch at length lognormal adjustment

  nCALbins<-20                                                              # the number of catch-at-length bins
  CAL_bins<-seq(0,max(Len_age),length.out=nCALbins)                         # the breakpoints of the CAL bins
  CAL_bins<-c(CAL_bins,CAL_bins[nCALbins]*5)                                
  CAL<-array(NA,dim=c(nsim,nyears,nCALbins))                                # the catch at length array
  LFC<-rep(NA,nsim)                                                         # an array for length at first capture
  for(i in 1:nsim){
    for(j in 1:nyears){
      ages<-rep(1:maxage,CAA[i,j,])+runif(sum(CAA[i,j,]),-0.5,0.5)          # sample expected age
      lengths<-Linfarray[i,j]*(1-exp(-Karray[i,j]*(ages-t0[i])))*exp(rnorm(sum(CAA[i,j,]),CALmu[i],CALsd[i])) # calculate length
      CAL[i,j,]<-hist(lengths,CAL_bins,plot=F)$counts                       # assign to bins
      LFC[i]<-min(c(lengths,LFC[i]),na.rm=T)                                # get the smallest CAL observation
    }
  }

  Isd<-runif(nsim,OM@Iobs[1],OM@Iobs[2])                    # Abundance index observation error (log normal sd)
  Ierr<-array(rlnorm((nyears+proyears)*nsim,mconv(1,rep(Isd,nyears+proyears)),sdconv(1,rep(Isd,nyears+proyears))),c(nsim,nyears+proyears))
  II<-(apply(Biomass,c(1,3),sum)*Ierr[,1:nyears])^betas     # apply hyperstability / hyperdepletion
  II<-II/apply(II,1,mean)                                   # normalize

  print("Calculating MSY reference points")                 # Print a progress update
  flush.console()                                           # update the console

  if(sfIsRunning()){
    sfExport(list=c("Marray","hs","Mat_age","Wt_age","R0","V","nyears","maxage")) # export some newly made arrays to the cluster
    MSYrefs<-sfSapply(1:nsim,getFMSY,Marray,hs,Mat_age,Wt_age,R0,V,maxage,nyears,proyears=200,Spat_targ,mov,SRrel,aR,bR) # optimize for MSY reference points
  }else{
    MSYrefs<-sapply(1:nsim,getFMSY,Marray,hs,Mat_age,Wt_age,R0,V,maxage,nyears,proyears=200,Spat_targ,mov,SRrel,aR,bR) # optimize for MSY reference points
  }

  MSY<-MSYrefs[1,]  # record the MSY results
  FMSY<-MSYrefs[2,] # instantaneous FMSY
  BMSY<-(MSY/(1-exp(-FMSY))) # Biomass at MSY
  BMSY_B0<-MSYrefs[3,] # BMSY relative to unfished
  
  print("Calculating reference yield - best fixed F strategy") # Print a progress update
  flush.console()                                              # update the console
  
  if(sfIsRunning()){ # Numerically optimize for F that provides highest long term yield
    RefY<-sfSapply(1:nsim,getFref,Marray=Marray,Wt_age=Wt_age,Mat_age=Mat_age,Perr=Perr,N_s=N[,,nyears,],SSN_s=SSN[,,nyears,],
                            Biomass_s=Biomass[,,nyears,],VBiomass_s=VBiomass[,,nyears,],SSB_s=SSB[,,nyears,],
                            Vn=V,hs=hs,R0a=R0a,nyears=nyears,proyears=proyears,nareas=nareas,maxage=maxage,mov=mov,SSBpR=SSBpR,
                            aR=aR,bR=bR,SRrel=SRrel)
  }else{
    RefY<-sapply(1:nsim,getFref,Marray=Marray,Wt_age=Wt_age,Mat_age=Mat_age,Perr=Perr,N_s=N[,,nyears,],SSN_s=SSN[,,nyears,],
                          Biomass_s=Biomass[,,nyears,],VBiomass_s=VBiomass[,,nyears,],SSB_s=SSB[,,nyears,],
                          Vn=V,hs=hs,R0a=R0a,nyears=nyears,proyears=proyears,nareas=nareas,maxage=maxage,mov=mov,SSBpR=SSBpR,
                          aR=aR,bR=bR,SRrel=SRrel) 
  }
  
  Depletion<-(apply(Biomass[,,nyears,],1,sum)/apply(Biomass[,,1,],1,sum))#^betas   # apply hyperstability / hyperdepletion
  FMSY_M<-FMSY/M                      # ratio of true FMSY to natural mortality rate M
  LFS<-Linf*(1-exp(-K*(mod-t0)))      # Length at full selection
  A<-apply(VBiomass[,,nyears,],1,sum) # Abundance
  OFLreal<-A*FMSY                     # the true simulated Over Fishing Limit

  Dbias<-rlnorm(nsim,mconv(1,OM@Dbiascv),sdconv(1,OM@Dbiascv)) # sample of depletion bias
  Mbias<-rlnorm(nsim,mconv(1,OM@Mcv),sdconv(1,OM@Mcv))         # sample of M bias
  FMSY_Mbias<-rlnorm(nsim,mconv(1,OM@FMSY_Mcv),sdconv(1,OM@FMSY_Mcv)) # sample of FMSY/M bias
  ntest<-20                               # number of trials
  BMSY_B0bias<-array(rlnorm(nsim*ntest,mconv(1,OM@BMSY_B0cv),sdconv(1,OM@BMSY_B0cv)),dim=c(nsim,ntest)) # trial samples of BMSY relative to unfished
  test<-array(BMSY_B0*BMSY_B0bias,dim=c(nsim,ntest)) # the simulated observed BMSY_B0 
  indy<-array(rep(1:ntest,each=nsim),c(nsim,ntest))  # index
  indy[test>0.9]<-NA                                 # interval censor
  BMSY_B0bias<-BMSY_B0bias[cbind(1:nsim,apply(indy,1,min,na.rm=T))] # sample such that BMSY_B0<90%
  AMbias<-rlnorm(nsim,mconv(1,OM@ageMcv),sdconv(1,OM@ageMcv))       # sample of age at maturity bias
  LFCbias<-rlnorm(nsim,mconv(1,OM@LFCcv),sdconv(1,OM@LFCcv))        # sample of length at first capture bias
  LFSbias<-rlnorm(nsim,mconv(1,OM@LFScv),sdconv(1,OM@LFScv))        # sample of length at full selection bias
  Abias<-exp(runif(nsim,log(OM@Btbias[1]),log(OM@Btbias[2])))#rlnorm(nsim,mconv(1,OM@Btbiascv),sdconv(1,OM@Btbiascv))    # smaple of current abundance bias
  Kbias<-rlnorm(nsim,mconv(1,OM@Kcv),sdconv(1,OM@Kcv))              # sample of von B. K parameter bias
  t0bias<-rlnorm(nsim,mconv(1,OM@t0cv),sdconv(1,OM@t0cv))           # sample of von B. t0 parameter bias
  Linfbias<-rlnorm(nsim,mconv(1,OM@Linfcv),sdconv(1,OM@Linfcv))     # sample of von B. maximum length bias
  
  Irefbias<-rlnorm(nsim,mconv(1,OM@Irefcv),sdconv(1,OM@Irefcv))     # sample of bias in reference (target) abundance index
  Crefbias<-rlnorm(nsim,mconv(1,OM@Crefcv),sdconv(1,OM@Crefcv))     # sample of bias in reference (target) catch index
  Brefbias<-rlnorm(nsim,mconv(1,OM@Brefcv),sdconv(1,OM@Brefcv))     # sample of bias in reference (target) biomass index
 
  Recsd<-runif(nsim,OM@Reccv[1],OM@Reccv[2])                        # Recruitment deviation 
  Recerr<-array(rlnorm((nyears+proyears)*nsim,mconv(1,rep(Recsd,(nyears+proyears))),sdconv(1,rep(Recsd,nyears+proyears))),c(nsim,nyears+proyears))
  
  I3<-apply(Biomass,c(1,3),sum)^betas     # apply hyperstability / hyperdepletion
  I3<-I3/apply(I3,1,mean)                 # normalize index to mean 1
  Iref<-I3[,1]*BMSY_B0                    # return the real target abundance index corresponding to BMSY
  
  
  hsim<-rep(NA,nsim)                      # simulate values in steepness 
  hsim[hs>0.6]<-0.2+rbeta(sum(hs>0.6),alphaconv((hs-0.2)/0.8,(1-(hs-0.2)/0.8)*OM@hcv),betaconv((hs-0.2)/0.8,(1-(hs-0.2)/0.8)*OM@hcv))*0.8
  hsim[hs<0.6]<-0.2+rbeta(sum(hs<0.6),alphaconv((hs-0.2)/0.8,(hs-0.2)/0.8*OM@hcv),betaconv((hs-0.2)/0.8,(hs-0.2)/0.8*OM@hcv))*0.8
  hbias<-hsim/hs                          # back calculate the simulated bias

  DLM<-new('DLM',stock="MSE")             # create a blank DLM data object
  if(reps==1)DLM<-OneRep(DLM)             # make stochastic variables certain for only one rep
  DLM<-replic8(DLM,nsim)                  # make nsim sized slots in the DLM data object
  DLM@Name<-OM@Name
  DLM@Year<-1:nyears
  DLM@Cat<-Cobs
  DLM@Ind<-II
  DLM@Rec<-apply(N[,1,,],c(1,2),sum)*Recerr[,1:nyears]
  DLM@t<-rep(nyears,nsim)
  DLM@AvC<-apply(Cobs,1,mean)
  DLM@Dt<-Dbias*Depletion^betas
  DLM@Mort<-M*Mbias
  DLM@FMSY_M<-FMSY_M*FMSY_Mbias
  DLM@BMSY_B0<-BMSY_B0*BMSY_B0bias
  DLM@Cref<-MSY*Crefbias
  DLM@Bref<-BMSY*Brefbias
  DLM@Iref<-Iref*Irefbias
  DLM@AM<-ageM*AMbias
  DLM@LFC<-LFC*LFCbias
  DLM@LFS<-LFS*LFSbias
  DLM@CAA<-CAA
  DLM@Dep<-Dbias*Depletion^betas
  DLM@Abun<-A*Abias
  DLM@vbK<-K*Kbias
  DLM@vbt0<-t0*t0bias
  DLM@vbLinf<-Linf*Linfbias
  DLM@steep<-hs*hbias
  DLM@CAL_bins<-CAL_bins
  DLM@CAL<-CAL
  DLM@MaxAge<-maxage
  DLM@Units<-"unitless"
  DLM@Ref<-OFLreal
  DLM@Ref_type<-'Simulated OFL'
  DLM@wla<-rep(OM@a,nsim)
  DLM@wlb<-rep(OM@b,nsim)
  DLM@OM<-as.data.frame(cbind(RefY,M,Depletion,A,BMSY_B0,FMSY_M,Mgrad,Msd,procsd,Esd,dFfinal,MSY,
                FMSY,Linf,K,t0,hs,Linfgrad,Kgrad,Linfsd,recgrad,Ksd,ageM,
                LFS,age05,Vmaxage,LFC,OFLreal,betas,Spat_targ,Frac_area_1,Prob_staying,AC)) # put all the operating model parameters in one table

  DLM@Obs<-as.data.frame(cbind(Cbias,Csd,nsamp,CALsd,Isd,Dbias,Mbias,FMSY_Mbias,BMSY_B0bias,
                 AMbias,LFCbias,LFSbias,Abias,Kbias,t0bias,Linfbias,hbias,Irefbias,Crefbias,Brefbias))  # put all the observation error model parameters in one table
  
  #assign("DLM",DLM,envir=.GlobalEnv) # for debugging fun
 
  # Run projections ===========================================================================
  print("Determining available methods")  # print an progress report
  flush.console()                         # update the console

  PosMeths<-Can(DLM)                      # list all the methods that could be applied to a DLM data object
  if(is.na(Meths[1]))Meths<-PosMeths      # if the user does not supply an argument Meths run the MSE or all available methods
  if(!is.na(Meths[1]))Meths<-Meths[Meths%in%PosMeths] # otherwise run the MSE for all methods that are deemed possible
  if(length(Meths)==0)stop('MSE stopped: no viable methods \n\n') # if none of the user specied methods are possible stop the run

  nmeth<-length(Meths)                    # the total number of methods used

  MSElist<-list(DLM)[rep(1,nmeth)]        # create a data object for each method (they have identical historical data and branch in projected years)

  B_BMSYa<-array(NA,dim=c(nsim,nmeth,proyears))  # store the projected B_BMSY
  F_FMSYa<-array(NA,dim=c(nsim,nmeth,proyears))  # store the projected F_FMSY
  Ba<-array(NA,dim=c(nsim,nmeth,proyears))       # store the projected Biomass
  FMa<-array(NA,dim=c(nsim,nmeth,proyears))      # store the projected fishing mortality rate
  Ca<-array(NA,dim=c(nsim,nmeth,proyears))       # store the projected catch
  OFLa<-array(NA,dim=c(nsim,nmeth,proyears))     # store the projected quota recommendation

  for(mm in 1:nmeth){    # MSE Loop over methods

    print(paste(mm,"/",nmeth," Running MSE for ",Meths[mm],sep=""))  # print a progress report
    flush.console()                                                  # update the console

    # projection arrays
    N_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    Biomass_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    VBiomass_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    SSN_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    SSB_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    FM_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    Z_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))
    CB_P<-array(NA,dim=c(nsim,maxage,proyears,nareas))

    # indexes
    SAYRL<-as.matrix(expand.grid(1:nsim,1:maxage,nyears,1:nareas))   # Final historical year
    SAYRt<-as.matrix(expand.grid(1:nsim,1:maxage,1+nyears,1:nareas)) # Trajectory year
    SAYR<-as.matrix(expand.grid(1:nsim,1:maxage,1,1:nareas))
    SYt<-SAYRt[,c(1,3)]
    SR<-SAYR[,c(1,4)]

    SYA<-as.matrix(expand.grid(1:nsim,1,1:maxage))         # Projection year
    SY<-SYA[,1:2]
    SA<-SYA[,c(1,3)]
    SAY<-SYA[,c(1,3,2)]
    S<-SYA[,1]

    N_P[SAYR]<-N[SAYRL]
    SSN_P[SAYR]<-SSN[SAYRL]
    Biomass_P[SAYR]<-Biomass[SAYRL]
    VBiomass_P[SAYR]<-VBiomass[SAYRL]
    SSB_P[SAYR]<-SSB[SAYRL]

    if(class(match.fun(Meths[mm]))=="DLM quota"){
      Vn<-V
      OFLused<-apply(Sam(MSElist[[mm]],Meths=Meths[mm],perc=pstar,reps=reps)@quota,3,quantile,p=pstar,na.rm=T)
      OFLa[,mm,1]<-OFLused
      fishdist<-(apply(Biomass_P[,,1,],c(1,3),sum)^Spat_targ)/apply(apply(Biomass_P[,,1,],c(1,3),sum)^Spat_targ,1,mean)   # spatial preference according to spatial biomass
    }else if(class(match.fun(Meths[mm]))=="DLM size"){
      temp<-t(sapply(1:nsim,Meths[mm],DLM=MSElist[[mm]]))
      Vn<-V*temp
      temp<-array(temp,dim(CB[,,nyears,]))
      OFLused<-apply(CB[,,nyears,],1,sum)
      fishdist<-(apply(Biomass_P[,,1,],c(1,3),sum)^Spat_targ)/apply(apply(Biomass_P[,,1,],c(1,3),sum)^Spat_targ,1,mean)   # spatial preference according to spatial biomass
    }else if(class(match.fun(Meths[mm]))=="DLM space"){
      Vn<-V
      temp<-t(sapply(1:nsim,Meths[mm],DLM=MSElist[[mm]]))
      fishdist<-temp
      temp<-array(rep(temp,each=maxage),dim(CB[,,nyears,]))
      OFLused<-apply(CB[,,nyears,]*temp,1,sum)
    }

    CB_P[SAYR]<-Biomass_P[SAYR]*(1-exp(-Vn[SA]*fishdist[SR]))      # ignore magnitude of effort or q increase (just get distribution across age and fishdist across space
    temp<-CB_P[,,1,]/apply(CB_P[,,1,],1,sum)   # how catches are going to be distributed
    CB_P[,,1,]<-OFLused*temp           # debug - to test distribution code make quota = quota2, should be identical
    temp<-(CB_P[SAYR]/Biomass_P[SAYR])
    temp[temp>(1-exp(-maxF))]<-1-exp(-maxF)

    FM_P[SAYR]<--log(1-temp)
    Z_P[SAYR]<-FM_P[SAYR]+Marray[SYt]

    upyrs<-1+(0:(floor(proyears/interval)-1))*interval  # the years in which there are updates (every three years)
    cat(".")
    flush.console()
    for(y in 2:proyears){
      cat(".")
      flush.console()
      OFLa[,mm,y]<-OFLused
      SAYRt<-as.matrix(expand.grid(1:nsim,1:maxage,y+nyears,1:nareas)) # Trajectory year
      SAYt<-SAYRt[,1:3]
      SYt<-SAYRt[,c(1,3)]
      SAY1R<-as.matrix(expand.grid(1:nsim,1:maxage,y-1,1:nareas))
      SAYR<-as.matrix(expand.grid(1:nsim,1:maxage,y,1:nareas))
      SY<-SAYR[,c(1,3)]
      SA<-SAYR[,1:2]
      SAY<-SAYR[,1:3]
      S<-SAYR[,1]
      SR<-SAYR[,c(1,4)]
      SA2YR<-as.matrix(expand.grid(1:nsim,2:maxage,y,1:nareas))
      SA1YR<-as.matrix(expand.grid(1:nsim,1:(maxage-1),y-1,1:nareas))
      indMov<-as.matrix(expand.grid(1:nareas,1:nareas,y,1:maxage,1:nsim)[5:1])
      indMov2<-indMov[,c(1,2,3,4)]
      indMov3<-indMov[,c(1,4,5)]


      N_P[SA2YR]<-N_P[SA1YR]*exp(-Z_P[SA1YR])         # Total mortality
      if(SRrel[1]==1){
        N_P[,1,y,]<-Perr[,y+nyears]*(0.8*R0a*hs*apply(SSB_P[,,y-1,],c(1,3),sum))/(0.2*SSBpR*R0a*(1-hs)+(hs-0.2)*apply(SSB_P[,,y-1,],c(1,3),sum))  # Recruitment assuming regional R0 and stock wide steepness
      }else{ # most transparent form of the Ricker uses alpha and beta params
        N_P[,1,y,]<-Perr[,y+nyears]*aR*apply(SSB_P[,,y-1,],c(1,3),sum)*exp(-bR*apply(SSB_P[,,y-1,],c(1,3),sum))
      }
      
      temp<-array(N_P[indMov2]*mov[indMov3],dim=c(nareas,nareas,maxage,nsim))  # Move individuals
      N_P[,,y,]<-apply(temp,c(4,3,1),sum)

      Biomass_P[SAYR]<-N_P[SAYR]*Wt_age[SAYt]                                    # Calculate biomass
      VBiomass_P[SAYR]<-Biomass_P[SAYR]*Vn[SA]                       # Calculate vulnerable biomass
      SSN_P[SAYR]<-N_P[SAYR]*Mat_age[SA]                                       # Calculate spawning stock numbers
      SSB_P[SAYR]<-SSN_P[SAYR]*Wt_age[SAYt]                                      # Calculate spawning stock biomass

      if(y%in%upyrs){  # rewrite the DLM object and run the OFL function

        yind<-upyrs[match(y,upyrs)-1]:(upyrs[match(y,upyrs)]-1)
        CNtemp<-N_P[,,yind,]*exp(Z_P[,,yind,])*(1-exp(-Z_P[,,yind,]))*(FM_P[,,yind,]/Z_P[,,yind,])
        CBtemp<-Biomass_P[,,yind,]*exp(Z_P[,,yind,])*(1-exp(-Z_P[,,yind,]))*(FM_P[,,yind,]/Z_P[,,yind,])
        CNtemp[is.na(CNtemp)]<-1e-20
        CBtemp[is.na(CNtemp)]<-1e-20
        CNtemp<-apply(CNtemp,c(1,3,2),sum)
        CNtemp[CNtemp==0]<-CNtemp[CNtemp==0]+tiny
        Cobs<-Cbiasa[,nyears+yind]*Cerr[,nyears+yind]*apply(CBtemp,c(1,3),sum)
        Cobs[is.na(Cobs)]<-tiny
        Recobs<-Recerr[,nyears+yind]*apply(N_P[,1,yind,],c(1,2),sum)
                
        CAA<-array(NA,dim=c(nsim,interval,maxage))
        for(i in 1:nsim)for(j in 1:interval)CAA[i,j,]<-rmultinom(1,nsamp[i],CNtemp[i,j,])

        nCALbins<-20
        CAL_bins<-seq(0,max(Len_age),length.out=nCALbins)
        CAL_bins<-c(CAL_bins,CAL_bins[nCALbins]*5)
        CAL<-array(NA,dim=c(nsim,interval,nCALbins))
        for(i in 1:nsim){
          for(j in 1:interval){
            yy<-yind[j]
            ages<-rep(1:maxage,CAA[i,j,])+runif(sum(CAA[i,j,]),-0.5,0.5)
            lengths<-Linfarray[i,yy]*(1-exp(-Karray[i,yy]*(ages-t0[i])))*exp(rnorm(sum(CAA[i,j,]),CALmu[i],CALsd[i]))
            CAL[i,j,]<-hist(lengths,CAL_bins,plot=F)$counts
          }
        }

        I2<-apply(Biomass_P,c(1,3),sum)[,1:(y-1)]*Ierr[,(nyears+1):(nyears+(y-1))]^betas
        I2<-cbind(MSElist[[mm]]@Ind[,1:nyears],I2/(I2[,1]/MSElist[[mm]]@Ind[,nyears]))
        I2[is.na(I2)]<-tiny
        I2<-I2/apply(I2,1,mean)
        

        Depletion<-apply(Biomass_P[,,y,],1,sum)/apply(Biomass[,,1,],1,sum)
        A<-apply(VBiomass_P[,,y,],1,sum)
        A[is.na(A)]<-tiny
        OFLreal<-A*FMSY
       
        # assign all the new data
        MSElist[[mm]]@OM$A<-A
        MSElist[[mm]]@Year<-1:(nyears+y-1)
        MSElist[[mm]]@Cat<-cbind(MSElist[[mm]]@Cat,Cobs)
        MSElist[[mm]]@Ind<-I2
        MSElist[[mm]]@Rec<-cbind(MSElist[[mm]]@Rec,Recobs)
        MSElist[[mm]]@t<-rep(nyears+y,nsim)
        MSElist[[mm]]@AvC<-apply(MSElist[[mm]]@Cat,1,mean)
        MSElist[[mm]]@Dt<-Dbias*Depletion^betas
        oldCAA<-MSElist[[mm]]@CAA
        MSElist[[mm]]@CAA<-array(0,dim=c(nsim,nyears+y-1,maxage))
        MSElist[[mm]]@CAA[,1:(nyears+y-interval-1),]<-oldCAA
        MSElist[[mm]]@CAA[,nyears+yind,]<-CAA
        MSElist[[mm]]@Dep<-Dbias*Depletion^betas
        MSElist[[mm]]@Abun<-A*Abias
        MSElist[[mm]]@CAL_bins<-CAL_bins
        oldCAL<-MSElist[[mm]]@CAL
        MSElist[[mm]]@CAL<-array(0,dim=c(nsim,nyears+y-1,nCALbins))
        MSElist[[mm]]@CAL[,1:(nyears+y-interval-1),]<-oldCAL
        MSElist[[mm]]@CAL[,nyears+yind,]<-CAL
        MSElist[[mm]]@Ref<-OFLreal
        MSElist[[mm]]@Ref_type<-'Simulated OFL'
        
        #assign("DLM",MSElist[[mm]],envir=.GlobalEnv) # for debugging fun
        
        if(class(match.fun(Meths[mm]))=="DLM quota"){
          OFLused<-apply(Sam(MSElist[[mm]],Meths=Meths[mm],perc=pstar,reps=reps)@quota,3,quantile,p=pstar,na.rm=T)
          MSElist[[mm]]@MPrec<-OFLused
        }
        
      }

      if(class(match.fun(Meths[mm]))=="DLM quota"){
         fishdist<-(apply(Biomass_P[,,y-1,],c(1,3),sum)^Spat_targ)/apply(apply(Biomass_P[,,y-1,],c(1,3),sum)^Spat_targ,1,mean)   # spatial preference according to spatial biomass
      }else if(class(match.fun(Meths[mm]))=="DLM size"){
         fishdist<-(apply(Biomass_P[,,y-1,],c(1,3),sum)^Spat_targ)/apply(apply(Biomass_P[,,y-1,],c(1,3),sum)^Spat_targ,1,mean)   # spatial preference according to spatial biomass
      }

      CB_P[SAYR]<-Biomass_P[SAYR]*(1-exp(-fishdist[SR]*Vn[SA]))      # ignore magnitude of effort or q increase (just get distribution across age and fishdist across space
      temp<-CB_P[,,y,]/apply(CB_P[,,y,],1,sum)   # how catches are going to be distributed
      CB_P[,,y,]<-OFLused*temp           # debug - to test distribution code make quota = quota2, should be identical
      temp<-(CB_P[SAYR]/Biomass_P[SAYR])
      temp[temp>(1-exp(-maxF))]<-1-exp(-maxF)
      FM_P[SAYR]<--log(1-temp)
      CB_P[SAYR]<-Biomass_P[SAYR]*(1-exp(-FM_P[SAYR]))
      Z_P[SAYR]<-FM_P[SAYR]+Marray[SYt]

    } # end of year

    B_BMSYa[,mm,]<-apply(Biomass_P,c(1,3),sum)/BMSY
    F_FMSYa[,mm,]<-(-log(1-apply(CB_P,c(1,3),sum)/(apply(CB_P,c(1,3),sum)+apply(VBiomass_P,c(1,3),sum))))/FMSY
    Ba[,mm,]<-apply(Biomass_P,c(1,3),sum)
    FMa[,mm,]<--log(1-apply(CB_P,c(1,3),sum)/(apply(CB_P,c(1,3),sum)+apply(VBiomass_P,c(1,3),sum)))
    Ca[,mm,]<-apply(CB_P,c(1,3),sum)
    cat("\n")
  }    # end of mm methods
  
  new('MSE',Name=OM@Name,nyears,proyears,nmeth,Meths,nsim,OMtable=DLM@OM,DLM@Obs,B_BMSYa,F_FMSYa,Ba,FMa,Ca,OFLa,SSB_hist=SSB,CB_hist=CB,FM_hist=FM)

}


Tplot<-function(MSEobj){
  FMSYr<-quantile(MSEobj@F_FMSY,c(0.001,0.90),na.rm=T)
  BMSYr<-quantile(MSEobj@B_BMSY,c(0.001,0.975),na.rm=T)

  colsse<-rainbow(100,start=0,end=0.36)[1:100]
  colB<-rep(colsse[100],ceiling(BMSYr[2]*100))
  colB[1:100]<-colsse
  colB<-makeTransparent(colB,60)
  colsse<-rainbow(200,start=0,end=0.36)[200:1]
  colF<-rep(colsse[200],ceiling(FMSYr[2]*100))
  colF[1:200]<-colsse
  colF<-makeTransparent(colF,60)

  Yd<-rep(NA,MSEobj@nmeths)
  P10<-rep(NA,MSEobj@nmeths)
  P50<-rep(NA,MSEobj@nmeths)
  P100<-rep(NA,MSEobj@nmeths)
  POF<-rep(NA,MSEobj@nmeths)
  yind<-max(MSEobj@proyears-4,1):MSEobj@proyears
  RefYd<-MSEobj@OM$RefY

  for(mm in 1:MSEobj@nmeths){
    Yd[mm]<-round(mean(apply(MSEobj@C[,mm,yind],1,mean,na.rm=T)/RefYd,na.rm=T)*100,1)
  #cbind(MSEobj@C[,mm,yind],unlist(MSEobj@OM$MSY))
    POF[mm]<-round(sum(MSEobj@F_FMSY[,mm,]>1,na.rm=T)/prod(dim(MSEobj@F_FMSY[,mm,]),na.rm=T)*100,1)
    P10[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<0.1,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
    P50[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<0.5,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
    P100[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<1,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
  }
  
  #dev.new2(width=7,height=7)
  par(mfrow=c(2,2),mai=c(0.85,0.7,0.1,0.1),omi=rep(0.01,4))

  tradeoffplot(POF,Yd,"Prob. of overfishing (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
  tradeoffplot(P100,Yd,"Prob. biomass < BMSY (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
  tradeoffplot(P50,Yd,"Prob. biomass < 0.5BMSY (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
  tradeoffplot(P10,Yd,"Prob. biomass < 0.1BMSY (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
}

Pplot<-function(MSEobj){
  
  FMSYr<-quantile(MSEobj@F_FMSY,c(0.001,0.90),na.rm=T)
  BMSYr<-quantile(MSEobj@B_BMSY,c(0.001,0.975),na.rm=T)
  
  colsse<-rainbow(100,start=0,end=0.36)[1:100]
  colB<-rep(colsse[100],ceiling(BMSYr[2]*100))
  colB[1:100]<-colsse
  colB<-makeTransparent(colB,60)
  colsse<-rainbow(200,start=0,end=0.36)[200:1]
  colF<-rep(colsse[200],ceiling(FMSYr[2]*100))
  colF[1:200]<-colsse
  colF<-makeTransparent(colF,60)
  
  Yd<-rep(NA,MSEobj@nmeths)
  P10<-rep(NA,MSEobj@nmeths)
  P50<-rep(NA,MSEobj@nmeths)
  P100<-rep(NA,MSEobj@nmeths)
  POF<-rep(NA,MSEobj@nmeths)
  yind<-max(MSEobj@proyears-4,1):MSEobj@proyears
  RefYd<-MSEobj@OM$RefY
  
  for(mm in 1:MSEobj@nmeths){
    Yd[mm]<-round(mean(apply(MSEobj@C[,mm,yind],1,mean,na.rm=T)/RefYd,na.rm=T)*100,1)
    #cbind(MSEobj@C[,mm,yind],unlist(MSEobj@OM$MSY))
    POF[mm]<-round(sum(MSEobj@F_FMSY[,mm,]>1,na.rm=T)/prod(dim(MSEobj@F_FMSY[,mm,]),na.rm=T)*100,1)
    P10[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<0.1,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
    P50[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<0.5,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
    P100[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<1,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
  }
    
  nr<-ceiling(MSEobj@nmeths/8)
  nc<-ceiling(MSEobj@nmeths/nr)
  nr<-nr*2
  MSEcols<-c('red','green','blue','orange','brown','purple','dark grey','violet','dark red','pink','dark blue','grey')

  #dev.new2(width=nc*3,height=nr*3)
  par(mfcol=c(nr,nc),mai=c(0.2,0.25,0.3,0.01),omi=c(0.4,0.3,0.05,0.05))
  lwdy<-2.5

  for(mm in 1:MSEobj@nmeths){
    plot(MSEobj@F_FMSY[1,mm,],ylim=FMSYr,col=colF[ceiling(mean(MSEobj@F_FMSY[1,mm,],na.rm=T)*100)],type='l',lwd=lwdy)
    for(i in 1:MSEobj@nsim)lines(MSEobj@F_FMSY[i,mm,],col=colF[ceiling(mean(MSEobj@F_FMSY[i,mm,],na.rm=T)*100)],lwd=lwdy)
    abline(h=100,col="grey",lwd=3)
    mtext(MSEobj@meths[mm],3,outer=F,line=0.6)
    legend('top',c(paste(POF[mm],"% POF",sep=""),
                 paste(Yd[mm],"% FMSY yield",sep="")),bty='n',cex=0.9)
    if(mm%in%(1:(nr/2)))mtext("F/FMSY",2,line=2.5,outer=F)
    abline(h=1,col=makeTransparent("grey",30),lwd=2.5)
  
    plot(MSEobj@B_BMSY[1,mm,],ylim=BMSYr,col=colB[ceiling(MSEobj@B_BMSY[1,mm,MSEobj@proyears]*100)],type='l',lwd=lwdy)
    for(i in 1:MSEobj@nsim)lines(MSEobj@B_BMSY[i,mm,],col=colB[ceiling(MSEobj@B_BMSY[i,mm,MSEobj@proyears]*100)],lwd=lwdy)
    abline(h=100,col="grey",lwd=3)
    legend('top',c(paste(P100[mm],"% < BMSY",sep=""),
                 paste(P50[mm],"% < 0.5BMSY",sep=""),
                 paste(P10[mm],"% < 0.1BMSY",sep="")),bty='n',cex=0.9)
    if(mm%in%(1:(nr/2)))mtext("B/BMSY",2,line=2.5,outer=F)
    abline(h=1,col=makeTransparent("grey",30),lwd=2.5)
  
  }
  mtext("Projection year",1,outer=T,line=1.2)
}

Kplot<-function(MSEobj){
  nr<-floor((MSEobj@nmeths)^0.5)
  nc<-ceiling((MSEobj@nmeths)/nr)
    
  FMSYr<-quantile(MSEobj@F_FMSY,c(0.001,0.90),na.rm=T)
  BMSYr<-quantile(MSEobj@B_BMSY,c(0.001,0.975),na.rm=T)
    
  #dev.new2(width=nc*3,height=nr*3.6)
  par(mfrow=c(nr,nc),mai=c(0.2,0.3,0.4,0.01),omi=c(0.45,0.3,0.01,0.01))
  
  colsse<-rainbow(MSEobj@proyears,start=0.57,end=0.7)[1:MSEobj@proyears]
  colsse<-makeTransparent(colsse,90)
  
  for(mm in 1:MSEobj@nmeths){
    plot(c(MSEobj@B_BMSY[1,mm,1],MSEobj@B_BMSY[1,mm,2]),
         c(MSEobj@F_FMSY[1,mm,1],MSEobj@F_FMSY[1,mm,2]),xlim=BMSYr,ylim=FMSYr,
         col=colsse[1],type='l')
    
    OO<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]<1&MSEobj@F_FMSY[,mm,MSEobj@proyears]>1,na.rm=T)/MSEobj@nsim*100,1)
    OU<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]>1&MSEobj@F_FMSY[,mm,MSEobj@proyears]>1,na.rm=T)/MSEobj@nsim*100,1)
    UO<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]<1&MSEobj@F_FMSY[,mm,MSEobj@proyears]<1,na.rm=T)/MSEobj@nsim*100,1)
    UU<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]>1&MSEobj@F_FMSY[,mm,MSEobj@proyears]<1,na.rm=T)/MSEobj@nsim*100,1)
    
    alp<-80
    polygon(c(1,-1000,-1000,1),c(1,1,1000,1000),col=makeTransparent("orange",alp),border=makeTransparent("orange",alp))
    polygon(c(1,1000,1000,1),c(1,1,1000,1000),col=makeTransparent("yellow",alp),border=makeTransparent("yellow",alp))
    polygon(c(1,-1000,-1000,1),c(1,1,-1000,-1000),col=makeTransparent("yellow",alp),border=makeTransparent("yellow",alp))
    polygon(c(1,1000,1000,1),c(1,1,-1000,-1000),col=makeTransparent("green",alp),border=makeTransparent("yellow",alp))
    
    
    abline(h=1,col="grey",lwd=3)
    abline(v=1,col="grey",lwd=3)
    #abline(v=c(0.1,0.5),col="grey",lwd=2)
    
    for(i in 1:MSEobj@nsim){
      for(y in 1:(MSEobj@proyears-1)){
        lines(c(MSEobj@B_BMSY[i,mm,y],MSEobj@B_BMSY[i,mm,y+1]),
              c(MSEobj@F_FMSY[i,mm,y],MSEobj@F_FMSY[i,mm,y+1]),
              col=colsse[y],lwd=1.5)
      }
    }
    
    points(MSEobj@B_BMSY[,mm,1],MSEobj@F_FMSY[,mm,1],pch=19,cex=0.8,col=colsse[1])
    points(MSEobj@B_BMSY[,mm,MSEobj@proyears],MSEobj@F_FMSY[,mm,MSEobj@proyears],pch=19,cex=0.8,col=colsse[MSEobj@proyears])
    
    if(mm==1)legend('right',c("Start","End"),bty='n',text.col=c(colsse[1],colsse[MSEobj@proyears]),pch=19,col=c(colsse[1],colsse[MSEobj@proyears]))
    legend('topleft',paste(OO,"%",sep=""),bty='n',text.font=2)
    legend('topright',paste(OU,"%",sep=""),bty='n',text.font=2)
    legend('bottomleft',paste(UO,"%",sep=""),bty='n',text.font=2)
    legend('bottomright',paste(UU,"%",sep=""),bty='n',text.font=2)
    
    mtext(MSEobj@meths[mm],3,line=0.45)
  }
  mtext("B/BMSY",1,outer=T,line=1.4)
  mtext("F/FMSY",2,outer=T,line=0.2)
  
}

# Plotting code for MSE object
setMethod("plot",
  signature(x = "MSE"),
  function(x){
  options(warn=-1)
  MSEobj<-x
  # Plot the trajectories of F/FMSY and B/BMSY    ============================================
  FMSYr<-quantile(MSEobj@F_FMSY,c(0.001,0.90),na.rm=T)
  BMSYr<-quantile(MSEobj@B_BMSY,c(0.001,0.975),na.rm=T)

  colsse<-rainbow(100,start=0,end=0.36)[1:100]
  colB<-rep(colsse[100],ceiling(BMSYr[2]*100))
  colB[1:100]<-colsse
  colB<-makeTransparent(colB,60)
  colsse<-rainbow(200,start=0,end=0.36)[200:1]
  colF<-rep(colsse[200],ceiling(FMSYr[2]*100))
  colF[1:200]<-colsse
  colF<-makeTransparent(colF,60)

  Yd<-rep(NA,MSEobj@nmeths)
  P10<-rep(NA,MSEobj@nmeths)
  P50<-rep(NA,MSEobj@nmeths)
  P100<-rep(NA,MSEobj@nmeths)
  POF<-rep(NA,MSEobj@nmeths)
  yind<-max(MSEobj@proyears-4,1):MSEobj@proyears
  RefYd<-MSEobj@OM$RefY

  for(mm in 1:MSEobj@nmeths){
    Yd[mm]<-round(mean(apply(MSEobj@C[,mm,yind],1,mean,na.rm=T)/RefYd,na.rm=T)*100,1)
    #cbind(MSEobj@C[,mm,yind],unlist(MSEobj@OM$MSY))
    POF[mm]<-round(sum(MSEobj@F_FMSY[,mm,]>1,na.rm=T)/prod(dim(MSEobj@F_FMSY[,mm,]),na.rm=T)*100,1)
    P10[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<0.1,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
    P50[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<0.5,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
    P100[mm]<-round(sum(MSEobj@B_BMSY[,mm,]<1,na.rm=T)/prod(dim(MSEobj@B_BMSY[,mm,]))*100,1)
  }
    
  nr<-ceiling(MSEobj@nmeths/8)
  nc<-ceiling(MSEobj@nmeths/nr)
  nr<-nr*2
  MSEcols<-c('red','green','blue','orange','brown','purple','dark grey','violet','dark red','pink','dark blue','grey')
  
  #dev.new2(width=nc*3,height=nr*3)
  par(mfcol=c(nr,nc),mai=c(0.2,0.25,0.3,0.01),omi=c(0.4,0.3,0.05,0.05))
  lwdy<-2.5
  
  for(mm in 1:MSEobj@nmeths){
    plot(MSEobj@F_FMSY[1,mm,],ylim=FMSYr,col=colF[ceiling(mean(MSEobj@F_FMSY[1,mm,],na.rm=T)*100)],type='l',lwd=lwdy)
    for(i in 1:MSEobj@nsim)lines(MSEobj@F_FMSY[i,mm,],col=colF[ceiling(mean(MSEobj@F_FMSY[i,mm,],na.rm=T)*100)],lwd=lwdy)
    abline(h=100,col="grey",lwd=3)
    mtext(MSEobj@meths[mm],3,outer=F,line=0.6)
    legend('top',c(paste(POF[mm],"% POF",sep=""),
                        paste(Yd[mm],"% FMSY yield",sep="")),bty='n',cex=0.9)
    if(mm%in%(1:(nr/2)))mtext("F/FMSY",2,line=2.5,outer=F)
    abline(h=1,col=makeTransparent("grey",30),lwd=2.5)
    
    plot(MSEobj@B_BMSY[1,mm,],ylim=BMSYr,col=colB[ceiling(MSEobj@B_BMSY[1,mm,MSEobj@proyears]*100)],type='l',lwd=lwdy)
    for(i in 1:MSEobj@nsim)lines(MSEobj@B_BMSY[i,mm,],col=colB[ceiling(MSEobj@B_BMSY[i,mm,MSEobj@proyears]*100)],lwd=lwdy)
    abline(h=100,col="grey",lwd=3)
    legend('top',c(paste(P100[mm],"% < BMSY",sep=""),
                        paste(P50[mm],"% < 0.5BMSY",sep=""),
                        paste(P10[mm],"% < 0.1BMSY",sep="")),bty='n',cex=0.9)
    if(mm%in%(1:(nr/2)))mtext("B/BMSY",2,line=2.5,outer=F)
    abline(h=1,col=makeTransparent("grey",30),lwd=2.5)
    
  }
  mtext("Projection year",1,outer=T,line=1.2)
 
  # KOBE plots ==============================================================================
  
  nr<-floor((MSEobj@nmeths)^0.5)
  nc<-ceiling((MSEobj@nmeths)/nr)
  
  #dev.new2(width=nc*3,height=nr*3.6)
  par(mfrow=c(nr,nc),mai=c(0.2,0.3,0.4,0.01),omi=c(0.45,0.3,0.01,0.01))

  colsse<-rainbow(MSEobj@proyears,start=0.57,end=0.7)[1:MSEobj@proyears]
  colsse<-makeTransparent(colsse,90)
 
  for(mm in 1:MSEobj@nmeths){
    plot(c(MSEobj@B_BMSY[1,mm,1],MSEobj@B_BMSY[1,mm,2]),
           c(MSEobj@F_FMSY[1,mm,1],MSEobj@F_FMSY[1,mm,2]),xlim=BMSYr,ylim=FMSYr,
           col=colsse[1],type='l')

    OO<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]<1&MSEobj@F_FMSY[,mm,MSEobj@proyears]>1,na.rm=T)/MSEobj@nsim*100,1)
    OU<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]>1&MSEobj@F_FMSY[,mm,MSEobj@proyears]>1,na.rm=T)/MSEobj@nsim*100,1)
    UO<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]<1&MSEobj@F_FMSY[,mm,MSEobj@proyears]<1,na.rm=T)/MSEobj@nsim*100,1)
    UU<-round(sum(MSEobj@B_BMSY[,mm,MSEobj@proyears]>1&MSEobj@F_FMSY[,mm,MSEobj@proyears]<1,na.rm=T)/MSEobj@nsim*100,1)

    alp<-80
    polygon(c(1,-1000,-1000,1),c(1,1,1000,1000),col=makeTransparent("orange",alp),border=makeTransparent("orange",alp))
    polygon(c(1,1000,1000,1),c(1,1,1000,1000),col=makeTransparent("yellow",alp),border=makeTransparent("yellow",alp))
    polygon(c(1,-1000,-1000,1),c(1,1,-1000,-1000),col=makeTransparent("yellow",alp),border=makeTransparent("yellow",alp))
    polygon(c(1,1000,1000,1),c(1,1,-1000,-1000),col=makeTransparent("green",alp),border=makeTransparent("yellow",alp))


    abline(h=1,col="grey",lwd=3)
    abline(v=1,col="grey",lwd=3)
    #abline(v=c(0.1,0.5),col="grey",lwd=2)

    for(i in 1:MSEobj@nsim){
      for(y in 1:(MSEobj@proyears-1)){
        lines(c(MSEobj@B_BMSY[i,mm,y],MSEobj@B_BMSY[i,mm,y+1]),
              c(MSEobj@F_FMSY[i,mm,y],MSEobj@F_FMSY[i,mm,y+1]),
              col=colsse[y],lwd=1.5)
      }
    }

    points(MSEobj@B_BMSY[,mm,1],MSEobj@F_FMSY[,mm,1],pch=19,cex=0.8,col=colsse[1])
    points(MSEobj@B_BMSY[,mm,MSEobj@proyears],MSEobj@F_FMSY[,mm,MSEobj@proyears],pch=19,cex=0.8,col=colsse[MSEobj@proyears])

    if(mm==1)legend('right',c("Start","End"),bty='n',text.col=c(colsse[1],colsse[MSEobj@proyears]),pch=19,col=c(colsse[1],colsse[MSEobj@proyears]))
    legend('topleft',paste(OO,"%",sep=""),bty='n',text.font=2)
    legend('topright',paste(OU,"%",sep=""),bty='n',text.font=2)
    legend('bottomleft',paste(UO,"%",sep=""),bty='n',text.font=2)
    legend('bottomright',paste(UU,"%",sep=""),bty='n',text.font=2)

    mtext(MSEobj@meths[mm],3,line=0.45)
  }
  mtext("B/BMSY",1,outer=T,line=1.4)
  mtext("F/FMSY",2,outer=T,line=0.2)

  # Trade-off plots ==========================================================================

  #dev.new2(width=7,height=7)
  par(mfrow=c(2,2),mai=c(0.85,0.7,0.1,0.1),omi=rep(0.01,4))

  tradeoffplot(POF,Yd,"Prob. of overfishing (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
  tradeoffplot(P100,Yd,"Prob. biomass < BMSY (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
  tradeoffplot(P50,Yd,"Prob. biomass < 0.5BMSY (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)
  tradeoffplot(P10,Yd,"Prob. biomass < 0.1BMSY (%)", "Relative yield",MSEobj@meths[1:MSEobj@nmeths],vl=50,hl=100)


  # Value of information  ====================================================================

  Meths<-MSEobj@meths
  nm<-length(Meths)
  nq<-6

  nc<-ncol(MSEobj@OM)+ncol(MSEobj@Obs)
  Qname<-c(names(MSEobj@OM),names(MSEobj@Obs))
  Qmat<-cbind(MSEobj@OM,MSEobj@Obs)

  ncols<-40
  #colsse<-makeTransparent(rainbow(ncols,start=0,end=0.36),95)[ncols:1]
  colsse<-rainbow(ncols,start=0,end=0.36)[ncols:1]

  for(m in 1:nm){
    Yd<-apply(MSEobj@C[,m,yind],1,mean)/RefYd*100
    POF<-apply(MSEobj@F_FMSY[,m,]>1,1,sum)/(dim(MSEobj@F_FMSY[,m,])[2])*100
    Yd[Yd>300]<-NA

    #dev.new2(height=7.5,width=nq*2.5)
    par(mfrow=c(2,nq),mai=c(0.6,0.25,0.05,0.05),omi=c(0.01,0.5,0.4,0.01))

    Qcor<-cor(cbind(Yd,MSEobj@OM,MSEobj@Obs),use="complete.obs")
    mq<-order(abs(Qcor[1,2:nc]),decreasing=T)[1:nq]

    for(q in 1:nq){
      coly=colsse[ceiling(abs(Qcor[1,1+mq[q]])^0.6*ncols)]
      plot(Qmat[,mq[q]],Yd,xlim=quantile(Qmat[,mq[q]],p=c(0.02,0.97),na.rm=T),ylim=quantile(Yd,p=c(0.02,0.97),na.rm=T),col=coly,pch=19,xlab="",ylab="",cex=1.2)
      xx<-Qmat[order(Qmat[,mq[q]]),mq[q]]
      yy<-log(Yd[order(Qmat[,mq[q]])]+1e-15)
      pred<-predict(loess(yy~xx),se=T)
      lines(xx[!is.na(yy)],exp(pred$fit),col=coly,lwd=2)
      lines(xx[!is.na(yy)],exp(pred$fit+pred$se.fit*qnorm(0.975)),col=coly,lwd=1)
      lines(xx[!is.na(yy)],exp(pred$fit-pred$se.fit*qnorm(0.975)),col=coly,lwd=1)

      points(Qmat[,mq[q]],Yd,cex=1.2)
      abline(h=100,col="#50505040")
      mtext(Qname[mq[q]],1,line=2.5,outer=F)
      if(q==1)mtext("Yield (%relative to FMSY)",2,line=2.5,outer=F)

    }

    Qcor<-cor(cbind(POF,MSEobj@OM,MSEobj@Obs),use="complete.obs")
    mq<-order(abs(Qcor[1,2:nc]),decreasing=T)[1:nq]

    for(q in 1:nq){
      coly=colsse[ceiling(abs(Qcor[1,1+mq[q]])^0.6*ncols)]
      plot(Qmat[,mq[q]],POF,xlim=quantile(Qmat[,mq[q]],p=c(0.02,0.98),na.rm=T),ylim=quantile(POF,p=c(0.02,0.98),na.rm=T),col=coly,pch=19,xlab="",ylab="",cex=1.2)
      xx<-Qmat[order(Qmat[,mq[q]]),mq[q]]
      yy<-POF[order(Qmat[,mq[q]])]/100
      yy[yy==1]<-0.9999
      yy[yy==0]<-0.0001
      yy<-log(yy/(1-yy))
      pred<-predict(loess(yy~xx),se=T)
      lines(xx[!is.na(yy)],exp(pred$fit)/(1+exp(pred$fit))*100,col=coly,lwd=2)
      lines(xx[!is.na(yy)],exp(pred$fit+pred$se.fit*qnorm(0.975))/(1+exp(pred$fit+pred$se.fit*qnorm(0.975)))*100,col=coly,lwd=1)
      lines(xx[!is.na(yy)],exp(pred$fit-pred$se.fit*qnorm(0.975))/(1+exp(pred$fit-pred$se.fit*qnorm(0.975)))*100,col=coly,lwd=1)
      points(Qmat[,mq[q]],POF,cex=1.2)
      abline(h=100,col="#50505040")
      mtext(Qname[mq[q]],1,line=2.5,outer=F)
      if(q==1)mtext("Prob. Overfishing(%)",2,line=2.5,outer=F)

    }

    mtext(paste("MSE correlation evaluation for ",MSEobj@Name,": ",Meths[m],sep=""),3,line=0.6,outer=T)
  }
  options(warn=1)
})

tradeoffplot<-function(x,y,xlab,ylab,labs,cex,vl,hl){
   adjj<-c(0.7,1.3)
   coly<-rep(c('#0000ff80','#ff000080','#00ff0080'),10)
   plot(NA,xlim=range(x,na.rm=T)*adjj,ylim=range(y,na.rm=T)*adjj,xlab=xlab,ylab=ylab)
   abline(v=vl,col="grey",lwd=2)
   abline(h=hl,col="grey",lwd=2)
   text(x,y,labs,font=2,col=coly)
}

tradeoffplot2<-function(x,y,xlab,ylab,cex=1,vl,hl,coly,leg){
  adjj<-c(0.7,1.3)
  plot(NA,xlim=range(x,na.rm=T)*adjj,ylim=range(y,na.rm=T)*adjj,xlab=xlab,ylab=ylab)
  abline(v=vl,col="grey",lwd=2)
  abline(h=hl,col="grey",lwd=2)
  for(m in 1:nrow(x))points(x[m,],y[m,],col=makeTransparent(coly[m],50),pch=19,cex=cex)
  if(!is.na(leg[1]))legend('topright',legend=leg,text.col=coly,bty='n')
}

makeTransparent<-function(someColor, alpha=100){
  newColor<-col2rgb(someColor)
  apply(newColor, 2, function(curcoldata){rgb(red=curcoldata[1], green=curcoldata[2],
    blue=curcoldata[3],alpha=alpha, maxColorValue=255)})
}

getmov<-function(x,Prob_staying,Frac_area_1){
  test<-optim(par=c(0,0,0),movfit,method="L-BFGS-B",lower=rep(-6,3),upper=rep(6,3),prb=Prob_staying[x],frac=Frac_area_1[x])
  mov<-array(c(test$par[1],test$par[2],0,test$par[3]),dim=c(2,2))
  mov<-exp(mov)
  mov/array(apply(mov,1,sum),dim=c(2,2))
}

movfit<-function(par,prb,frac){
  mov<-array(c(par[1],par[2],0,par[3]),dim=c(2,2))
  mov<-exp(mov)
  mov<-mov/array(apply(mov,1,sum),dim=c(2,2))
  dis<-c(frac,1-frac)
  for(i in 1:100)dis<-apply(array(dis,c(2,2))*mov,2,sum)
  (log(mov[1,1])-log(prb))^2+(log(frac)-log(dis[1]))^2
}

getq<-function(x,dep,Find,Perr,Marray,hs,Mat_age,Wt_age,R0,V,nyears,maxage,mov,Spat_targ,SRrel,aR,bR){
  opt<-optimize(qopt,log(c(0.001,10)),depc=dep[x],Fc=Find[x,],Perrc=Perr[x,],
                     Mc=Marray[x,],hc=hs[x],Mac=Mat_age[x,],Wac=Wt_age[x,,],
                     R0c=R0,Vc=V[x,],nyears=nyears,maxage=maxage,movc=mov[x,,],
                     Spat_targc=Spat_targ[x],SRrelc=SRrel[x],aRc=aR[x,],bRc=bR[x,])
  return(exp(opt$minimum))
}

qopt<-function(lnq,depc,Fc,Perrc,Mc,hc,Mac,Wac,R0c,Vc,nyears,maxage,movc,Spat_targc,SRrelc,aRc,bRc,opt=T){
  qc<-exp(lnq)
  nareas<-nrow(movc)
  #areasize<-c(asizec,1-asizec)
  idist<-rep(1/nareas,nareas)
  for(i in 1:300)idist<-apply(array(idist,c(2,2))*movc,2,sum)

  N<-array(exp(-Mc[1]*((1:maxage)-1))*R0c,dim=c(maxage,nareas))*array(rep(idist,each=maxage),dim=c(maxage,nareas))
  SSN<-Mac*N   # Calculate initial spawning stock numbers
  Biomass<-N*Wac[,1]
  SSB<-SSN*Wac[,1]                               # Calculate spawning stock biomass

  B0<-sum(Biomass)
  R0a<-idist*R0
  SSB0<-apply(SSB,2,sum)
  SSBpR<-SSB0/R0a                              # Calculate spawning stock biomass per recruit

  for(y in 1:nyears){
    # set up some indices for indexed calculation
    targ<-(apply(Vc*Biomass,2,sum)^Spat_targc)/mean(apply(Vc*Biomass,2,sum)^Spat_targc)
    FMc<-array(qc*Fc[y]*Vc,dim=c(maxage,nareas))*array(rep(targ,each=maxage),dim=c(maxage,nareas))                                           # Fishing mortality rate determined by effort, catchability, vulnerability and spatial preference according to biomass
    Zc<-FMc+Mc[y]
    N[2:maxage,]<-N[1:(maxage-1),]*exp(-Zc[1:(maxage-1),])         # Total mortality
    if(SRrelc==1){
      N[1,]<-Perrc[y]*(0.8*R0a*hc*apply(SSB,2,sum))/(0.2*SSBpR*R0a*(1-hc)+(hc-0.2)*apply(SSB,2,sum))  # Recruitment assuming regional R0 and stock wide steepness
    }else{
      N[1,]<- aRc*apply(SSB,2,sum)*exp(-bRc*apply(SSB,2,sum)) 
    }
      
    #print(N[1])
    indMov<-as.matrix(expand.grid(1:nareas,1:nareas,1:maxage)[3:1])
    indMov2<-indMov[,1:2]
    indMov3<-indMov[,2:3]
    temp<-array(N[indMov2]*movc[indMov3],dim=c(nareas,nareas,maxage))
    N<-apply(temp,c(3,1),sum)
    SSN<-N*Mac
    SSB<-SSN*Wac[,y]
    Biomass<-N*Wac[,y]
    #print(sum(Biomass))
  } # end of year

  return((log(depc)-log(sum(Biomass)/B0))^2)
}

getinitdist<-function(tol,mov,indMain){
  init<-array(1/nareas,dim=c(nsim,nareas))
  ind4<-as.matrix(cbind(rep(1:nsim,each=nareas*nareas),indMain[,2]))
  i<-0
  delta<-1
  #for(i in 1:100){
  while(delta > tol){
    i<-i+1
    trial<-init
    temp<-array(init[ind4]*mov[indMain],dim=c(nareas,nareas,nsim))
    init<-apply(temp,c(3,1),sum)
    delta<-max((trial-init)^2)
  }
  print(paste("Converged in ",i," iterations"))
  init
}

getFMSY<-function(x,Marray,hs,Mat_age,Wt_age,R0,V,maxage,nyears,proyears,Spat_targ,mov,SRrel,aR,bR){
  opt<-optimize(FMSYopt,log(c(0.001,5)),
                     Mc=Marray[x,nyears],hc=hs[x],Mac=Mat_age[x,],Wac=Wt_age[x,,nyears],
                     R0c=R0,Vc=V[x,],maxage=maxage,nyears=nyears,proyears=proyears,Spat_targc=Spat_targ[x],movc=mov[x,,],SRrelc=SRrel[x],aRc=aR[x,],bRc=bR[x,],Opt=T)
  return(FMSYopt(opt$minimum,
                     Mc=Marray[x,nyears],hc=hs[x],Mac=Mat_age[x,],Wac=Wt_age[x,,nyears],
                     R0c=R0,Vc=V[x,],maxage=maxage,nyears=nyears,proyears=proyears,Spat_targc=Spat_targ[x],movc=mov[x,,],SRrelc=SRrel[x],aRc=aR[x,],bRc=bR[x,],Opt=F))
}


FMSYopt<-function(lnF,Mc,hc,Mac,Wac,R0c,Vc,maxage,nyears,proyears,Spat_targc,movc,SRrelc,aRc,bRc,Opt=T){

  FMSYc<-exp(lnF)
  nareas<-nrow(movc)
  #areasize<-c(asizec,1-asizec)
  idist<-rep(1/nareas,nareas)
  for(i in 1:100)idist<-apply(array(idist,c(2,2))*movc,2,sum)

  N<-array(exp(-Mc*((1:maxage)-1))*R0c,dim=c(maxage,nareas))*array(rep(idist,each=maxage),dim=c(maxage,nareas))
  SSN<-Mac*N   # Calculate initial spawning stock numbers
  Biomass<-N*Wac
  VBiomass<-Biomass*Vc
  SSB<-SSN*Wac                              # Calculate spawning stock biomass

  VB0<-sum(VBiomass)
  R0a<-idist*R0
  SSB0<-apply(SSB,2,sum)
  SSBpR<-SSB0/R0a

  N<-N/2                              # Calculate spawning stock biomass per recruit
  SSN<-Mac*N   # Calculate initial spawning stock numbers
  Biomass<-N*Wac
  SSB<-SSN*Wac                              # Calculate spawning stock biomass

  for(y in 1:nyears){
    # set up some indices for indexed calculation
    dis<-apply(Vc*Biomass,2,sum)/sum(Vc*Biomass)
    targ<-(dis^Spat_targc)/mean(dis^Spat_targc)
    FMc<-array(FMSYc*Vc,dim=c(maxage,nareas))*array(rep(targ,each=maxage),dim=c(maxage,nareas))                                           # Fishing mortality rate determined by effort, catchability, vulnerability and spatial preference according to biomass
    Zc<-FMc+Mc
    CN<-N*(1-exp(-Zc))*(FMc/Zc)
    CB<-CN*Wac

    N[2:maxage,]<-N[1:(maxage-1),]*exp(-Zc[1:(maxage-1),])         # Total mortality
    if(SRrelc==1){
      N[1,]<-(0.8*R0a*hc*apply(SSB,2,sum))/(0.2*SSBpR*R0a*(1-hc)+(hc-0.2)*apply(SSB,2,sum))  # Recruitment assuming regional R0 and stock wide steepness
    }else{
      N[1,]<- aRc*apply(SSB,2,sum)*exp(-bRc*apply(SSB,2,sum)) 
    }
    #print(N[1])
    N[1,]<-apply(array(N[1,],c(2,2))*movc,2,sum)
    SSN<-N*Mac
    SSB<-SSN*Wac
    Biomass<-N*Wac
    VBiomass<-Biomass*Vc
    #print(sum(Biomass))
  } # end of year

  CBc<-sum(CB)
  if(Opt){
    return(-CBc)
  }else{
    return(c(CBc,-log(1-(CBc/sum(VBiomass))),sum(VBiomass)/VB0))
  }
}

Sam<-function(DLM,Meths=NA,reps=100,maxlines=10,perc=0.5){
  nm <-deparse(substitute(DLM))
  DLM@PosMeths<-Meths
  funcs<-DLM@PosMeths
  nmeths<-length(funcs)
  DLM@Meths<-funcs
  OFLa<-getOFL(DLM,Meths=funcs,reps)
  nsim<-length(DLM@Mort)
  ref<-array(rep(DLM@Ref,nmeths),c(nsim,nmeths))
  OFLm<-apply(OFLa,c(3,1),quantile,p=perc,na.rm=T)
  OFLbias<-(OFLm-ref)/ref *100
  POF<-round(apply(OFLbias>0,2,sum)/length(DLM@Mort)*100,1)
  DLM@quota<-OFLa
  DLM@quotabias<-OFLbias
  DLM
}


getFhist<-function(nsim,Esd,nyears,dFmin,dFmax,bb){

  ne<-nsim*3                                                         # Number of simulated effort datasets
  dEfinal<-runif(ne,dFmin,dFmax)#(exp(rnorm(ne,mean=demu,sd=desd))-1)*6               # Sample the final gradient in effort
  a<-(dEfinal-bb)/nyears                                         # Derive slope to get there from intercept
  a<-array(a,dim=c(ne,nyears))                                  # Slope array
  bb<-array(bb,dim=c(ne,nyears))                                  # Intercept array
  x<-array(rep(1:nyears,each=ne),dim=c(ne,nyears))              # Year array
  dE<-a*x+bb                                                     # Change in effort
  E<-array(NA,dim=c(ne,nyears))                                 # Define total effort array
  E[,1]<-dE[,1]
  for(y in 2:nyears){
    E[,y]<-apply(dE[,1:y],1,sum)
  }
  E<-E/array(apply(E,1,mean),dim=c(ne,nyears))                  # Standardise Effort to average 1
  cond<-apply(E,1,min)>0
  pos<-(1:ne)[cond]
  pos<-pos[1:nsim]
  #environment("dEfinal")<-asNamespace('DLMtool')#assign("dFfinal",dEfinal[pos],envir=.GlobalEnv)
  
  E<-E[pos,]                                 # Sample only those without negative effort
  Emu<--0.5*Esd^2
  Eerr<-array(exp(rnorm(nyears*nsim,rep(Emu,nyears),rep(Esd,nyears))),c(nsim,nyears))
  outy<-new('list')
  outy[[1]]<-E*Eerr
  outy[[2]]<-dEfinal[pos]
  outy
}

densnorm<-function(sd1){   # difference in density from 0.05 given a standard deviation sd1 (sd_asc) and age at maximum vulnerability modo
  (0.05-(dnorm(0,mod[i],sd1)/dnorm(mod[i],mod[i],sd1)))^2
}

densnormasc<-function(sd1,age_05,mody){
  (0.05-(dnorm(age_05,mody,sd1)/dnorm(mody,mody,sd1)))^2
}

getsdasc<-function(sm,age05,mod){
  optimize(densnormasc,interval=c(0.5,100),age_05=age05[sm],mody=mod[sm])$minimum
}

densnormdesc<-function(sd2,V_maxage,maxy,mody){
  (V_maxage-(dnorm(maxy,mody,sd2)/dnorm(mody,mody,sd2)))^2
}

getsddesc<-function(sm,Vmaxage,maxage,mod){
  optimize(densnormdesc,interval=c(0.5,10000),V_maxage=Vmaxage[sm],maxy=maxage,mody=mod[sm])$minimum
}

getDNvulnS<-function(mod,age05,Vmaxage,maxage,nsim){
  sd_asc<-sapply(1:nsim,getsdasc,age05=age05,mod=mod)
  sd_desc<-sapply(1:nsim,getsddesc,Vmaxage=Vmaxage,maxage=maxage,mod=mod)
  V<-array(NA,dim=c(nsim,maxage))
  for(i in 1:nsim){
    V[i,1:ceiling(mod[i])]<-dnorm(1:ceiling(mod[i]),mod[i],sd_asc[i])
    V[i,(1+ceiling(mod[i])):maxage]<-dnorm((1+ceiling(mod[i])):maxage,mod[i],sd_desc[i])
    V[i,(1+ceiling(mod[i])):maxage]<-V[i,(1+ceiling(mod[i])):maxage]/V[i,1+ceiling(mod[i])]#/V[i,floor(mod[i])+1]
    V[i,1:ceiling(mod[i])]<-V[i,1:ceiling(mod[i])]/dnorm(mod[i],mod[i],sd_asc[i])#,mod[i],sd_asc[i])#V[i,floor(mod[i])]

  }
  outy<-new('list')
  outy[[1]]<-V
  outy[[2]]<-mod-1.18*sd_asc
  outy
}

gettempvar<-function(targ,targsd,targgrad,nyears,nsim){   # creates a time series per simulation that has gradient grad and random normal walk wiht sigma
  mutemp<--0.5*targsd^2
  temp<-array(1,dim=c(nsim,nyears))
  for(i in 2:nyears){
    temp[,i]<-temp[,i]*exp(rnorm(nsim,mutemp,targsd))
  }
  yarray<-array(rep((1:nyears)-1,each=nsim),dim=c(nsim,nyears))
  temp<-temp*(1+targgrad/100)^yarray
  targ*temp/apply(temp,1,mean)
}


getFref<-function(x,Marray,Wt_age,Mat_age,Perr,N_s,SSN_s, Biomass_s,VBiomass_s,SSB_s,
                  Vn,hs,R0a,nyears,proyears,nareas,maxage,mov,SSBpR,aR,bR,SRrel){
  
  opt<-optimize(doprojPI,log(c(0.001,10)),
                Mvec=Marray[x,(nyears+1):(nyears+proyears)],Wac=Wt_age[x,,(nyears+1):(nyears+proyears)],Mac=Mat_age[x,],
                Pc=Perr[x,(nyears+1):(nyears+proyears)],N_c=N_s[x,,],SSN_c=SSN_s[x,,],Biomass_c=Biomass_s[x,,],
                VBiomass_c=VBiomass_s[x,,],SSB_c=SSB_s[x,,],Vc=Vn[x,],hc=hs[x],R0ac=R0a[x,],proyears,nareas,maxage,movc=mov[x,,],SSBpRc=SSBpR[x],aRc=aR[x,],bRc=bR[x,],SRrelc=SRrel[x])
  
  return(-opt$objective)
  
}

doprojPI<-function(lnF,Mvec,Wac,Mac,Pc,N_c,SSN_c,Biomass_c,VBiomass_c,SSB_c,Vc,hc,R0ac,proyears,nareas,maxage,movc,SSBpRc,aRc,bRc,SRrelc){
  
  FF<-exp(lnF)
  
  N_P<-array(NA,dim=c(maxage,proyears,nareas))
  Biomass_P<-array(NA,dim=c(maxage,proyears,nareas))
  VBiomass_P<-array(NA,dim=c(maxage,proyears,nareas))
  SSN_P<-array(NA,dim=c(maxage,proyears,nareas))
  SSB_P<-array(NA,dim=c(maxage,proyears,nareas))
  FM_P<-array(NA,dim=c(maxage,proyears,nareas))
  Z_P<-array(NA,dim=c(maxage,proyears,nareas))
  CB_P<-rep(NA,proyears)
  
  AYR<-as.matrix(expand.grid(1:maxage,1,1:nareas))
  YA<-as.matrix(expand.grid(1,1:maxage))         # Projection year
  Y<-YA[,1]
  A<-YA[,2]
  AY<-YA[,c(2,1)]
  
  N_P[AYR]<-N_c#[AYRL]
  SSN_P[AYR]<-SSN_c#SSN[AYRL]
  Biomass_P[AYR]<-Biomass_c#[AYRL]
  VBiomass_P[AYR]<-VBiomass_c#[AYRL]
  SSB_P[AYR]<-SSB_c#[AYRL]
  
  FM_P[AYR]<-FF*Vc[A]
  Z_P[AYR]<-FM_P[A]+Mvec[Y]
  
  for(y in 2:proyears){
    
    AY1R<-as.matrix(expand.grid(1:maxage,y-1,1:nareas))
    AYR<-as.matrix(expand.grid(1:maxage,y,1:nareas))
    Y<-AYR[,2]
    A<-AYR[,1]
    AY<-AYR[,1:2]
    R<-AYR[,3]
    A2YR<-as.matrix(expand.grid(2:maxage,y,1:nareas))
    A1YR<-as.matrix(expand.grid(1:(maxage-1),y-1,1:nareas))
    A1Y<-as.matrix(expand.grid(1:(maxage-1),y-1))
    
    indMov<-as.matrix(expand.grid(1:nareas,1:nareas,y,1:maxage)[4:1])
    indMov2<-indMov[,c(1,2,3)]
    indMov3<-indMov[,c(3,4)]
    
    N_P[A2YR]<-N_P[A1YR]*exp(-Z_P[A1Y])         # Total mortality
    
    if(SRrelc==1){
      N_P[1,y,]<-Pc[y]*(0.8*R0ac*hc*apply(SSB_P[,y-1,],2,sum))/(0.2*SSBpRc*R0ac*(1-hc)+(hc-0.2)*apply(SSB_P[,y-1,],2,sum))  # Recruitment assuming regional R0 and stock wide steepness
    }else{
      N_P[1,y,]<-Pc[y]*aRc*apply(SSB_P[,y-1,],2,sum)*exp(-bRc*apply(SSB_P[,y-1,],2,sum))  
    }
    
    temp<-array(N_P[indMov2]*movc[indMov3],dim=c(nareas,nareas,maxage))  # Move individuals
    N_P[,y,]<-apply(temp,c(3,1),sum)
    
    Biomass_P[AYR]<-N_P[AYR]*Wac[AY]                                    # Calculate biomass
    VBiomass_P[AYR]<-Biomass_P[AYR]*Vc[A]                       # Calculate vulnerable biomass
    SSN_P[AYR]<-N_P[AYR]*Mac[A]                                       # Calculate spawning stock numbers
    SSB_P[AYR]<-SSN_P[AYR]*Wac[AY] # Calculate spawning stock biomass
    FM_P[AYR]<-FF*Vc[A]
    Z_P[AYR]<-FM_P[AYR]+Mvec[Y]
    CNtemp<-N_P[,y,]*exp(Z_P[,y,])*(1-exp(-Z_P[,y,]))*(FM_P[,y,]/Z_P[,y,])
    CB_P[y]<-sum(Biomass_P[,y,]*exp(Z_P[,y,])*(1-exp(-Z_P[,y,]))*(FM_P[,y,]/Z_P[,y,]))
    
  } # end of year
  
  return(-mean(CB_P[(proyears-min(4,(proyears-1))):proyears],na.rm=T))
  
}

comp<-function(MSEobj,Meths=NA){
  
  if(is.na(Meths))Meths<-MSEobj@meths
  notm<-Meths[!(Meths%in%MSEobj@meths)]
  canm<-Meths[Meths%in%MSEobj@meths]
  if(length(notm)>0)print(paste("Methods",paste(notm,collapse=", "),"were not carried out in MSE",deparse(substitute(MSEobj)),sep=" "))
  
  if(length(canm)==0)stop(paste('None of the methods you specified were carried out in the MSE', deparse(substitute(MSEobj)),sep=""))
  
  if(length(canm)>4){
    print(paste('A maximum of four methods can be compared at once. Plotting first four:',paste(canm[1:4],collapse=", "),sep=" "))
    canm<-canm[1:4]
  } 
  
  mind<-match(canm,MSEobj@meths)
  nm<-length(mind)
  nsim<-MSEobj@nsim
  proyears<-MSEobj@proyears
  
  Yd<-array(NA,c(nm,nsim))
  P10<-array(NA,c(nm,nsim))
  P50<-array(NA,c(nm,nsim))
  P100<-array(NA,c(nm,nsim))
  POF<-array(NA,c(nm,nsim))
  yind<-max(MSEobj@proyears-4,1):MSEobj@proyears
  RefYd<-MSEobj@OM$RefY
  
  for(m in 1:nm){
    mm<-mind[m]
    Yd[m,]<-round(apply(MSEobj@C[,mm,yind],1,mean,na.rm=T)/RefYd*100,1)
    POF[m,]<-round(apply(MSEobj@F_FMSY[,mm,]>1,1,sum,na.rm=T)/proyears*100,1)
    P10[m,]<-round(apply(MSEobj@B_BMSY[,mm,]<0.1,1,sum,na.rm=T)/proyears*100,1)
    P50[m,]<-round(apply(MSEobj@B_BMSY[,mm,]<0.5,1,sum,na.rm=T)/proyears*100,1)
    P100[m,]<-round(apply(MSEobj@B_BMSY[,mm,]<1,1,sum,na.rm=T)/proyears*100,1)
  }
  
  MSEcols<-c('red','green','blue','orange')
  
  #dev.new2(width=7,height=7)
  par(mfrow=c(2,2),mai=c(0.85,0.7,0.1,0.1),omi=rep(0.01,4))
  
  tradeoffplot2(POF,Yd,"Prob. of overfishing (%)", "Relative yield",vl=50,hl=100,coly=MSEcols,leg=NA)
  tradeoffplot2(P100,Yd,"Prob. biomass < BMSY (%)", "Relative yield",vl=50,hl=100,coly=MSEcols,leg=canm)
  tradeoffplot2(P50,Yd,"Prob. biomass < 0.5BMSY (%)", "Relative yield",vl=50,hl=100,coly=MSEcols,leg=NA)
  tradeoffplot2(P10,Yd,"Prob. biomass < 0.1BMSY (%)", "Relative yield",vl=50,hl=100,coly=MSEcols,leg=NA)
  
}

setMethod("summary",
          signature(object = "MSE"),
          function(object){            

    MSEobj<-object      
    nm<-MSEobj@nmeths
    nsim<-MSEobj@nsim
    proyears<-MSEobj@proyears
    
    Yd<-array(NA,c(nm,nsim))
    P10<-array(NA,c(nm,nsim))
    P50<-array(NA,c(nm,nsim))
    P100<-array(NA,c(nm,nsim))
    POF<-array(NA,c(nm,nsim))
    yind<-max(MSEobj@proyears-4,1):MSEobj@proyears
    RefYd<-MSEobj@OM$RefY
        
    for(m in 1:nm){
      Yd[m,]<-round(apply(MSEobj@C[,m,yind],1,mean,na.rm=T)/RefYd*100,1)
      POF[m,]<-round(apply(MSEobj@F_FMSY[,m,]>1,1,sum,na.rm=T)/proyears*100,1)
      P10[m,]<-round(apply(MSEobj@B_BMSY[,m,]<0.1,1,sum,na.rm=T)/proyears*100,1)
      P50[m,]<-round(apply(MSEobj@B_BMSY[,m,]<0.5,1,sum,na.rm=T)/proyears*100,1)
      P100[m,]<-round(apply(MSEobj@B_BMSY[,m,]<1,1,sum,na.rm=T)/proyears*100,1)
    }
    nr<-2
    out<-cbind(MSEobj@meths,round(apply(Yd,1,mean,na.rm=T),nr),round(apply(Yd,1,sd,na.rm=T),nr),
                             round(apply(POF,1,mean,na.rm=T),nr),round(apply(POF,1,sd,na.rm=T),nr),
                             round(apply(P10,1,mean,na.rm=T),nr),round(apply(P10,1,sd,na.rm=T),nr),
                             round(apply(P50,1,mean,na.rm=T),nr),round(apply(P50,1,sd,na.rm=T),nr),
                             round(apply(P100,1,mean,na.rm=T),nr),round(apply(P100,1,sd,na.rm=T),nr))
    out<-as.data.frame(out)
    names(out)<-c("Method","Yield","","POF"," ","P10","  ",
                  "P50","   ","P100","    ")
    out[,1]<-as.character(out[,1])
    for(i in 2:ncol(out))out[,i]<-as.numeric(as.character(out[,i]))
    out
  })
