% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_current_timestamp.R
\name{get_current_timestamp}
\alias{get_current_timestamp}
\title{Quickly get the current time stamp without the
  need to handle format-options etc.}
\usage{
get_current_timestamp(no_spaces = FALSE)
}
\arguments{
\item{no_spaces}{Boolean. Default = `FALSE`. Specifies whether the output
can contain spaces or not. E.g. if the output is for human reading,
`no_spaces = FALSE` is a good option. As suffix for file names
(e.g. logfiles), `no_spaces = TRUE` might be a good option.}
}
\value{
The current timestamp in always the same format.
#'
}
\description{
Function to quickly get the current time stamp without
  need to handle format-options etc.
}
\examples{
get_current_timestamp(no_spaces = TRUE)
# Result: "2020-12-03-134354"
get_current_timestamp()
# this is the same like
get_current_timestamp(no_spaces = FALSE)
# Result: "03.12.2020 - 13:43 UTC"

}
