% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{getRandomState}
\alias{getRandomState}
\title{Record and restore a random state}
\usage{
getRandomState(seed = NULL)
}
\arguments{
\item{seed}{seed argument to set.seed(). NULL = no seed, but random state will be restored. F = random state will not be restored}
}
\value{
a list with various infos about the random state that after function execution, as well as a function to restore the previous state before the function execution
}
\description{
The aim of this function is to record, manipualate and restor a random state
}
\details{
This function is intended for two (not mutually exclusive tasks)

a) record the current random state

b) change the current random state in a way that the previous state can be restored
}
\examples{
# testing the function in standard settings

set.seed(13)
runif(1)
x = getRandomState(123)
runif(1)
x$restoreCurrent()
runif(1)

# values outside set /restore are identical to

set.seed(13)
runif(2)

# if no seed is set, this will also be restored

rm(.Random.seed)

x = getRandomState(123)
runif(1)
x$restoreCurrent()
exists(".Random.seed")

# with false 

rm(.Random.seed)
x = getRandomState(seed = FALSE)
exists(".Random.seed")
runif(1)
x$restoreCurrent()
exists(".Random.seed")
}
\author{
Florian Hartig
}
