% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{getHexagon}
\alias{getHexagon}
\title{Calculate a 3D hexagon}
\usage{
getHexagon(area = NA, outer.radius = NA, inner.radius = NA, z = c(0, 1))
}
\arguments{
\item{area}{the area of the hexagon}

\item{outer.radius}{the outer radius of the hexagon}

\item{inner.radius}{the inner radius of the hexagon}

\item{z}{the height of the hexagon as 2 element vector}
}
\value{
a \code{\link{TriangBody-class}}
}
\description{
Calculate a 3D hexagon
}
\examples{
if (require(rgl)) {
  hexagon <- getHexagon(area=dgvm3d.options("patch.area"), z=c(0, -2))
  triangles3d(hexagon@vertices[hexagon@id, ], col="brown")
} else {
  message("the library 'rgl' is required for this example!")
}
}
