% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterGenes.R
\name{filterGenes}
\alias{filterGenes}
\title{Filter rows out of a matrix.}
\usage{
filterGenes(inputMat, filterTypes = "central", keepRows = NULL,
  filterCentralType = "median", filterDispersionType = "dispersion_index",
  filterCentralPercentile = 0.25, filterDispersionPercentile = 0.25,
  sequential = FALSE, allGroups = FALSE, design = NULL)
}
\arguments{
\item{inputMat}{The matrix (or data.frame) of all numeric values (e.g., gene expression values from an RNA-seq or microarray study) that you are interested in analyzing. The rownames of this matrix should correspond to the identifiers that you are interested in protecting from the filter, if any.}

\item{filterTypes}{Vector containing up to two character strings, specifying the methods that should be used for filtering genes. Options include "central" and "dispersion" for filtering based on the measures of central tendency and dispersion, respectively. To use both, set this to c("central", "dispersion").}

\item{keepRows}{Optional character vector, specifying rownames (i.e., symbols) that should not be filtered out of the matrix even if they are found to be below the quantile specified for either the central tendency or dispersion, as applicable.}

\item{filterCentralType}{Method to be used for filtering for the central tendency of the input matrix. Options = "mean" (for arithmetic mean) and "median".}

\item{filterDispersionType}{Method to be used for filtering for the dispersion of the input matrix. Options = "dispersion_index", "cv" (for coefficient of variation), and "variance".}

\item{filterCentralPercentile}{If central tendency filtering is used, the quantile of the central tendency below which rows will be filtered out.}

\item{filterDispersionPercentile}{If dispersion filtering is used, the quantile of the dispersion measure below which rows will be filtered out.}

\item{sequential}{If both central tendency and dispersion measures and used for filtering the input matrix, then sequential is a logical flag indicating whether the central tendency filtering steps should be performed prior to the dispersion filtering step (and quantile cutoff specification; if sequential = TRUE), or independently (if sequential = FALSE).}

\item{allGroups}{Logical for whether genes need to pass the filter in all of the groups specified in the design matrix.}

\item{design}{A standard model.matrix created design matrix. Rows correspond to samples and colnames refer to the names of the conditions that you are interested in analyzing. Only 0's or 1's are allowed in the design matrix. Please see vignettes for more information.}
}
\value{
A filtered matrix.
}
\description{
Filter out rows in an input matrix that are not above a certain percentile with respect to a central tendency and/or dispersion measure. To be used, e.g, prior to differential correlation testing with the function ddcorall.
}
\examples{
data(darmanis); data(design_mat); darmanis_subset = darmanis[1:30, ]
filtered_mat = filterGenes(inputMat = darmanis_subset, filterTypes = "central")
filtered_mat_both = filterGenes(inputMat = darmanis_subset,
 filterTypes = c("central", "dispersion"), filterCentralType = "mean",
 filterDispersionPercentile = 0.1)
filtered_mat_all_groups = filterGenes(inputMat = darmanis_subset,
 design = design_mat, filterTypes = "dispersion", allGroups = TRUE)
}

